/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.UploadProgressStatus;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class UploadTaskProgressStatus
extends DefaultTaskProgressStatus
implements UploadProgressStatus {
    private final long progressInterval;
    private final Date startDate;
    private ConcurrentHashMap<String, ProgressStatus> taskTable = new ConcurrentHashMap();
    private AtomicLong totalSize = new AtomicLong();
    private AtomicLong totalMilliseconds = new AtomicLong();
    private AtomicLong endingTaskSize = new AtomicLong();
    private AtomicLong taskTagSize = new AtomicLong();

    public UploadTaskProgressStatus(long progressInterval, Date startDate) {
        this.progressInterval = progressInterval;
        this.startDate = ServiceUtils.cloneDateIgnoreNull(startDate);
    }

    public void setTaskTagSize(long taskTagSize) {
        this.taskTagSize = new AtomicLong(taskTagSize);
    }

    public long getTaskTagSize() {
        return this.taskTagSize.get();
    }

    public boolean isRefreshprogress() {
        long taskSize;
        if (this.progressInterval <= 0L) {
            return false;
        }
        long transferredSize = this.getTransferredSize();
        if (transferredSize - (taskSize = this.getTaskTagSize()) >= this.progressInterval) {
            this.setTaskTagSize(transferredSize);
            return true;
        }
        return false;
    }

    @Override
    public long getTotalSize() {
        if (this.getTotalTaskNum() <= 0) {
            return -1L;
        }
        return this.totalSize.get();
    }

    @Override
    public long getTransferredSize() {
        long transferredSize = this.endingTaskSize.get();
        ConcurrentHashMap<String, ProgressStatus> taskStatusTable = new ConcurrentHashMap<String, ProgressStatus>(this.taskTable);
        for (Map.Entry<String, ProgressStatus> entry : taskStatusTable.entrySet()) {
            transferredSize += entry.getValue().getTransferredBytes();
        }
        return transferredSize;
    }

    @Override
    public double getInstantaneousSpeed() {
        if (this.taskTable != null) {
            long instantaneousSpeed = 0L;
            for (Map.Entry<String, ProgressStatus> entry : this.taskTable.entrySet()) {
                instantaneousSpeed = (long)((double)instantaneousSpeed + entry.getValue().getInstantaneousSpeed());
            }
            return instantaneousSpeed;
        }
        return -1.0;
    }

    @Override
    public double getAverageSpeed() {
        if (this.totalMilliseconds.get() <= 0L) {
            return -1.0;
        }
        return (double)this.getTransferredSize() * 1000.0 / (double)this.totalMilliseconds.get();
    }

    @Override
    public ConcurrentHashMap<String, ProgressStatus> getTaskTable() {
        ConcurrentHashMap<String, ProgressStatus> taskStatusTable = new ConcurrentHashMap<String, ProgressStatus>(this.taskTable);
        return taskStatusTable;
    }

    @Override
    public ProgressStatus getTaskStatus(String key) {
        return this.taskTable.get(key);
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = new AtomicLong(totalSize);
    }

    public void addTotalSize(long bytes) {
        this.totalSize.addAndGet(bytes);
    }

    public void setTaskTable(ConcurrentHashMap<String, ProgressStatus> taskTable) {
        this.taskTable = taskTable;
    }

    public void putTaskTable(String key, ProgressStatus status) {
        this.taskTable.put(key, status);
    }

    public void removeTaskTable(String key) {
        if (null == this.taskTable) {
            return;
        }
        this.taskTable.remove(key);
    }

    public long getTotalMilliseconds() {
        return this.totalMilliseconds.get();
    }

    public void setTotalMilliseconds(long totalMilliseconds) {
        this.totalMilliseconds = new AtomicLong(totalMilliseconds);
    }

    public long getEndingTaskSize() {
        return this.endingTaskSize.get();
    }

    public void setEndingTaskSize(long endingTaskSize) {
        this.endingTaskSize = new AtomicLong(endingTaskSize);
    }

    public void addEndingTaskSize(long bytes) {
        this.endingTaskSize.addAndGet(bytes);
    }

    public Date getStartDate() {
        return ServiceUtils.cloneDateIgnoreNull(this.startDate);
    }
}

