/*
 * Decompiled with CFR 0.152.
 */
package weaver.rsa.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import weaver.rsa.security.Base64;
import weaver.rsa.security.IOUtils;

public class PublicKeyReader {
    public static PublicKey get(String filename) throws Exception {
        FileInputStream fis = new FileInputStream(new File(filename));
        PublicKey pk = PublicKeyReader.get(fis);
        fis.close();
        return pk;
    }

    public static PublicKey getFromBase64(String filename) throws Exception {
        FileInputStream fis = new FileInputStream(new File(filename));
        PublicKey pk = PublicKeyReader.getFromBase64(fis);
        fis.close();
        return pk;
    }

    public static PublicKey getFromBase64String(String publicKeyString) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(publicKeyString.getBytes());
        return PublicKeyReader.getFromBase64(is);
    }

    public static PublicKey get(InputStream input) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)os);
        byte[] keyBytes = os.toByteArray();
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    public static PublicKey getFromBase64(InputStream input) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)os);
        byte[] keyBytes = os.toByteArray();
        byte[] ks = Base64.decodeBase64(keyBytes);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(ks);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }
}

