/*
 * Decompiled with CFR 0.152.
 */
package weaver.rsa.security;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import weaver.rsa.security.Base64;
import weaver.rsa.security.Const;
import weaver.rsa.security.FileUtils;
import weaver.rsa.security.PrivateKeyReader;
import weaver.rsa.security.PublicKeyReader;

public class RSA {
    private static final String PUB_KEY_NAME = "rsa_2048_pub.key";
    private static final String PRI_KEY_NAME = "rsa_2048_priv.key";
    private static String RSA_PUB = null;
    private static String RSA_PUB_FILE = null;
    private static PrivateKey PRI_KEY = null;
    private static Cipher DECRYPT_CIPHER = null;
    private static final String RSA_FLAG = "``RSA``";
    private String salt = "";
    private int saltLen = 0;
    private static boolean initRsASuccess = false;
    private String message = "0";

    static {
        try {
            String rootPath = RSA.getProjectPath();
            System.out.println("============rootPath:::" + rootPath);
            try {
                RSA_PUB_FILE = String.valueOf(rootPath) + "keys" + File.separator + PUB_KEY_NAME;
                File rpf = new File(RSA_PUB_FILE);
                RSA_PUB = FileUtils.readFileToString(rpf, Const.UTF8_CHARSET);
                if (RSA_PUB == null) {
                    RSA.genarateKeyFiles(rootPath, Const.UTF8_CHARSET);
                    RSA_PUB = FileUtils.readFileToString(rpf, Const.UTF8_CHARSET);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                RSA.genarateKeyFiles(rootPath, Const.UTF8_CHARSET);
                RSA_PUB = FileUtils.readFileToString(new File(String.valueOf(rootPath) + "keys" + File.separator + PUB_KEY_NAME), Const.UTF8_CHARSET);
            }
            System.out.println("RSA_PUB:::" + RSA_PUB);
            PRI_KEY = PrivateKeyReader.getFromBase64(String.valueOf(rootPath) + "keys" + File.separator + PRI_KEY_NAME);
            DECRYPT_CIPHER = Cipher.getInstance("RSA");
            DECRYPT_CIPHER.init(2, PRI_KEY);
            initRsASuccess = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getProjectPath() {
        URL url = RSA.class.getProtectionDomain().getCodeSource().getLocation();
        String realPath = null;
        try {
            realPath = URLDecoder.decode(url.getPath(), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (realPath.endsWith(".jar")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/") + 1);
        }
        System.out.println("before skip real path:::::" + realPath);
        if (realPath.startsWith("file:")) {
            realPath = realPath.substring(5);
        }
        System.out.println("skip file:::::" + realPath);
        int pos = realPath.indexOf("RSA");
        System.out.println("RSA POS:::" + pos);
        if (pos != -1) {
            realPath = realPath.substring(0, pos);
        }
        return realPath;
    }

    public String getMessage() {
        return this.message;
    }

    public static String getRsaFlag() {
        return RSA_FLAG;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getSalt() {
        return this.salt;
    }

    public String encrypt(String value) {
        return this.encrypt(null, value);
    }

    public String encrypt(HttpServletRequest req, String value) {
        return this.encrypt(req, value, this.generateSalt(), "UTF-8");
    }

    public String encrypt(HttpServletRequest req, String value, String salt) {
        return this.encrypt(req, value, salt, "UTF-8");
    }

    public String encrypt(HttpServletRequest req, String value, String salt, String charset) {
        return this.encrypt(req, value, salt, charset, RSA_PUB_FILE, true);
    }

    public String encrypt(HttpServletRequest req, String value, String salt, String charset, String rsaPublicFile, boolean isFile) {
        if (!initRsASuccess) {
            this.message = "-3";
            return value;
        }
        if (value == null || "".equals(value)) {
            this.message = "-6";
        }
        if (rsaPublicFile == null) {
            rsaPublicFile = RSA_PUB_FILE;
        }
        String result = "";
        try {
            byte[] msgBytes;
            if (salt != null && !salt.equals("")) {
                value = String.valueOf(value) + salt;
                this.salt = salt;
            }
            if ((msgBytes = value.getBytes(charset)).length <= 245) {
                PublicKey publicKey = null;
                publicKey = isFile ? PublicKeyReader.getFromBase64(rsaPublicFile) : PublicKeyReader.getFromBase64String(rsaPublicFile);
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, publicKey);
                byte[] results = cipher.doFinal(msgBytes);
                if (req != null) {
                    req.getSession().setAttribute("rsa_code", (Object)salt);
                }
                return Base64.encodeBase64String(results);
            }
            this.message = "-4";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "-2";
        }
        return result;
    }

    public String encryptCommon(String value) {
        return this.encryptCommon(null, value);
    }

    public String encryptCommon(HttpServletRequest req, String value) {
        return this.encryptCommon(req, value, this.generateSalt(), "UTF-8");
    }

    public String encryptCommon(HttpServletRequest req, String value, String salt) {
        return this.encryptCommon(req, value, salt, "UTF-8");
    }

    public String encryptCommon(HttpServletRequest req, String value, String salt, String charset) {
        return this.encryptCommon(req, value, salt, charset, RSA_PUB_FILE, true);
    }

    public String encryptCommon(HttpServletRequest req, String value, String salt, String charset, String rsaPublicFile, boolean isFile) {
        if (!initRsASuccess) {
            this.message = "-3";
            return value;
        }
        if (value == null || "".equals(value)) {
            this.message = "-6";
        }
        if (rsaPublicFile == null) {
            rsaPublicFile = RSA_PUB_FILE;
        }
        String result = "";
        try {
            byte[] msgBytes = value.getBytes(charset);
            if (msgBytes.length <= 245) {
                PublicKey publicKey = null;
                publicKey = isFile ? PublicKeyReader.getFromBase64(rsaPublicFile) : PublicKeyReader.getFromBase64String(rsaPublicFile);
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, publicKey);
                byte[] results = cipher.doFinal(msgBytes);
                return Base64.encodeBase64String(results);
            }
            this.message = "-4";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "-2";
        }
        return result;
    }

    public String generateSalt() {
        return this.generateSalt(null);
    }

    public String generateSalt(HttpServletRequest req) {
        SecureRandom ranGen = new SecureRandom();
        byte[] aesKey = new byte[4];
        ((Random)ranGen).nextBytes(aesKey);
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < aesKey.length) {
            String hex = Integer.toHexString(0xFF & aesKey[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++i;
        }
        if (req != null) {
            req.getSession().setAttribute("rsa_code", (Object)hexString.toString());
        }
        return hexString.toString();
    }

    public List<String> decryptList(List<String> value) {
        return this.decryptList(null, value);
    }

    public List<String> decryptList(HttpServletRequest req, List<String> value) {
        return this.decryptList(req, value, false);
    }

    public List<String> decryptList(HttpServletRequest req, List<String> value, boolean forceDecrypt) {
        return this.decryptList(req, value, forceDecrypt, "UTF-8");
    }

    public List<String> decryptList(HttpServletRequest req, List<String> value, boolean forceDecrypt, String charset) {
        if (value == null || value.size() == 0) {
            this.message = "-6";
            return value;
        }
        ArrayList<String> decryptValue = new ArrayList<String>();
        try {
            int i = 0;
            while (i < value.size()) {
                String v = value.get(i);
                if (v == null || "".equals(v)) {
                    decryptValue.add(v);
                } else {
                    decryptValue.add(this.decrypt(req, v, forceDecrypt, charset, true));
                }
                ++i;
            }
        }
        finally {
            this.removeRsaCode(req);
        }
        return decryptValue;
    }

    public String decrypt(String value) {
        return this.decrypt(null, value, false);
    }

    public String decrypt(HttpServletRequest req, String value) {
        return this.decrypt(req, value, false);
    }

    public String decrypt(HttpServletRequest req, String value, boolean forceDecrypt) {
        return this.decrypt(req, value, forceDecrypt, "UTF-8");
    }

    public String decrypt(HttpServletRequest req, String value, boolean forceDecrypt, String charset) {
        return this.decrypt(req, value, forceDecrypt, charset, false);
    }

    public String decrypt(HttpServletRequest req, String value, boolean forceDecrypt, String charset, boolean keepSession) {
        String result;
        block14: {
            if (!initRsASuccess) {
                this.message = "-3";
                return value;
            }
            result = "";
            try {
                if (value == null || "".equals(value)) {
                    this.message = "-6";
                    String string = value;
                    return string;
                }
                if (forceDecrypt || value.endsWith(RSA_FLAG)) {
                    if (value.endsWith(RSA_FLAG)) {
                        value = value.substring(0, value.indexOf(RSA_FLAG));
                    }
                    result = new String(DECRYPT_CIPHER.doFinal(Base64.decodeBase64(value)), charset);
                    if (req != null) {
                        String rsa_code = (String)req.getSession().getAttribute("rsa_code");
                        if (this.saltLen == 0) {
                            this.saltLen = this.salt != null && !this.salt.equals("") ? this.salt.length() : 8;
                        }
                        String salt = result.substring(result.length() - this.saltLen);
                        result = result.substring(0, result.length() - this.saltLen);
                        if (rsa_code == null || "".equals(rsa_code) || !rsa_code.equals(salt)) {
                            this.message = "-1";
                            result = "";
                        }
                    }
                    break block14;
                }
                String string = value;
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "-2";
            }
            finally {
                if (req != null && !keepSession) {
                    this.removeRsaCode(req);
                }
            }
        }
        return result;
    }

    public List<String> decryptCommonList(List<String> value) {
        return this.decryptCommonList(null, value);
    }

    public List<String> decryptCommonList(HttpServletRequest req, List<String> value) {
        return this.decryptCommonList(req, value, true);
    }

    public List<String> decryptCommonList(HttpServletRequest req, List<String> value, boolean forceDecrypt) {
        return this.decryptCommonList(req, value, forceDecrypt, "UTF-8");
    }

    public List<String> decryptCommonList(HttpServletRequest req, List<String> value, boolean forceDecrypt, String charset) {
        if (value == null || value.size() == 0) {
            this.message = "-6";
            return value;
        }
        ArrayList<String> decryptValue = new ArrayList<String>();
        int i = 0;
        while (i < value.size()) {
            String v = value.get(i);
            if (v == null || "".equals(v)) {
                decryptValue.add(v);
            } else {
                decryptValue.add(this.decryptCommon(req, v, forceDecrypt, charset, true));
            }
            ++i;
        }
        return decryptValue;
    }

    public String decryptCommon(String value) {
        return this.decryptCommon(null, value, true);
    }

    public String decryptCommon(HttpServletRequest req, String value) {
        return this.decryptCommon(req, value, true);
    }

    public String decryptCommon(HttpServletRequest req, String value, boolean forceDecrypt) {
        return this.decryptCommon(req, value, forceDecrypt, "UTF-8");
    }

    public String decryptCommon(HttpServletRequest req, String value, boolean forceDecrypt, String charset) {
        return this.decryptCommon(req, value, forceDecrypt, charset, true);
    }

    public String decryptCommon(HttpServletRequest req, String value, boolean forceDecrypt, String charset, boolean keepSession) {
        if (!initRsASuccess) {
            this.message = "-3";
            return value;
        }
        String result = "";
        try {
            if (value == null || "".equals(value)) {
                this.message = "-6";
                return value;
            }
            if (forceDecrypt || value.endsWith(RSA_FLAG)) {
                if (value.endsWith(RSA_FLAG)) {
                    value = value.substring(0, value.indexOf(RSA_FLAG));
                }
                result = new String(DECRYPT_CIPHER.doFinal(Base64.decodeBase64(value)), charset);
                return result;
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "-2";
            return result;
        }
    }

    public void removeRsaCode(HttpServletRequest req) {
        if (req != null) {
            req.getSession().removeAttribute("rsa_code");
        }
    }

    private static void genarateKeyFiles(String path, Charset charset) throws Throwable {
        path = String.valueOf(path) + "keys" + File.separator;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String publicKey64 = Base64.encodeBase64String(publicKey.getEncoded());
        FileUtils.writeStringToFile(new File(String.valueOf(path) + PUB_KEY_NAME), publicKey64, charset);
        String privateKey64 = Base64.encodeBase64String(privateKey.getEncoded());
        FileUtils.writeStringToFile(new File(String.valueOf(path) + PRI_KEY_NAME), privateKey64, charset);
    }

    public static String getRSA_PUB() {
        return RSA_PUB;
    }

    public int getSaltLen() {
        return this.saltLen;
    }

    public void setSaltLen(int saltLen) {
        this.saltLen = saltLen;
    }
}

