/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.ECSMetadataServiceCredentialsFetcher;
import com.aliyuncs.auth.InstanceProfileCredentials;
import com.aliyuncs.exceptions.ClientException;

public class InstanceProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private InstanceProfileCredentials credentials = null;
    public int ecsMetadataServiceFetchCount = 0;
    private ECSMetadataServiceCredentialsFetcher fetcher;
    private static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    private int maxRetryTimes = 3;
    private final String roleName;

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        this.fetcher.setRoleName(this.roleName);
        return this;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        if (this.credentials == null || this.credentials.isExpired()) {
            ++this.ecsMetadataServiceFetchCount;
            this.credentials = this.fetcher.fetch(this.maxRetryTimes);
        } else if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                ++this.ecsMetadataServiceFetchCount;
                this.credentials = this.fetcher.fetch();
            }
            catch (ClientException e) {
                this.credentials.setLastFailedRefreshTime();
            }
        }
        return this.credentials;
    }
}

