/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http.clients;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.CallBack;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.IHttpClient;
import com.aliyuncs.http.X509TrustAll;
import com.aliyuncs.http.clients.ApacheIdleConnectionCleaner;
import com.aliyuncs.utils.IOUtils;
import com.aliyuncs.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient
extends IHttpClient {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String EXT_PARAM_KEY_BUILDER = "apache.httpclient.builder";
    private static final int DEFAULT_THREAD_KEEP_ALIVE_TIME = 60;
    private ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;

    public ApacheHttpClient(HttpClientConfig config) throws ClientException {
        super(config);
    }

    @Override
    protected void init(final HttpClientConfig config) throws ClientException {
        HttpClientBuilder builder = config.containsExtParam(EXT_PARAM_KEY_BUILDER) ? (HttpClientBuilder)config.getExtParam(EXT_PARAM_KEY_BUILDER) : HttpClientBuilder.create();
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout((int)config.getConnectionTimeoutMillis()).setSocketTimeout((int)config.getReadTimeoutMillis()).setConnectionRequestTimeout((int)config.getWriteTimeoutMillis()).build();
        builder.setDefaultRequestConfig(defaultConfig);
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        if (config.isIgnoreSSLCerts() || X509TrustAll.isIgnoreSSLCerts()) {
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
                SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                socketFactoryRegistryBuilder.register("https", (Object)connectionFactory);
            }
            catch (Exception e) {
                throw new ClientException("SDK.InitFailed", "Init https with SSL certs ignore failed", e);
            }
        }
        if (config.getSslSocketFactory() != null) {
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(config.getSslSocketFactory(), config.getHostnameVerifier());
            socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        } else if (config.getKeyManagers() != null || config.getX509TrustManagers() != null || config.getSecureRandom() != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(config.getKeyManagers(), config.getX509TrustManagers(), config.getSecureRandom());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
                socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
            }
            catch (NoSuchAlgorithmException e1) {
                throw new SSLInitializationException(e1.getMessage(), (Throwable)e1);
            }
            catch (KeyManagementException e2) {
                throw new SSLInitializationException(e2.getMessage(), (Throwable)e2);
            }
        }
        this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        this.connectionManager.setMaxTotal(config.getMaxRequests());
        this.connectionManager.setDefaultMaxPerRoute(config.getMaxRequestsPerHost());
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        ApacheIdleConnectionCleaner.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, config.getMaxIdleTimeMillis());
        this.executorService = config.getExecutorService() == null ? new ThreadPoolExecutor(0, config.getMaxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultAsyncThreadFactory()) : config.getExecutorService();
        if (config.getKeepAliveDurationMillis() > 0L) {
            builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(org.apache.http.HttpResponse response, HttpContext context) {
                    long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                    if (duration > 0L && duration < config.getKeepAliveDurationMillis()) {
                        return duration;
                    }
                    return config.getKeepAliveDurationMillis();
                }
            });
        }
        this.httpClient = builder.build();
    }

    private HttpUriRequest parseToHttpRequest(HttpRequest apiReq) throws IOException {
        RequestBuilder builder = RequestBuilder.create((String)apiReq.getMethod().name());
        builder.setUri(apiReq.getUrl());
        if (apiReq.getMethod().hasContent()) {
            EntityBuilder bodyBuilder = EntityBuilder.create();
            String contentType = apiReq.getHeaderValue(CONTENT_TYPE);
            if (StringUtils.isEmpty(contentType)) {
                contentType = apiReq.getContentTypeValue(apiReq.getHttpContentType(), apiReq.getEncoding());
            }
            if (StringUtils.isNotEmpty(contentType)) {
                bodyBuilder.setContentType(ContentType.parse((String)contentType));
            }
            bodyBuilder.setBinary(apiReq.getHttpContent());
            builder.setEntity(bodyBuilder.build());
        }
        builder.addHeader(ACCEPT_ENCODING, "identity");
        for (Map.Entry<String, String> entry : apiReq.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private HttpResponse parseToHttpResponse(org.apache.http.HttpResponse httpResponse) throws IOException {
        FormatType formatType;
        ContentType contentType;
        Header contentTypeHeader;
        HttpResponse result = new HttpResponse();
        result.setStatus(httpResponse.getStatusLine().getStatusCode());
        if (httpResponse.getEntity() != null) {
            contentTypeHeader = httpResponse.getEntity().getContentType();
            contentType = ContentType.parse((String)contentTypeHeader.getValue());
            formatType = FormatType.mapAcceptToFormat(contentType.getMimeType());
            result.setHttpContentType(formatType);
            String charset = "utf-8";
            if (contentType.getCharset() != null) {
                charset = contentType.getCharset().toString();
            }
            result.setHttpContent(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()), charset, formatType);
        } else {
            contentTypeHeader = httpResponse.getFirstHeader(CONTENT_TYPE);
            if (contentTypeHeader != null) {
                contentType = ContentType.parse((String)contentTypeHeader.getValue());
                formatType = FormatType.mapAcceptToFormat(contentType.getMimeType());
                result.setHttpContentType(formatType);
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            result.putHeaderParameter(header.getName(), header.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HttpResponse syncInvoke(HttpRequest apiRequest) throws IOException {
        HttpResponse httpResponse;
        HttpUriRequest httpRequest = this.parseToHttpRequest(apiRequest);
        CloseableHttpResponse httpResponse2 = null;
        try {
            httpResponse2 = this.httpClient.execute(httpRequest);
            httpResponse = this.parseToHttpResponse((org.apache.http.HttpResponse)httpResponse2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(httpResponse2);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)httpResponse2);
        return httpResponse;
    }

    @Override
    public final Future<HttpResponse> asyncInvoke(final HttpRequest apiRequest, final CallBack callback) {
        return this.executorService.submit(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws Exception {
                HttpResponse result;
                try {
                    result = ApacheHttpClient.this.syncInvoke(apiRequest);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onFailure(apiRequest, e);
                    }
                    throw e;
                }
                if (callback != null) {
                    callback.onResponse(apiRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void ignoreSSLCertificate() {
        throw new IllegalStateException("Apache httpclient does not support modify sslFactory after inited, use HttpClientConfig.setIgnoreSSLCerts(true) while building client");
    }

    @Override
    public void restoreSSLCertificate() {
        throw new IllegalStateException("Apache httpclient does not support modify sslFactory after inited, use HttpClientConfig.setIgnoreSSLCerts(true) while building client");
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
        ApacheIdleConnectionCleaner.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
        this.connectionManager.shutdown();
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    private class DefaultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private DefaultAsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Aliyun_SDK_Async_ThreadPool_" + this.counter.incrementAndGet());
        }
    }
}

