/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netpassapi;

import cn.com.infosec.netpassapi.AuthAPIException;
import cn.com.infosec.utils.LicenceInfo;
import cn.com.infosec.utils.OTPUtils;

public class NetPassApi {
    public LicenceInfo getLicenceInfo() throws AuthAPIException {
        OTPUtils otputil = new OTPUtils();
        LicenceInfo lic = otputil.getLicenceInfo();
        if (lic == null) {
            int errCode = otputil.getErrCode();
            throw new AuthAPIException(errCode, NetPassApi.getErrmsg(errCode));
        }
        return lic;
    }

    public boolean importLicence(String licenceData) throws AuthAPIException {
        OTPUtils otputil = new OTPUtils();
        boolean result = otputil.importLicence(licenceData);
        if (result) {
            return true;
        }
        int errCode = otputil.getErrCode();
        throw new AuthAPIException(errCode, NetPassApi.getErrmsg(errCode));
    }

    public boolean verifyMobile(String userId, String sn, String code, int timeStep, String password) throws AuthAPIException {
        OTPUtils otputil = new OTPUtils();
        boolean result = otputil.verifySMToken(userId, sn, code, timeStep, password);
        if (result) {
            return true;
        }
        int errCode = otputil.getErrCode();
        if (errCode == 167772196) {
            return false;
        }
        throw new AuthAPIException(errCode, NetPassApi.getErrmsg(errCode));
    }

    public boolean verifyToken(byte[] seed, int timeStep, int otpBit, String password) throws AuthAPIException {
        OTPUtils otputil = new OTPUtils();
        String result = otputil.generateSMToken(seed, timeStep, otpBit);
        if (result == null) {
            int errCode = otputil.getErrCode();
            throw new AuthAPIException(errCode, NetPassApi.getErrmsg(errCode));
        }
        return result.equals(password);
    }

    private static String getErrmsg(int errCode) {
        String msg = "";
        switch (errCode) {
            case 0x1000001: {
                msg = "LicenceAPP\u65e0\u6548";
                break;
            }
            case 0x1000002: {
                msg = "\u751f\u6210 licenceApp \u6587\u4ef6";
                break;
            }
            case 0x1000003: {
                msg = "Licence\u4e0d\u5b58\u5728";
                break;
            }
            case 0x1000004: {
                msg = "Licence\u4e0d\u5728\u6709\u6548\u671f\u5185";
                break;
            }
            case 0x1000005: {
                msg = "\u6b64Licence\u4e3a\u6d4b\u8bd5Licence";
                break;
            }
            case 0x1000006: {
                msg = "\u65e0\u6548Licence";
                break;
            }
            case 0x1000007: {
                msg = "cpuid\u6216MAC\u6821\u9a8c\u5931\u8d25";
                break;
            }
            case 0x1000008: {
                msg = "\u65e0\u6cd5\u89e3\u6790Licence\u4fe1\u606f";
                break;
            }
            case 0x1000009: {
                msg = "Licence\u6587\u4ef6\u7b7e\u540d\u503c\u9519\u8bef";
                break;
            }
            case 0x100000A: {
                msg = "\u4ea7\u54c1\u540d\u79f0\u6821\u9a8c\u5931\u8d25";
                break;
            }
            case 167772199: {
                msg = "\u5bc6\u7801\u4f4d\u6570\u4e0d\u6b63\u786e";
                break;
            }
            default: {
                msg = "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9519\u8bef\u4fe1\u606f";
            }
        }
        return msg;
    }
}

