/*
 * Decompiled with CFR 0.152.
 */
package com.oppo.push.server;

import com.oppo.push.server.TargetType;
import com.oppo.push.server.Validate;

public class Target {
    private TargetType targetType = TargetType.REGISTRATION_ID;
    private String targetValue;

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public static Target build(String targetValue) {
        Target target = new Target();
        target.setTargetValue(targetValue);
        return target;
    }

    void validate() {
        if (Validate.isEmpty(this.targetValue)) {
            throw new IllegalArgumentException("target value is null");
        }
        if (this.targetType == TargetType.REGISTRATION_ID) {
            String[] registrationIds;
            for (String registrationId : registrationIds = this.targetValue.split(";")) {
                if (!Validate.validateRegistrationId(registrationId) && registrationIds.length == 1) {
                    throw new IllegalArgumentException("registration_id format error");
                }
                if (Validate.validateRegistrationId(registrationId) || registrationIds.length <= 1) continue;
                throw new IllegalArgumentException("registration_id format error, two values registration_id separated by commas");
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

