/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLType;
import com.alibaba.druid.sql.parser.SymbolTable;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;

public class Lexer {
    protected static SymbolTable symbols_l2 = new SymbolTable(512);
    protected int features;
    protected TimeZone timeZone;
    public final String text;
    protected int pos;
    protected int mark;
    protected int numberSale;
    protected boolean numberExp;
    protected char ch;
    protected char[] buf;
    protected int bufPos;
    protected Token token;
    protected Keywords keywords = Keywords.DEFAULT_KEYWORDS;
    protected String stringVal;
    protected long hashLCase;
    protected long hash;
    protected int commentCount;
    protected List<String> comments;
    protected boolean skipComment = true;
    private SavePoint savePoint;
    private boolean allowComment = true;
    private int varIndex = -1;
    protected CommentHandler commentHandler;
    protected boolean endOfComment;
    protected boolean keepComments;
    protected int line;
    protected int lines;
    protected DbType dbType;
    protected boolean optimizedForParameterized;
    protected boolean keepSourceLocation;
    protected int startPos;
    protected int posLine;
    protected int posColumn;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int[] digits = new int[58];

    public Lexer(String input) {
        this(input, null);
    }

    public Lexer(String input, CommentHandler commentHandler) {
        this(input, true);
        this.commentHandler = commentHandler;
    }

    public Lexer(String input, CommentHandler commentHandler, DbType dbType) {
        this(input, true);
        this.commentHandler = commentHandler;
        this.dbType = dbType;
        if (DbType.sqlite == dbType) {
            this.keywords = Keywords.SQLITE_KEYWORDS;
        } else if (DbType.dm == dbType) {
            this.keywords = Keywords.DM_KEYWORDS;
        }
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public void setCommentHandler(CommentHandler commentHandler) {
        this.commentHandler = commentHandler;
    }

    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    public final String addSymbol() {
        return this.subString(this.mark, this.bufPos);
    }

    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    public final char[] sub_chars(int offset, int count) {
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return chars;
    }

    protected void initBuff(int size) {
        if (this.buf == null) {
            this.buf = size < 32 ? new char[32] : new char[size + 32];
        } else if (this.buf.length < size) {
            this.buf = Arrays.copyOf(this.buf, size);
        }
    }

    public void arraycopy(int srcPos, char[] dest, int destPos, int length) {
        this.text.getChars(srcPos, srcPos + length, dest, destPos);
    }

    public boolean isAllowComment() {
        return this.allowComment;
    }

    public void setAllowComment(boolean allowComment) {
        this.allowComment = allowComment;
    }

    public int nextVarIndex() {
        return ++this.varIndex;
    }

    public Keywords getKeywords() {
        return this.keywords;
    }

    @Deprecated
    public SavePoint mark() {
        this.savePoint = this.markOut();
        return this.savePoint;
    }

    public SavePoint markOut() {
        SavePoint savePoint = new SavePoint();
        savePoint.bp = this.pos;
        savePoint.sp = this.bufPos;
        savePoint.np = this.mark;
        savePoint.ch = this.ch;
        savePoint.token = this.token;
        savePoint.stringVal = this.stringVal;
        savePoint.hash = this.hash;
        savePoint.hashLCase = this.hashLCase;
        savePoint.startPos = this.startPos;
        return savePoint;
    }

    public void reset(SavePoint savePoint) {
        this.pos = savePoint.bp;
        this.bufPos = savePoint.sp;
        this.mark = savePoint.np;
        this.ch = savePoint.ch;
        this.token = savePoint.token;
        this.stringVal = savePoint.stringVal;
        this.hash = savePoint.hash;
        this.hashLCase = savePoint.hashLCase;
        this.startPos = savePoint.startPos;
    }

    @Deprecated
    public void reset() {
        this.reset(this.savePoint);
    }

    public void reset(int pos) {
        this.pos = pos;
        this.ch = this.charAt(pos);
    }

    public Lexer(String input, boolean skipComment) {
        this.skipComment = skipComment;
        this.text = input;
        this.pos = 0;
        this.ch = this.charAt(this.pos);
        while (this.ch == '\u200b' || this.ch == '\n') {
            if (this.ch == '\n') {
                ++this.line;
            }
            this.ch = this.charAt(++this.pos);
        }
    }

    public Lexer(char[] input, int inputLength, boolean skipComment) {
        this(new String(input, 0, inputLength), skipComment);
    }

    protected final void scanChar() {
        this.ch = this.charAt(++this.pos);
    }

    protected void unscan() {
        this.ch = this.charAt(--this.pos);
    }

    public boolean isEOF() {
        return this.pos >= this.text.length();
    }

    protected void lexError(String key, Object ... args) {
        this.token = Token.ERROR;
    }

    public final Token token() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public final DbType getDbType() {
        return this.dbType;
    }

    public String info() {
        int line = 1;
        int column = 1;
        int i = 0;
        while (i < this.startPos) {
            char ch = this.text.charAt(i);
            if (ch == '\n') {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        this.posLine = line;
        this.posColumn = column;
        StringBuilder buf = new StringBuilder();
        buf.append("pos ").append(this.pos).append(", line ").append(line).append(", column ").append(column);
        if (this.token != null) {
            if (this.token.name != null) {
                buf.append(", token ").append(this.token.name);
            } else {
                buf.append(", token ").append(this.token.name());
            }
        }
        if (this.token == Token.IDENTIFIER || this.token == Token.LITERAL_ALIAS || this.token == Token.LITERAL_CHARS) {
            buf.append(" ").append(this.stringVal());
        }
        if (this.isEnabled(SQLParserFeature.PrintSQLWhileParsingFailed)) {
            buf.append(", SQL : ");
            buf.append(this.text);
        }
        return buf.toString();
    }

    public final void nextTokenComma() {
        char ch_next_2;
        char ch_next;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == ',' || this.ch == '\uff0c') {
            this.scanChar();
            this.token = Token.COMMA;
            return;
        }
        if (this.ch == ')' || this.ch == '\uff09') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        if (this.ch == '.') {
            this.scanChar();
            this.token = Token.DOT;
            return;
        }
        if (!(this.ch != 'a' && this.ch != 'A' || (ch_next = this.charAt(this.pos + 1)) != 's' && ch_next != 'S' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.AS;
            this.stringVal = "AS";
            return;
        }
        this.nextToken();
    }

    public final void nextTokenCommaValue() {
        char ch_next_2;
        char ch_next;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == ',' || this.ch == '\uff0c') {
            this.scanChar();
            this.token = Token.COMMA;
            return;
        }
        if (this.ch == ')' || this.ch == '\uff09') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        if (this.ch == '.') {
            this.scanChar();
            this.token = Token.DOT;
            return;
        }
        if (!(this.ch != 'a' && this.ch != 'A' || (ch_next = this.charAt(this.pos + 1)) != 's' && ch_next != 'S' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.AS;
            this.stringVal = "AS";
            return;
        }
        this.nextTokenValue();
    }

    public final void nextTokenEq() {
        char ch_next_2;
        char ch_next;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '=') {
            this.scanChar();
            if (this.ch == '=') {
                this.scanChar();
                this.token = Token.EQEQ;
            } else if (this.ch == '>') {
                this.scanChar();
                this.token = Token.EQGT;
            }
            this.token = Token.EQ;
            return;
        }
        if (this.ch == '.') {
            this.scanChar();
            this.token = Token.DOT;
            return;
        }
        if (!(this.ch != 'a' && this.ch != 'A' || (ch_next = this.charAt(this.pos + 1)) != 's' && ch_next != 'S' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.AS;
            this.stringVal = "AS";
            return;
        }
        this.nextToken();
    }

    public final void nextTokenLParen() {
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '(' || this.ch == '\uff08') {
            this.scanChar();
            this.token = Token.LPAREN;
            return;
        }
        this.nextToken();
    }

    public final void nextTokenValue() {
        char next;
        this.startPos = this.pos;
        while (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '\'') {
            this.bufPos = 0;
            if (this.dbType == DbType.mysql) {
                this.scanString2();
            } else {
                this.scanString();
            }
            return;
        }
        if (this.ch == '\"' && !this.isEnabled(SQLParserFeature.KeepNameQuotes)) {
            this.bufPos = 0;
            this.scanString2_d();
            return;
        }
        if (this.ch == '0') {
            this.bufPos = 0;
            if (this.charAt(this.pos + 1) == 'x') {
                this.scanChar();
                this.scanChar();
                this.scanHexaDecimal();
            } else {
                this.scanNumber();
            }
            return;
        }
        if (this.ch > '0' && this.ch <= '9') {
            this.bufPos = 0;
            this.scanNumber();
            return;
        }
        if (this.ch == '-' && (next = this.charAt(this.pos + 1)) >= '0' && next <= '9') {
            this.bufPos = 0;
            this.scanNumber();
            return;
        }
        if (this.ch == '?') {
            this.scanChar();
            this.token = Token.QUES;
            return;
        }
        if (this.ch == 'n' || this.ch == 'N') {
            int c1 = 0;
            if (this.pos + 4 < this.text.length()) {
                char c4;
                char c3;
                char c2;
                char c = this.text.charAt(this.pos + 1);
                c1 = c;
                if (!(c != 'u' && c1 != 85 || (c2 = this.text.charAt(this.pos + 2)) != 'l' && c2 != 'L' || (c3 = this.text.charAt(this.pos + 3)) != 'l' && c3 != 'L' || !CharTypes.isWhitespace(c4 = this.text.charAt(this.pos + 4)) && c4 != ',' && c4 != ')' && c4 != '\uff09')) {
                    this.pos += 4;
                    this.ch = c4;
                    this.token = Token.NULL;
                    this.stringVal = "NULL";
                    return;
                }
            }
            if (c1 == 39) {
                this.bufPos = 0;
                ++this.pos;
                this.ch = (char)39;
                this.scanString();
                this.token = Token.LITERAL_NCHARS;
                return;
            }
        }
        if (this.ch == ')' || this.ch == '\uff09') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        if (this.ch == '\uff08') {
            this.scanChar();
            this.token = Token.LPAREN;
            return;
        }
        if (this.ch == '$' && Lexer.isVaraintChar(this.charAt(this.pos + 1))) {
            this.scanVariable();
            return;
        }
        if (CharTypes.isFirstIdentifierChar(this.ch)) {
            this.scanIdentifier();
            return;
        }
        this.nextToken();
    }

    static boolean isVaraintChar(char ch) {
        return ch == '{' || ch >= '0' && ch <= '9';
    }

    public final void nextTokenBy() {
        char ch_next_2;
        char ch_next;
        while (this.ch == ' ') {
            this.scanChar();
        }
        if (!(this.ch != 'b' && this.ch != 'B' || (ch_next = this.charAt(this.pos + 1)) != 'y' && ch_next != 'Y' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.BY;
            this.stringVal = "BY";
            return;
        }
        this.nextToken();
    }

    public final void nextTokenNotOrNull() {
        while (this.ch == ' ') {
            this.scanChar();
        }
        if ((this.ch == 'n' || this.ch == 'N') && this.pos + 3 < this.text.length()) {
            char c4;
            char c1 = this.text.charAt(this.pos + 1);
            char c2 = this.text.charAt(this.pos + 2);
            char c3 = this.text.charAt(this.pos + 3);
            if (!(c1 != 'o' && c1 != 'O' || c2 != 't' && c2 != 'T' || !CharTypes.isWhitespace(c3))) {
                this.pos += 3;
                this.ch = c3;
                this.token = Token.NOT;
                this.stringVal = "NOT";
                return;
            }
            if (!(this.pos + 4 >= this.text.length() || c1 != 'u' && c1 != 'U' || c2 != 'l' && c2 != 'L' || c3 != 'l' && c3 != 'L' || !CharTypes.isWhitespace(c4 = this.text.charAt(this.pos + 4)))) {
                this.pos += 4;
                this.ch = c4;
                this.token = Token.NULL;
                this.stringVal = "NULL";
                return;
            }
        }
        this.nextToken();
    }

    public final void nextTokenIdent() {
        while (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '$' && Lexer.isVaraintChar(this.charAt(this.pos + 1))) {
            this.scanVariable();
            return;
        }
        if (CharTypes.isFirstIdentifierChar(this.ch) && this.ch != '\uff08') {
            this.scanIdentifier();
            return;
        }
        if (this.ch == ')') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        this.nextToken();
    }

    public final SQLType scanSQLType() {
        block0: while (true) {
            int index;
            if (CharTypes.isWhitespace(this.ch)) {
                this.ch = this.charAt(++this.pos);
                continue;
            }
            if (this.ch == '/') {
                if (this.pos + 1 < this.text.length() && this.text.charAt(this.pos + 1) == '*') {
                    index = this.text.indexOf("*/", this.pos + 2);
                    if (index == -1) {
                        return SQLType.UNKNOWN;
                    }
                    this.pos = index + 2;
                    this.ch = this.charAt(this.pos);
                    continue;
                }
                if (this.pos + 2 < this.text.length() && this.text.charAt(this.pos + 1) == ' ' && this.text.charAt(this.pos + 2) == '*' && this.dbType == DbType.odps) {
                    index = this.text.indexOf("* /", this.pos + 3);
                    if (index == -1) {
                        return SQLType.UNKNOWN;
                    }
                    this.pos = index + 3;
                    this.ch = this.charAt(this.pos);
                    continue;
                }
            }
            if (this.dbType == DbType.odps && this.ch == ';') {
                this.ch = this.charAt(++this.pos);
                if (this.isEOF()) {
                    return SQLType.EMPTY;
                }
                while (true) {
                    if (!CharTypes.isWhitespace(this.ch)) continue block0;
                    this.ch = this.charAt(++this.pos);
                }
            }
            if (this.pos + 1 >= this.text.length() || (this.ch != '-' || this.text.charAt(this.pos + 1) != '-') && (this.ch != '\u2014' || this.text.charAt(this.pos + 1) != '\u2014')) break;
            index = this.text.indexOf(10, this.pos + 2);
            if (index == -1) {
                this.reset(0);
                this.nextToken();
                if (this.token == Token.EOF) {
                    return SQLType.EMPTY;
                }
                return SQLType.UNKNOWN;
            }
            this.pos = index + 1;
            this.ch = this.charAt(this.pos);
        }
        while (this.ch == '(') {
            this.ch = this.charAt(++this.pos);
            while (CharTypes.isWhitespace(this.ch)) {
                this.ch = this.charAt(++this.pos);
            }
        }
        long hashCode = -3750763034362895579L;
        while (true) {
            char c;
            if (this.ch >= 'a' && this.ch <= 'z') {
                c = this.ch;
            } else {
                if (this.ch < 'A' || this.ch > 'Z') break;
                c = (char)(this.ch + 32);
            }
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
            this.ch = this.charAt(++this.pos);
        }
        if (this.ch == '_' || this.ch >= '0' && this.ch <= '9') {
            return SQLType.UNKNOWN;
        }
        if (hashCode == FnvHash.Constants.SELECT) {
            return SQLType.SELECT;
        }
        if (hashCode == FnvHash.Constants.INSERT) {
            return SQLType.INSERT;
        }
        if (hashCode == FnvHash.Constants.DELETE) {
            return SQLType.DELETE;
        }
        if (hashCode == FnvHash.Constants.UPDATE) {
            return SQLType.UPDATE;
        }
        if (hashCode == FnvHash.Constants.REPLACE) {
            return SQLType.REPLACE;
        }
        if (hashCode == FnvHash.Constants.TRUNCATE) {
            return SQLType.TRUNCATE;
        }
        if (hashCode == FnvHash.Constants.MERGE) {
            return SQLType.MERGE;
        }
        if (hashCode == FnvHash.Constants.CREATE) {
            return SQLType.CREATE;
        }
        if (hashCode == FnvHash.Constants.ALTER) {
            return SQLType.ALTER;
        }
        if (hashCode == FnvHash.Constants.SHOW) {
            this.nextToken();
            if (this.identifierEquals(FnvHash.Constants.STATISTIC)) {
                return SQLType.SHOW_STATISTIC;
            }
            if (this.identifierEquals(FnvHash.Constants.STATISTIC_LIST)) {
                return SQLType.SHOW_STATISTIC_LIST;
            }
            if (this.identifierEquals(FnvHash.Constants.TABLES) || this.identifierEquals("TABLES\uff1b")) {
                return SQLType.SHOW_TABLES;
            }
            if (this.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                return SQLType.SHOW_PARTITIONS;
            }
            if (this.identifierEquals(FnvHash.Constants.CATALOGS)) {
                return SQLType.SHOW_CATALOGS;
            }
            if (this.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                return SQLType.SHOW_FUNCTIONS;
            }
            if (this.identifierEquals(FnvHash.Constants.ROLES)) {
                return SQLType.SHOW_ROLES;
            }
            if (this.identifierEquals(FnvHash.Constants.ROLE)) {
                return SQLType.SHOW_ROLE;
            }
            if (this.identifierEquals(FnvHash.Constants.LABEL)) {
                return SQLType.SHOW_LABEL;
            }
            if (this.identifierEquals(FnvHash.Constants.GRANTS)) {
                return SQLType.SHOW_GRANTS;
            }
            if (this.identifierEquals(FnvHash.Constants.GRANT) || this.token == Token.GRANT) {
                return SQLType.SHOW_GRANT;
            }
            if (this.identifierEquals(FnvHash.Constants.RECYCLEBIN)) {
                return SQLType.SHOW_RECYCLEBIN;
            }
            if (this.identifierEquals("VARIABLES")) {
                return SQLType.SHOW_VARIABLES;
            }
            if (this.identifierEquals("HISTORY")) {
                return SQLType.SHOW_HISTORY;
            }
            if (this.identifierEquals("PACKAGES")) {
                return SQLType.SHOW_PACKAGES;
            }
            if (this.identifierEquals("PACKAGE")) {
                return SQLType.SHOW_PACKAGE;
            }
            if (this.identifierEquals("CHANGELOGS")) {
                return SQLType.SHOW_CHANGELOGS;
            }
            if (this.identifierEquals("ACL")) {
                return SQLType.SHOW_ACL;
            }
            if (this.token == Token.CREATE) {
                this.nextToken();
                if (this.token == Token.TABLE) {
                    return SQLType.SHOW_CREATE_TABLE;
                }
            }
            return SQLType.SHOW;
        }
        if (hashCode == FnvHash.Constants.DESC) {
            return SQLType.DESC;
        }
        if (hashCode == FnvHash.Constants.DESCRIBE) {
            return SQLType.DESC;
        }
        if (hashCode == FnvHash.Constants.SET) {
            this.nextToken();
            if (this.identifierEquals(FnvHash.Constants.LABEL)) {
                return SQLType.SET_LABEL;
            }
            if (this.identifierEquals("PROJECT")) {
                return SQLType.SET_PROJECT;
            }
            return SQLType.SET;
        }
        if (hashCode == FnvHash.Constants.KILL) {
            return SQLType.KILL;
        }
        if (hashCode == FnvHash.Constants.MSCK) {
            return SQLType.MSCK;
        }
        if (hashCode == FnvHash.Constants.USE) {
            return SQLType.USE;
        }
        if (hashCode == FnvHash.Constants.DROP) {
            return SQLType.DROP;
        }
        if (hashCode == FnvHash.Constants.LIST) {
            this.nextToken();
            if (this.identifierEquals(FnvHash.Constants.USERS)) {
                return SQLType.LIST_USERS;
            }
            if (this.identifierEquals(FnvHash.Constants.TABLES)) {
                return SQLType.LIST_TABLES;
            }
            if (this.identifierEquals(FnvHash.Constants.ROLES)) {
                return SQLType.LIST_ROLES;
            }
            if (this.identifierEquals(FnvHash.Constants.TEMPORARY)) {
                return SQLType.LIST_TEMPORARY_OUTPUT;
            }
            if (this.identifierEquals("TENANT")) {
                this.nextToken();
                if (this.identifierEquals(FnvHash.Constants.ROLES)) {
                    return SQLType.LIST_TENANT_ROLES;
                }
            } else {
                if (this.identifierEquals("TRUSTEDPROJECTS")) {
                    return SQLType.LIST_TRUSTEDPROJECTS;
                }
                if (this.identifierEquals("ACCOUNTPROVIDERS")) {
                    return SQLType.LIST_ACCOUNTPROVIDERS;
                }
            }
            return SQLType.LIST;
        }
        if (hashCode == FnvHash.Constants.ROLLBACK) {
            return SQLType.ROLLBACK;
        }
        if (hashCode == FnvHash.Constants.COMMIT) {
            return SQLType.COMMIT;
        }
        if (hashCode == FnvHash.Constants.WHO) {
            return SQLType.WHO;
        }
        if (hashCode == FnvHash.Constants.GRANT) {
            return SQLType.GRANT;
        }
        if (hashCode == FnvHash.Constants.REVOKE) {
            return SQLType.REVOKE;
        }
        if (hashCode == FnvHash.Constants.ANALYZE) {
            return SQLType.ANALYZE;
        }
        if (hashCode == FnvHash.Constants.EXPLAIN) {
            return SQLType.EXPLAIN;
        }
        if (hashCode == FnvHash.Constants.READ) {
            return SQLType.READ;
        }
        if (hashCode == FnvHash.Constants.WITH) {
            return SQLType.WITH;
        }
        if (hashCode == FnvHash.Constants.DUMP) {
            this.nextToken();
            if (this.identifierEquals(FnvHash.Constants.DATA)) {
                return SQLType.DUMP_DATA;
            }
        } else {
            if (hashCode == FnvHash.Constants.ADD) {
                this.nextToken();
                if (this.token == Token.USER || this.identifierEquals(FnvHash.Constants.USER)) {
                    return SQLType.ADD_USER;
                }
                if (this.token == Token.TABLE) {
                    return SQLType.ADD_TABLE;
                }
                if (this.token == Token.FUNCTION) {
                    return SQLType.ADD_FUNCTION;
                }
                if (this.identifierEquals(FnvHash.Constants.STATISTIC)) {
                    return SQLType.ADD_STATISTIC;
                }
                if (this.identifierEquals(FnvHash.Constants.RESOURCE)) {
                    return SQLType.ADD_RESOURCE;
                }
                if (this.identifierEquals("VOLUME")) {
                    return SQLType.ADD_VOLUME;
                }
                if (this.identifierEquals("ACCOUNTPROVIDER")) {
                    return SQLType.ADD_ACCOUNTPROVIDER;
                }
                if (this.identifierEquals("TRUSTEDPROJECT")) {
                    return SQLType.ADD_TRUSTEDPROJECT;
                }
                return SQLType.ADD;
            }
            if (hashCode == FnvHash.Constants.REMOVE) {
                this.nextToken();
                if (this.token == Token.USER || this.identifierEquals(FnvHash.Constants.USER)) {
                    return SQLType.REMOVE_USER;
                }
                if (this.identifierEquals(FnvHash.Constants.RESOURCE)) {
                    return SQLType.REMOVE_RESOURCE;
                }
                return SQLType.REMOVE;
            }
            if (hashCode == FnvHash.Constants.TUNNEL) {
                this.nextToken();
                if (this.identifierEquals(FnvHash.Constants.DOWNLOAD)) {
                    return SQLType.TUNNEL_DOWNLOAD;
                }
            } else {
                if (hashCode == FnvHash.Constants.UPLOAD) {
                    return SQLType.UPLOAD;
                }
                if (hashCode == FnvHash.Constants.WHOAMI) {
                    return SQLType.WHOAMI;
                }
                if (hashCode == FnvHash.Constants.COUNT) {
                    return SQLType.COUNT;
                }
                if (hashCode == FnvHash.Constants.CLONE) {
                    return SQLType.CLONE;
                }
                if (hashCode == FnvHash.Constants.LOAD) {
                    return SQLType.LOAD;
                }
                if (hashCode == FnvHash.Constants.INSTALL) {
                    return SQLType.INSTALL;
                }
                if (hashCode == FnvHash.Constants.UNLOAD) {
                    return SQLType.UNLOAD;
                }
                if (hashCode == FnvHash.Constants.ALLOW) {
                    return SQLType.ALLOW;
                }
                if (hashCode == FnvHash.Constants.PURGE) {
                    return SQLType.PURGE;
                }
                if (hashCode == FnvHash.Constants.RESTORE) {
                    return SQLType.RESTORE;
                }
                if (hashCode == FnvHash.Constants.EXSTORE) {
                    return SQLType.EXSTORE;
                }
                if (hashCode == FnvHash.Constants.UNDO) {
                    return SQLType.UNDO;
                }
                if (hashCode == FnvHash.Constants.REMOVE) {
                    return SQLType.REMOVE;
                }
                if (hashCode == FnvHash.Constants.FROM) {
                    if (this.dbType == DbType.odps || this.dbType == DbType.hive) {
                        return SQLType.INSERT_MULTI;
                    }
                } else {
                    if (hashCode == FnvHash.Constants.ADD) {
                        return SQLType.ADD;
                    }
                    if (hashCode == FnvHash.Constants.IF) {
                        return SQLType.SCRIPT;
                    }
                    if (hashCode == FnvHash.Constants.FUNCTION) {
                        if (this.dbType == DbType.odps) {
                            return SQLType.SCRIPT;
                        }
                    } else if (hashCode == FnvHash.Constants.BEGIN) {
                        if (this.dbType == DbType.odps || this.dbType == DbType.oracle) {
                            return SQLType.SCRIPT;
                        }
                    } else if (this.ch == '@') {
                        this.nextToken();
                        if (this.token == Token.VARIANT && this.dbType == DbType.odps) {
                            this.nextToken();
                            if (this.token == Token.TABLE) {
                                return SQLType.SCRIPT;
                            }
                            if (this.token == Token.IDENTIFIER) {
                                this.nextToken();
                            }
                            if (this.token == Token.COLONEQ || this.token == Token.SEMI) {
                                return SQLType.SCRIPT;
                            }
                        }
                    }
                }
            }
        }
        if (this.ch == '\u001a') {
            return SQLType.EMPTY;
        }
        return SQLType.UNKNOWN;
    }

    public final SQLType scanSQLTypeV2() {
        SQLType sqlType;
        block32: {
            sqlType = this.scanSQLType();
            if (sqlType == SQLType.CREATE) {
                this.nextToken();
                if (this.token == Token.USER || this.identifierEquals(FnvHash.Constants.USER)) {
                    return SQLType.CREATE_USER;
                }
                for (int i = 0; i < 1000; ++i) {
                    switch (this.token) {
                        case EOF: 
                        case ERROR: {
                            break block32;
                        }
                        case TABLE: {
                            sqlType = SQLType.CREATE_TABLE;
                            break;
                        }
                        case VIEW: {
                            if (sqlType != SQLType.CREATE) break;
                            sqlType = SQLType.CREATE_VIEW;
                            break block32;
                        }
                        case FUNCTION: {
                            if (sqlType != SQLType.CREATE) break;
                            sqlType = SQLType.CREATE_FUNCTION;
                            break block32;
                        }
                        case SELECT: {
                            if (sqlType != SQLType.CREATE_TABLE) break;
                            sqlType = SQLType.CREATE_TABLE_AS_SELECT;
                            break block32;
                        }
                        default: {
                            if (sqlType == SQLType.CREATE && this.identifierEquals(FnvHash.Constants.ROLE)) {
                                sqlType = SQLType.CREATE_ROLE;
                            } else {
                                if (sqlType != SQLType.CREATE || !this.identifierEquals(FnvHash.Constants.PACKAGE)) break;
                                sqlType = SQLType.CREATE_PACKAGE;
                            }
                            break block32;
                        }
                    }
                    this.nextToken();
                }
            } else if (sqlType == SQLType.DROP) {
                this.nextToken();
                if (this.token == Token.USER || this.identifierEquals(FnvHash.Constants.USER)) {
                    return SQLType.DROP_USER;
                }
                if (this.token == Token.TABLE) {
                    return SQLType.DROP_TABLE;
                }
                if (this.token == Token.VIEW) {
                    return SQLType.DROP_VIEW;
                }
                if (this.token == Token.FUNCTION) {
                    return SQLType.DROP_FUNCTION;
                }
                if (this.identifierEquals(FnvHash.Constants.ROLE)) {
                    return SQLType.DROP_ROLE;
                }
                if (this.identifierEquals(FnvHash.Constants.RESOURCE)) {
                    return SQLType.DROP_RESOURCE;
                }
                if (this.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
                    this.nextToken();
                    if (this.token == Token.VIEW) {
                        return SQLType.DROP_MATERIALIZED_VIEW;
                    }
                }
            } else if (sqlType == SQLType.ALTER) {
                this.nextToken();
                if (this.token == Token.USER || this.identifierEquals(FnvHash.Constants.USER)) {
                    return SQLType.ALTER_USER;
                }
                if (this.token == Token.TABLE) {
                    return SQLType.ALTER_TABLE;
                }
                if (this.token == Token.VIEW) {
                    return SQLType.ALTER_VIEW;
                }
            } else if (sqlType == SQLType.INSERT) {
                this.nextToken();
                boolean overwrite = this.token == Token.OVERWRITE;
                for (int i = 0; i < 1000; ++i) {
                    this.nextToken();
                    if (this.token == Token.SELECT) {
                        return overwrite ? SQLType.INSERT_OVERWRITE_SELECT : SQLType.INSERT_INTO_SELECT;
                    }
                    if (this.token == Token.VALUES) {
                        return overwrite ? SQLType.INSERT_OVERWRITE_VALUES : SQLType.INSERT_INTO_VALUES;
                    }
                    if (this.token != Token.ERROR && this.token != Token.EOF) continue;
                    if (!overwrite) break;
                    sqlType = SQLType.INSERT_OVERWRITE;
                    break;
                }
                return sqlType;
            }
        }
        return sqlType;
    }

    public final void nextTokenAlias() {
        this.startPos = this.pos;
        this.bufPos = 0;
        while (CharTypes.isWhitespace(this.ch)) {
            if (this.ch == '\n') {
                ++this.line;
            }
            this.ch = this.charAt(++this.pos);
            this.startPos = this.pos;
        }
        if (this.ch == '\"') {
            this.scanAlias();
        } else if (this.ch == '\'') {
            int p;
            this.scanAlias();
            if (this.stringVal.length() > 1 && this.stringVal.indexOf(34) == -1 && ((p = this.stringVal.indexOf(39, 1)) == -1 || p == this.stringVal.length() - 1)) {
                char[] chars = this.stringVal.toCharArray();
                chars[0] = 34;
                chars[chars.length - 1] = 34;
                this.stringVal = new String(chars);
            }
            this.token = Token.LITERAL_ALIAS;
        } else {
            this.nextToken();
        }
    }

    public final void nextPath() {
        while (CharTypes.isWhitespace(this.ch)) {
            this.ch = this.charAt(++this.pos);
        }
        this.stringVal = null;
        this.mark = this.pos;
        while (!CharTypes.isWhitespace(this.ch)) {
            this.ch = this.charAt(++this.pos);
        }
        this.bufPos = this.pos - this.mark;
        this.ch = this.charAt(++this.pos);
        this.token = Token.LITERAL_PATH;
    }

    public final void nextTokenForSet() {
        while (CharTypes.isWhitespace(this.ch)) {
            this.ch = this.charAt(++this.pos);
        }
        if (CharTypes.isFirstIdentifierChar(this.ch) || this.ch == '{') {
            this.stringVal = null;
            this.mark = this.pos;
            while (this.ch != ';' && this.ch != '\u001a') {
                this.ch = this.charAt(++this.pos);
            }
            this.bufPos = this.pos - this.mark;
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.IDENTIFIER;
            return;
        }
        this.nextToken();
    }

    public final boolean skipToNextLine(int startPosition) {
        int pos;
        int i = 0;
        while (true) {
            char ch;
            if ((ch = this.charAt(pos = startPosition + i)) == '\n') {
                this.pos = pos;
                this.ch = this.charAt(this.pos);
                return true;
            }
            if (ch == '\u001a') break;
            ++i;
        }
        this.pos = pos;
        return false;
    }

    public final boolean skipToNextLineOrParameter(int startPosition) {
        int pos;
        int i = 0;
        while (true) {
            char ch;
            if ((ch = this.charAt(pos = startPosition + i)) == '\n') {
                this.pos = pos;
                this.ch = this.charAt(this.pos);
                return true;
            }
            if (ch == '$' && this.charAt(pos + 1) == '{') {
                this.pos = pos;
                this.ch = this.charAt(this.pos);
                return true;
            }
            if (ch == '\u001a') break;
            ++i;
        }
        this.pos = pos;
        return false;
    }

    public final void nextToken() {
        this.startPos = this.pos;
        this.bufPos = 0;
        if (this.comments != null && this.comments.size() > 0) {
            this.comments = null;
        }
        this.lines = 0;
        int startLine = this.line;
        block26: while (true) {
            if (CharTypes.isWhitespace(this.ch)) {
                if (this.ch == '\n') {
                    ++this.line;
                    this.lines = this.line - startLine;
                }
                this.ch = this.charAt(++this.pos);
                this.startPos = this.pos;
                continue;
            }
            if (this.ch == '$' && Lexer.isVaraintChar(this.charAt(this.pos + 1))) {
                this.scanVariable();
                return;
            }
            if (CharTypes.isFirstIdentifierChar(this.ch)) {
                if (this.ch == '\uff08') {
                    this.scanChar();
                    this.token = Token.LPAREN;
                    return;
                }
                if (this.ch == '\uff09') {
                    this.scanChar();
                    this.token = Token.RPAREN;
                    return;
                }
                if ((this.ch == 'N' || this.ch == 'n') && this.charAt(this.pos + 1) == '\'') {
                    ++this.pos;
                    this.ch = (char)39;
                    this.scanString();
                    this.token = Token.LITERAL_NCHARS;
                    return;
                }
                if (this.ch == '\u2014' && this.charAt(this.pos + 1) == '\u2014' && this.charAt(this.pos + 2) == '\n') {
                    this.pos += 3;
                    this.ch = this.charAt(this.pos);
                    continue;
                }
                this.scanIdentifier();
                return;
            }
            switch (this.ch) {
                case '0': {
                    if (this.charAt(this.pos + 1) == 'x') {
                        this.scanChar();
                        this.scanChar();
                        this.scanHexaDecimal();
                    } else {
                        this.scanNumber();
                    }
                    return;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber();
                    return;
                }
                case ',': 
                case '\uff0c': {
                    this.scanChar();
                    this.token = Token.COMMA;
                    return;
                }
                case '(': 
                case '\uff08': {
                    this.scanChar();
                    this.token = Token.LPAREN;
                    return;
                }
                case ')': 
                case '\uff09': {
                    this.scanChar();
                    this.token = Token.RPAREN;
                    return;
                }
                case '[': {
                    this.scanLBracket();
                    return;
                }
                case ']': {
                    this.scanChar();
                    this.token = Token.RBRACKET;
                    return;
                }
                case '{': {
                    this.scanChar();
                    this.token = Token.LBRACE;
                    return;
                }
                case '}': {
                    this.scanChar();
                    this.token = Token.RBRACE;
                    return;
                }
                case ':': {
                    this.scanChar();
                    if (this.ch == '=') {
                        this.scanChar();
                        this.token = Token.COLONEQ;
                    } else if (this.ch == ':') {
                        this.scanChar();
                        this.token = Token.COLONCOLON;
                    } else {
                        if (this.isEnabled(SQLParserFeature.TDDLHint) || this.dbType == DbType.hive || this.dbType == DbType.odps) {
                            this.token = Token.COLON;
                            return;
                        }
                        this.unscan();
                        this.scanVariable();
                    }
                    return;
                }
                case '#': {
                    this.scanSharp();
                    if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                        this.bufPos = 0;
                        continue block26;
                    }
                    return;
                }
                case '.': {
                    this.scanChar();
                    if (this.isDigit(this.ch) && (this.pos == 1 || this.token != Token.IDENTIFIER)) {
                        this.unscan();
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '.') {
                        this.scanChar();
                        if (this.ch == '.') {
                            this.scanChar();
                            this.token = Token.DOTDOTDOT;
                        } else {
                            this.token = Token.DOTDOT;
                        }
                    } else {
                        this.token = Token.DOT;
                    }
                    return;
                }
                case '\'': {
                    this.scanString();
                    return;
                }
                case '\"': {
                    this.scanAlias();
                    return;
                }
                case '*': {
                    this.scanChar();
                    this.token = Token.STAR;
                    return;
                }
                case '?': {
                    this.scanChar();
                    if (this.ch == '?' && DbType.postgresql == this.dbType) {
                        this.scanChar();
                        if (this.ch == '|') {
                            this.scanChar();
                            this.token = Token.QUESBAR;
                        } else {
                            this.token = Token.QUESQUES;
                        }
                    } else if (this.ch == '|' && DbType.postgresql == this.dbType) {
                        this.scanChar();
                        if (this.ch == '|') {
                            this.unscan();
                            this.token = Token.QUES;
                        } else {
                            this.token = Token.QUESBAR;
                        }
                    } else if (this.ch == '&' && DbType.postgresql == this.dbType) {
                        this.scanChar();
                        this.token = Token.QUESAMP;
                    } else {
                        this.token = Token.QUES;
                    }
                    return;
                }
                case ';': {
                    this.scanChar();
                    this.token = Token.SEMI;
                    return;
                }
                case '`': {
                    throw new ParserException("TODO. " + this.info());
                }
                case '@': {
                    this.scanVariable_at();
                    return;
                }
                case '-': {
                    char next = this.charAt(this.pos + 1);
                    if (next == '-') {
                        this.scanComment();
                        if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block26;
                        }
                    } else if (next >= '0' && next <= '9') {
                        if (this.token == null) {
                            this.scanNumber();
                            return;
                        }
                        switch (this.token) {
                            case COMMA: 
                            case LPAREN: 
                            case WITH: 
                            case BY: {
                                this.scanNumber();
                                break;
                            }
                            default: {
                                this.scanOperator();
                                break;
                            }
                        }
                    } else {
                        this.scanOperator();
                    }
                    return;
                }
                case '/': {
                    char nextChar = this.charAt(this.pos + 1);
                    if (nextChar == '/' || nextChar == '*' || nextChar == '!' && this.isEnabled(SQLParserFeature.TDDLHint)) {
                        this.scanComment();
                        if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block26;
                        }
                    } else if (nextChar == ' ' && this.charAt(this.pos + 2) == '*') {
                        this.scanComment();
                        if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block26;
                        }
                    } else if (nextChar == ' ' && this.charAt(this.pos + 2) == ' ' && this.charAt(this.pos + 3) == '*') {
                        this.scanComment();
                        if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block26;
                        }
                    } else {
                        this.token = Token.SLASH;
                        this.scanChar();
                    }
                    return;
                }
            }
            break;
        }
        if (Character.isLetter(this.ch)) {
            this.scanIdentifier();
            return;
        }
        if (this.isOperator(this.ch)) {
            this.scanOperator();
            return;
        }
        if (this.ch == '\\' && this.charAt(this.pos + 1) == 'N' && DbType.mysql == this.dbType) {
            this.scanChar();
            this.scanChar();
            this.token = Token.NULL;
            return;
        }
        if (this.isEOF()) {
            this.token = Token.EOF;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.scanChar();
        }
    }

    protected void scanLBracket() {
        this.scanChar();
        this.token = Token.LBRACKET;
    }

    private final void scanOperator() {
        switch (this.ch) {
            case '+': {
                this.scanChar();
                this.token = Token.PLUS;
                break;
            }
            case '-': {
                this.scanChar();
                if (this.ch == '>') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.scanChar();
                        this.token = Token.SUBGTGT;
                        break;
                    }
                    this.token = Token.SUBGT;
                    break;
                }
                this.token = Token.SUB;
                break;
            }
            case '*': {
                this.scanChar();
                this.token = Token.STAR;
                break;
            }
            case '/': {
                this.scanChar();
                this.token = Token.SLASH;
                break;
            }
            case '&': {
                this.scanChar();
                if (this.ch == '&') {
                    this.scanChar();
                    this.token = Token.AMPAMP;
                    break;
                }
                this.token = Token.AMP;
                break;
            }
            case '|': {
                this.scanChar();
                if (this.ch == '|') {
                    this.scanChar();
                    if (this.ch == '/') {
                        this.scanChar();
                        this.token = Token.BARBARSLASH;
                        break;
                    }
                    this.token = Token.BARBAR;
                    break;
                }
                if (this.ch == '/') {
                    this.scanChar();
                    this.token = Token.BARSLASH;
                    break;
                }
                this.token = Token.BAR;
                break;
            }
            case '^': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.CARETEQ;
                    break;
                }
                this.token = Token.CARET;
                break;
            }
            case '%': {
                this.scanChar();
                this.token = Token.PERCENT;
                break;
            }
            case '=': {
                this.scanChar();
                if (this.ch == ' ') {
                    this.scanChar();
                }
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.EQEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.EQGT;
                    break;
                }
                this.token = Token.EQ;
                break;
            }
            case '>': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.GTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.GTGT;
                    break;
                }
                this.token = Token.GT;
                break;
            }
            case '<': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.token = Token.LTEQGT;
                        this.scanChar();
                        break;
                    }
                    this.token = Token.LTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.LTGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.LTLT;
                    break;
                }
                if (this.ch == '@') {
                    this.scanChar();
                    this.token = Token.LT_MONKEYS_AT;
                    break;
                }
                if (this.ch == '-' && this.charAt(this.pos + 1) == '>') {
                    this.scanChar();
                    this.scanChar();
                    this.token = Token.LT_SUB_GT;
                    break;
                }
                if (this.ch == ' ') {
                    char c1 = this.charAt(this.pos + 1);
                    if (c1 == '=') {
                        this.scanChar();
                        this.scanChar();
                        if (this.ch == '>') {
                            this.token = Token.LTEQGT;
                            this.scanChar();
                            break;
                        }
                        this.token = Token.LTEQ;
                        break;
                    }
                    if (c1 == '>') {
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LTGT;
                        break;
                    }
                    if (c1 == '<') {
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LTLT;
                        break;
                    }
                    if (c1 == '@') {
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LT_MONKEYS_AT;
                        break;
                    }
                    if (c1 == '-' && this.charAt(this.pos + 2) == '>') {
                        this.scanChar();
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LT_SUB_GT;
                        break;
                    }
                    this.token = Token.LT;
                    break;
                }
                this.token = Token.LT;
                break;
            }
            case '!': {
                this.scanChar();
                while (CharTypes.isWhitespace(this.ch)) {
                    this.scanChar();
                }
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.BANGEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.BANGGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.BANGLT;
                    break;
                }
                if (this.ch == '!') {
                    this.scanChar();
                    this.token = Token.BANGBANG;
                    break;
                }
                if (this.ch == '~') {
                    this.scanChar();
                    if (this.ch == '*') {
                        this.scanChar();
                        this.token = Token.BANG_TILDE_STAR;
                        break;
                    }
                    this.token = Token.BANG_TILDE;
                    break;
                }
                this.token = Token.BANG;
                break;
            }
            case '?': {
                this.scanChar();
                this.token = Token.QUES;
                break;
            }
            case '~': {
                this.scanChar();
                if (this.ch == '*') {
                    this.scanChar();
                    this.token = Token.TILDE_STAR;
                    break;
                }
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.TILDE_EQ;
                    break;
                }
                this.token = Token.TILDE;
                break;
            }
            default: {
                throw new ParserException("TODO. " + this.info());
            }
        }
    }

    protected void scanString() {
        this.mark = this.pos;
        boolean hasSpecial = false;
        Token preToken = this.token;
        while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? (preToken == Token.AS ? this.subString(this.mark, this.bufPos + 2) : this.subString(this.mark + 1, this.bufPos)) : new String(this.buf, 0, this.bufPos);
    }

    protected final void scanString2() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\'') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.text.substring(this.pos, endIndex + 1) : (startIndex == endIndex ? "" : this.text.substring(startIndex, endIndex));
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block15: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block15;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block15;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block15;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block15;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block15;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block15;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block15;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block15;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block15;
                    }
                    case '%': {
                        if (this.dbType == DbType.mysql) {
                            this.putChar('\\');
                        }
                        this.putChar('%');
                        continue block15;
                    }
                    case '_': {
                        if (this.dbType == DbType.mysql) {
                            this.putChar('\\');
                        }
                        this.putChar('_');
                        continue block15;
                    }
                    case 'u': {
                        if ((this.features & SQLParserFeature.SupportUnicodeCodePoint.mask) != 0) {
                            char c1 = this.charAt(++this.pos);
                            char c2 = this.charAt(++this.pos);
                            char c3 = this.charAt(++this.pos);
                            char c4 = this.charAt(++this.pos);
                            int intVal = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                            this.putChar((char)intVal);
                            continue block15;
                        }
                        this.putChar(this.ch);
                        continue block15;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    protected final void scanString2_d() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            int i1;
            char ch = this.text.charAt(i);
            if (ch == '\\' && (i1 = i + 1) < this.text.length()) {
                hasSpecial = true;
                ++i;
                continue;
            }
            if (ch != '\"') continue;
            i1 = i + 1;
            if (i1 < this.text.length() && this.text.charAt(i1) == '\"') {
                hasSpecial = true;
                ++i;
                continue;
            }
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.subString(this.pos, endIndex + 1 - this.pos) : (this.charAt(endIndex + 1) == '.' ? this.subString(startIndex - 1, endIndex - startIndex + 2) : this.subString(startIndex, endIndex - startIndex));
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch == '.') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.IDENTIFIER;
                return;
            }
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block14: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block14;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block14;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block14;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block14;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block14;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block14;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block14;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block14;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block14;
                    }
                    case '%': {
                        if (this.dbType == DbType.mysql) {
                            this.putChar('\\');
                        }
                        this.putChar('%');
                        continue block14;
                    }
                    case '_': {
                        if (this.dbType == DbType.mysql) {
                            this.putChar('\\');
                        }
                        this.putChar('_');
                        continue block14;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\"') {
                this.scanChar();
                if (this.ch != '\"') {
                    if (this.buf != null && this.bufPos > 0) {
                        this.stringVal = new String(this.buf, 0, this.bufPos);
                    }
                    break;
                }
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\"');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    protected final void scanAlias() {
        char quote = this.ch;
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch_next;
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                ++i;
                continue;
            }
            if (ch != quote) continue;
            if (i + 1 < this.text.length() && (ch_next = this.charAt(i + 1)) == quote) {
                hasSpecial = true;
                ++i;
                continue;
            }
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.subString(this.pos, endIndex + 1 - this.pos);
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_ALIAS;
                return;
            }
        }
        this.mark = this.pos;
        this.initBuff(this.bufPos);
        this.putChar(this.ch);
        block13: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block13;
                    }
                    case '\'': {
                        if (this.ch == quote) {
                            this.putChar('\\');
                        }
                        this.putChar('\'');
                        continue block13;
                    }
                    case '\"': {
                        if (this.ch == quote) {
                            this.putChar('\\');
                        }
                        this.putChar('\"');
                        continue block13;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block13;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block13;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block13;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block13;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.putChar('\\');
                        continue block13;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block13;
                    }
                    case 'u': {
                        if (this.dbType == DbType.hive) {
                            char c1 = this.charAt(++this.pos);
                            char c2 = this.charAt(++this.pos);
                            char c3 = this.charAt(++this.pos);
                            char c4 = this.charAt(++this.pos);
                            int intVal = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                            this.putChar((char)intVal);
                            continue block13;
                        }
                        this.putChar(this.ch);
                        continue block13;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == quote) {
                char ch_next = this.charAt(this.pos + 1);
                if (ch_next == quote) {
                    this.putChar('\\');
                    this.putChar(this.ch);
                    this.scanChar();
                    continue;
                }
                break;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.putChar(this.ch);
        this.scanChar();
        this.token = Token.LITERAL_ALIAS;
        this.stringVal = new String(this.buf, 0, this.bufPos);
    }

    public void scanSharp() {
        this.scanVariable();
    }

    public void scanVariable() {
        char ch;
        if (this.ch != ':' && this.ch != '#' && this.ch != '$' && (this.ch != '@' || this.dbType != DbType.odps)) {
            throw new ParserException("illegal variable. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        char c1 = this.charAt(this.pos + 1);
        if (c1 == '>' && DbType.postgresql == this.dbType) {
            this.pos += 2;
            this.token = Token.MONKEYS_AT_GT;
            this.ch = this.charAt(++this.pos);
            return;
        }
        if (c1 == '{') {
            char ch2;
            ++this.pos;
            ++this.bufPos;
            boolean ident = false;
            while (true) {
                ch2 = this.charAt(++this.pos);
                if (this.isEOF()) {
                    --this.pos;
                    --this.bufPos;
                    break;
                }
                if (ch2 == '}' && !ident) {
                    if (!CharTypes.isIdentifierChar(this.charAt(this.pos + 1))) break;
                    ++this.bufPos;
                    ident = true;
                    continue;
                }
                if (ident && CharTypes.isWhitespace(ch2)) break;
                ++this.bufPos;
            }
            if (ch2 != '}' && !ident) {
                throw new ParserException("syntax error. " + this.info());
            }
            ++this.pos;
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
            if (this.dbType == DbType.odps) {
                while (CharTypes.isIdentifierChar(this.ch)) {
                    ++this.pos;
                    ++this.bufPos;
                    this.ch = this.charAt(this.pos);
                }
            }
            this.stringVal = this.addSymbol();
            this.token = ident ? Token.IDENTIFIER : Token.VARIANT;
            return;
        }
        if (c1 == '$' && this.charAt(this.pos + 2) == '{') {
            char ch3;
            this.pos += 2;
            this.bufPos += 2;
            while ((ch3 = this.charAt(++this.pos)) != '}') {
                ++this.bufPos;
            }
            if (ch3 != '}') {
                throw new ParserException("syntax error. " + this.info());
            }
            ++this.pos;
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
            if (this.dbType == DbType.odps) {
                while (CharTypes.isIdentifierChar(this.ch)) {
                    ++this.pos;
                    ++this.bufPos;
                    this.ch = this.charAt(this.pos);
                }
            }
            this.stringVal = this.addSymbol();
            this.token = Token.VARIANT;
            return;
        }
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        this.token = Token.VARIANT;
    }

    protected void scanVariable_at() {
        char ch;
        if (this.ch != '@') {
            throw new ParserException("illegal variable. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        char c1 = this.charAt(this.pos + 1);
        if (c1 == '@') {
            ++this.pos;
            ++this.bufPos;
        }
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        this.token = Token.VARIANT;
    }

    public void scanComment() {
        if (!this.allowComment) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' && this.charAt(this.pos + 1) == '/' || this.ch == '-' && this.charAt(this.pos + 1) == '-') {
            this.scanSingleLineComment();
        } else if (this.ch == '/' && this.charAt(this.pos + 1) == '*') {
            this.scanMultiLineComment();
        } else {
            throw new IllegalStateException();
        }
    }

    protected final void scanHiveComment() {
        if (this.ch != '/' && this.ch != '-') {
            throw new IllegalStateException();
        }
        Token lastToken = this.token;
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == ' ') {
            this.mark = this.pos;
            this.bufPos = 0;
            this.scanChar();
            if (this.dbType == DbType.odps && this.ch == ' ') {
                this.mark = this.pos;
                this.bufPos = 0;
                this.scanChar();
            }
        }
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.bufPos;
            }
            boolean isHint = false;
            int startHintSp = this.bufPos + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.bufPos;
            }
            while (true) {
                if (this.ch == '*') {
                    if (this.charAt(this.pos + 1) == '/') {
                        this.bufPos += 2;
                        this.scanChar();
                        this.scanChar();
                        break;
                    }
                    if (CharTypes.isWhitespace(this.charAt(this.pos + 1))) {
                        int i;
                        for (i = 2; i < 0x100000 && CharTypes.isWhitespace(this.charAt(this.pos + i)); ++i) {
                        }
                        if (this.charAt(this.pos + i) == '/') {
                            this.bufPos += 2;
                            this.pos += i + 1;
                            this.ch = this.charAt(this.pos);
                            break;
                        }
                    }
                }
                this.scanChar();
                if (this.ch == '\u001a') break;
                ++this.bufPos;
            }
            if (isHint) {
                this.stringVal = this.subString(this.mark + startHintSp, this.bufPos - startHintSp - 1);
                this.token = Token.HINT;
            } else {
                this.stringVal = this.subString(this.mark, this.bufPos + 1);
                this.token = Token.MULTI_LINE_COMMENT;
                ++this.commentCount;
                if (this.keepComments) {
                    this.addComment(this.stringVal);
                }
            }
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        ++this.line;
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    ++this.line;
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark, this.ch != '\u001a' ? this.bufPos : this.bufPos + 1);
            this.token = Token.LINE_COMMENT;
            ++this.commentCount;
            if (this.keepComments) {
                this.addComment(this.stringVal);
            }
            this.endOfComment = this.isEOF();
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            return;
        }
    }

    private void scanMultiLineComment() {
        Token lastToken = this.token;
        int depth = 1;
        this.scanChar();
        this.scanChar();
        this.mark = this.pos;
        this.bufPos = 0;
        while (true) {
            if (this.ch == '/' && this.charAt(this.pos + 1) == '*') {
                this.scanChar();
                this.scanChar();
                if (this.ch == '!' || this.ch == '+') {
                    this.scanChar();
                    ++depth;
                }
            }
            if (this.ch == '*' && this.charAt(this.pos + 1) == '/') {
                this.scanChar();
                this.scanChar();
                if (0 == --depth) break;
            }
            if (this.ch == '\u001a') {
                throw new ParserException("unterminated /* comment. " + this.info());
            }
            this.scanChar();
            ++this.bufPos;
        }
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.MULTI_LINE_COMMENT;
        ++this.commentCount;
        if (this.keepComments) {
            this.addComment(this.stringVal);
        }
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        if (!this.isAllowComment() && !this.isSafeComment(this.stringVal)) {
            throw new NotAllowCommentException();
        }
    }

    private void scanSingleLineComment() {
        Token lastToken = this.token;
        this.mark = this.pos;
        this.bufPos = 2;
        this.scanChar();
        this.scanChar();
        while (true) {
            if (this.ch == '\r') {
                if (this.charAt(this.pos + 1) == '\n') {
                    ++this.line;
                    this.scanChar();
                    break;
                }
                ++this.bufPos;
                break;
            }
            if (this.ch == '\n') {
                ++this.line;
                this.scanChar();
                break;
            }
            if (this.ch == '\u001a') break;
            this.scanChar();
            ++this.bufPos;
        }
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.LINE_COMMENT;
        ++this.commentCount;
        if (this.keepComments) {
            this.addComment(this.stringVal);
        }
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        if (!this.isAllowComment() && !this.isSafeComment(this.stringVal)) {
            throw new NotAllowCommentException();
        }
    }

    public void scanIdentifier() {
        this.hashLCase = 0L;
        this.hash = 0L;
        char first = this.ch;
        if (this.ch == '`') {
            this.mark = this.pos;
            this.bufPos = 1;
            int startPos = this.pos + 1;
            int quoteIndex = this.text.indexOf(96, startPos);
            if (quoteIndex == -1) {
                throw new ParserException("illegal identifier. " + this.info());
            }
            this.hashLCase = -3750763034362895579L;
            this.hash = -3750763034362895579L;
            for (int i = startPos; i < quoteIndex; ++i) {
                int ch = this.text.charAt(i);
                this.hashLCase ^= (long)(ch >= 65 && ch <= 90 ? ch + 32 : ch);
                this.hashLCase *= 1099511628211L;
                this.hash ^= (long)ch;
                this.hash *= 1099511628211L;
            }
            this.stringVal = MySqlLexer.quoteTable.addSymbol(this.text, this.pos, quoteIndex + 1 - this.pos, this.hash);
            this.pos = quoteIndex + 1;
            this.ch = this.charAt(this.pos);
            this.token = Token.IDENTIFIER;
            return;
        }
        boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
        if (!firstFlag) {
            throw new ParserException("illegal identifier. " + this.info());
        }
        this.hashLCase = -3750763034362895579L;
        this.hash = -3750763034362895579L;
        this.hashLCase ^= (long)(this.ch >= 'A' && this.ch <= 'Z' ? this.ch + 32 : this.ch);
        this.hashLCase *= 1099511628211L;
        this.hash ^= (long)this.ch;
        this.hash *= 1099511628211L;
        this.mark = this.pos;
        this.bufPos = 1;
        int ch = 0;
        while (true) {
            int c0 = ch;
            if (!CharTypes.isIdentifierChar((char)(ch = this.charAt(++this.pos)))) {
                if (ch != 65288 && ch != 65289 || c0 <= 256) break;
                ++this.bufPos;
                continue;
            }
            this.hashLCase ^= (long)(ch >= 65 && ch <= 90 ? ch + 32 : ch);
            this.hashLCase *= 1099511628211L;
            this.hash ^= (long)ch;
            this.hash *= 1099511628211L;
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        if (this.bufPos == 1) {
            switch (first) {
                case '\uff08': {
                    this.token = Token.LPAREN;
                    return;
                }
                case '\uff09': {
                    this.token = Token.RPAREN;
                    return;
                }
            }
            this.token = Token.IDENTIFIER;
            this.stringVal = CharTypes.valueOf(first);
            if (this.stringVal == null) {
                this.stringVal = Character.toString(first);
            }
            return;
        }
        Token tok = this.keywords.getKeyword(this.hashLCase);
        if (tok != null) {
            this.token = tok;
            this.stringVal = this.token == Token.IDENTIFIER ? SymbolTable.global.addSymbol(this.text, this.mark, this.bufPos, this.hash) : null;
        } else {
            this.token = Token.IDENTIFIER;
            this.stringVal = SymbolTable.global.addSymbol(this.text, this.mark, this.bufPos, this.hash);
        }
    }

    public void scanNumber() {
        this.mark = this.pos;
        this.numberSale = 0;
        this.numberExp = false;
        this.bufPos = 0;
        if (this.ch == '0' && this.charAt(this.pos + 1) == 'b' && this.dbType != DbType.odps) {
            int i = 2;
            int mark = this.pos + 2;
            while (true) {
                char ch;
                if ((ch = this.charAt(this.pos + i)) != '0' && ch != '1') {
                    if (ch >= '2' && ch <= '9') break;
                    this.bufPos += i;
                    this.pos += i;
                    this.stringVal = this.subString(mark, i - 2);
                    this.ch = this.charAt(this.pos);
                    this.token = Token.BITS;
                    return;
                }
                ++i;
            }
        }
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        if (this.ch == '.') {
            if (this.charAt(this.pos + 1) == '.') {
                this.token = Token.LITERAL_INT;
                return;
            }
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            this.numberSale = 0;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
                ++this.numberSale;
            }
            this.numberExp = true;
        }
        if ((this.ch == 'e' || this.ch == 'E') && (this.isDigit(this.charAt(this.pos + 1)) || Lexer.isDigit2(this.charAt(this.pos + 1)) && Lexer.isDigit2(this.charAt(this.pos + 2)))) {
            this.numberExp = true;
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            if (this.ch == '+' || this.ch == '-') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            if (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z') {
                this.numberExp = false;
            }
        }
        if (this.numberSale > 0 || this.numberExp) {
            if (this.text.charAt(this.mark) == '.' && CharTypes.isIdentifierChar(this.ch)) {
                this.pos = this.mark + 1;
                this.ch = this.charAt(this.pos);
                this.token = Token.DOT;
                return;
            }
            this.token = Token.LITERAL_FLOAT;
            return;
        }
        if (this.ch != '`' && CharTypes.isFirstIdentifierChar(this.ch) && this.ch != '\uff09' && (this.ch != 'b' || this.bufPos != 1 || this.charAt(this.pos - 1) != '0' || this.dbType == DbType.odps)) {
            ++this.bufPos;
            boolean brace = false;
            while (true) {
                char c0 = this.ch;
                this.ch = this.charAt(++this.pos);
                if (this.isEOF()) break;
                if (!CharTypes.isIdentifierChar(this.ch)) {
                    if (this.ch == '{' && this.charAt(this.pos - 1) == '$' && !brace) {
                        ++this.bufPos;
                        brace = true;
                        continue;
                    }
                    if (this.ch == '}' && brace) {
                        ++this.bufPos;
                        brace = false;
                        continue;
                    }
                    if (this.ch != '\uff08' && this.ch != '\uff09' || c0 <= '\u0100') break;
                    ++this.bufPos;
                    continue;
                }
                ++this.bufPos;
            }
            this.stringVal = this.addSymbol();
            this.hashLCase = FnvHash.hashCode64(this.stringVal);
            this.token = Token.IDENTIFIER;
            return;
        }
        this.token = Token.LITERAL_INT;
    }

    public void scanHexaDecimal() {
        this.mark = this.pos++;
        this.bufPos = 0;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (CharTypes.isHex(this.ch)) {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        if (CharTypes.isIdentifierChar(this.ch)) {
            do {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            } while (CharTypes.isIdentifierChar(this.ch));
            this.mark -= 2;
            this.bufPos += 2;
            this.stringVal = this.addSymbol();
            this.hashLCase = FnvHash.hashCode64(this.stringVal);
            this.token = Token.IDENTIFIER;
            return;
        }
        this.token = Token.LITERAL_HEX;
    }

    public String hexString() {
        return this.subString(this.mark, this.bufPos);
    }

    public final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected static final boolean isDigit2(char ch) {
        return ch == '+' || ch == '-' || ch >= '0' && ch <= '9';
    }

    protected final void putChar(char ch) {
        if (this.bufPos == this.buf.length) {
            char[] newsbuf = new char[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newsbuf, 0, this.buf.length);
            this.buf = newsbuf;
        }
        this.buf[this.bufPos++] = ch;
    }

    public final int pos() {
        return this.pos;
    }

    public final String stringVal() {
        if (this.stringVal == null) {
            this.stringVal = this.subString(this.mark, this.bufPos);
        }
        return this.stringVal;
    }

    private final void stringVal(StringBuffer out) {
        if (this.stringVal != null) {
            out.append(this.stringVal);
            return;
        }
        out.append(this.text, this.mark, this.mark + this.bufPos);
    }

    public final boolean identifierEquals(String text) {
        if (this.token != Token.IDENTIFIER) {
            return false;
        }
        if (this.stringVal == null) {
            this.stringVal = this.subString(this.mark, this.bufPos);
        }
        return text.equalsIgnoreCase(this.stringVal);
    }

    public final boolean identifierEquals(long hash_lower) {
        if (this.token != Token.IDENTIFIER) {
            return false;
        }
        if (this.hashLCase == 0L) {
            if (this.stringVal == null) {
                this.stringVal = this.subString(this.mark, this.bufPos);
            }
            this.hashLCase = FnvHash.fnv1a_64_lower(this.stringVal);
        }
        return this.hashLCase == hash_lower;
    }

    public final long hashLCase() {
        if (this.hashLCase == 0L) {
            if (this.stringVal == null) {
                this.stringVal = this.subString(this.mark, this.bufPos);
            }
            this.hashLCase = FnvHash.fnv1a_64_lower(this.stringVal);
        }
        return this.hashLCase;
    }

    public final List<String> readAndResetComments() {
        List<String> comments = this.comments;
        this.comments = null;
        return comments;
    }

    private boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public final boolean isNegativeIntegerValue() {
        return this.charAt(this.mark) == '-';
    }

    public final Number integerValue() {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.mark;
        int max = this.mark + this.bufPos;
        if (this.charAt(this.mark) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = this.charAt(i++) - 48;
            result = -digit;
        }
        while (i < max) {
            digit = this.charAt(i++) - 48;
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.mark + 1) {
                if (result >= Integer.MIN_VALUE) {
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE) {
            return (int)result;
        }
        return result;
    }

    public int bp() {
        return this.pos;
    }

    public char current() {
        return this.ch;
    }

    @Deprecated
    public void reset(int mark, char markChar, Token token) {
        this.pos = mark;
        this.ch = markChar;
        this.token = token;
    }

    public final String numberString() {
        return this.text.substring(this.mark, this.mark + this.bufPos);
    }

    public BigDecimal decimalValue() {
        int len;
        if (this.numberSale > 0 && !this.numberExp && (len = this.bufPos) < 20) {
            long unscaleVal = 0L;
            boolean negative = false;
            int i = 0;
            char first = this.text.charAt(this.mark);
            if (first == '+') {
                ++i;
            } else if (first == '-') {
                ++i;
                negative = true;
            }
            while (i < len) {
                char ch = this.text.charAt(this.mark + i);
                if (ch != '.') {
                    int digit = ch - 48;
                    unscaleVal = unscaleVal * 10L + (long)digit;
                }
                ++i;
            }
            return BigDecimal.valueOf(negative ? -unscaleVal : unscaleVal, this.numberSale);
        }
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        return new BigDecimal(value);
    }

    public SQLNumberExpr numberExpr() {
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        return new SQLNumberExpr(value);
    }

    public SQLNumberExpr numberExpr(SQLObject parent) {
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        return new SQLNumberExpr(value, parent);
    }

    public SQLNumberExpr numberExpr(boolean negate) {
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        if (negate) {
            char[] chars = new char[value.length + 1];
            chars[0] = 45;
            System.arraycopy(value, 0, chars, 1, value.length);
            return new SQLNumberExpr(chars);
        }
        return new SQLNumberExpr(value);
    }

    public boolean hasComment() {
        return this.comments != null;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public void skipToEOF() {
        this.pos = this.text.length();
        this.token = Token.EOF;
    }

    public boolean isEndOfComment() {
        return this.endOfComment;
    }

    protected boolean isSafeComment(String comment) {
        if (comment == null) {
            return true;
        }
        return (comment = comment.toLowerCase()).indexOf("select") == -1 && comment.indexOf("delete") == -1 && comment.indexOf("insert") == -1 && comment.indexOf("update") == -1 && comment.indexOf("into") == -1 && comment.indexOf("where") == -1 && comment.indexOf("or") == -1 && comment.indexOf("and") == -1 && comment.indexOf("union") == -1 && comment.indexOf(39) == -1 && comment.indexOf(61) == -1 && comment.indexOf(62) == -1 && comment.indexOf(60) == -1 && comment.indexOf(38) == -1 && comment.indexOf(124) == -1 && comment.indexOf(94) == -1;
    }

    protected void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>(2);
        }
        this.comments.add(comment);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public int getLine() {
        return this.line;
    }

    public void computeRowAndColumn() {
        int line = 1;
        int column = 1;
        for (int i = 0; i < this.startPos; ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\n') {
                column = 0;
                ++line;
                continue;
            }
            ++column;
        }
        this.posLine = line;
        this.posColumn = column;
    }

    public int getPosLine() {
        return this.posLine;
    }

    public int getPosColumn() {
        return this.posColumn;
    }

    public void config(SQLParserFeature feature, boolean state) {
        this.features = SQLParserFeature.config(this.features, feature, state);
        if (feature == SQLParserFeature.OptimizedForParameterized) {
            this.optimizedForParameterized = state;
        } else if (feature == SQLParserFeature.KeepComments) {
            this.keepComments = state;
        } else if (feature == SQLParserFeature.KeepSourceLocation) {
            this.keepSourceLocation = state;
        } else if (feature == SQLParserFeature.SkipComments) {
            this.skipComment = state;
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public final boolean isEnabled(SQLParserFeature feature) {
        return SQLParserFeature.isEnabled(this.features, feature);
    }

    public static String parameterize(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.optimizedForParameterized = true;
        lexer.nextToken();
        StringBuffer buf = new StringBuffer();
        block9: while (true) {
            Token token = lexer.token;
            switch (token) {
                case LITERAL_ALIAS: 
                case LITERAL_FLOAT: 
                case LITERAL_CHARS: 
                case LITERAL_INT: 
                case LITERAL_NCHARS: 
                case LITERAL_HEX: 
                case VARIANT: {
                    if (buf.length() != 0) {
                        buf.append(' ');
                    }
                    buf.append('?');
                    break;
                }
                case COMMA: {
                    buf.append(',');
                    break;
                }
                case EQ: {
                    buf.append('=');
                    break;
                }
                case EOF: {
                    break block9;
                }
                case ERROR: {
                    return sql;
                }
                case SELECT: {
                    buf.append("SELECT");
                    break;
                }
                case UPDATE: {
                    buf.append("UPDATE");
                    break;
                }
                default: {
                    if (buf.length() != 0) {
                        buf.append(' ');
                    }
                    lexer.stringVal(buf);
                }
            }
            lexer.nextToken();
        }
        return buf.toString();
    }

    public String getSource() {
        return this.text;
    }

    static {
        for (int i = 48; i <= 57; ++i) {
            Lexer.digits[i] = i - 48;
        }
    }

    public static interface CommentHandler {
        public boolean handle(Token var1, String var2);
    }

    public static class SavePoint {
        int bp;
        int startPos;
        int sp;
        int np;
        char ch;
        long hash;
        long hashLCase;
        public Token token;
        String stringVal;
    }
}

