/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.model;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector<Object> vector;
    protected String text;
    private int margin;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this.renderer = renderer == null ? new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : renderer;
        this.text = text;
        this.vector = new Vector();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.vector.addElement(obj);
    }

    public Vector<ColumnGroup> getColumnGroups(TableColumn column, Vector<ColumnGroup> group) {
        group.addElement(this);
        if (this.vector.contains(column)) {
            return group;
        }
        Enumeration<Object> enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector<ColumnGroup> groups;
            Object obj = enumeration.nextElement();
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(column, (Vector)group.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public int getSize() {
        return this.vector == null ? 0 : this.vector.size();
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration<Object> enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                width += this.margin;
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    public String getText() {
        return this.text;
    }

    public boolean removeColumn(ColumnGroup ptg, TableColumn tc) {
        boolean retFlag = false;
        if (tc != null) {
            for (int i = 0; i < ptg.vector.size(); ++i) {
                Object tmpObj = ptg.vector.get(i);
                if (tmpObj instanceof ColumnGroup) {
                    retFlag = this.removeColumn((ColumnGroup)tmpObj, tc);
                    if (!retFlag) continue;
                    break;
                }
                if (!(tmpObj instanceof TableColumn) || tmpObj != tc) continue;
                ptg.vector.remove(i);
                retFlag = true;
                break;
            }
        }
        return retFlag;
    }

    public boolean removeColumnGrp(ColumnGroup ptg, ColumnGroup tg) {
        boolean retFlag = false;
        if (tg != null) {
            for (int i = 0; i < ptg.vector.size(); ++i) {
                Object tmpObj = ptg.vector.get(i);
                if (tmpObj instanceof ColumnGroup) {
                    if (tmpObj == tg) {
                        ptg.vector.remove(i);
                        retFlag = true;
                        break;
                    }
                    retFlag = this.removeColumnGrp((ColumnGroup)tmpObj, tg);
                    if (!retFlag) continue;
                    break;
                }
                if (tmpObj instanceof TableColumn) break;
            }
        }
        return retFlag;
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        Enumeration<Object> enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public void setText(String newText) {
        this.text = newText;
    }
}

