/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.srcgenerator;

import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import net.java.quickcheck.srcgenerator.Assertion;
import net.java.quickcheck.srcgenerator.Traversal;

final class Parameter {
    String name;
    String type;
    Cardinality cardinality;

    Parameter(CharSequence name, CharSequence type, Cardinality cardinality) {
        Assertion.assertNotNull(name, "name");
        Assertion.assertNotNull(type, "type");
        Assertion.assertNotNull((Object)cardinality, "cardinality");
        this.name = ((Object)name).toString();
        this.type = ((Object)type).toString();
        this.cardinality = cardinality;
    }

    Parameter(CharSequence name, CharSequence type) {
        this(name, type, Cardinality.ONE);
    }

    public Parameter(VariableElement v, Cardinality cardinality) {
        TypeMirror parameterType = v.asType();
        boolean anArray = parameterType.accept(new Traversal.DecliningTypeVisitor<Boolean>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Object p) {
                return false;
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Object p) {
                return false;
            }

            @Override
            public Boolean visitArray(ArrayType t, Object p) {
                return true;
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Object p) {
                return false;
            }
        }, null);
        this.cardinality = anArray ? cardinality : Cardinality.ONE;
        this.type = anArray ? ((Object)((ArrayType)parameterType).getComponentType()).toString() : ((Object)parameterType).toString();
        this.name = v.getSimpleName().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return this.name.equals(other.name) && this.type.equals(other.type) && this.cardinality == other.cardinality;
    }

    public String toString() {
        return String.format("Parameter[name=%s, type=%s, cardinality=%s]", new Object[]{this.name, this.type, this.cardinality});
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static enum Cardinality {
        ARRAY,
        VARARRAY,
        ONE;

    }
}

