/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.srcgenerator;

import java.util.List;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import net.java.quickcheck.srcgenerator.Assertion;

final class TypeParameter {
    final String type;
    final String bound;

    TypeParameter(String type, String bound) {
        this.type = type;
        this.bound = bound;
    }

    TypeParameter(TypeParameterElement typeParameter) {
        Assertion.assertNotNull(typeParameter, "typeParameter");
        this.type = TypeParameter.getTypeString(typeParameter);
        this.bound = TypeParameter.getBound(typeParameter);
        Assertion.assertNotNull(this.type, "type");
    }

    private static String getBound(TypeParameterElement typeParameter) {
        List<? extends TypeMirror> bounds = typeParameter.getBounds();
        Assertion.assertTrue(typeParameter.getBounds().size() < 2, "Only 1 bound argument supported.", new Object[0]);
        return bounds.isEmpty() ? null : ((Object)bounds.get(0)).toString();
    }

    private static String getTypeString(TypeParameterElement typeParameter) {
        return typeParameter.toString();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeParameter)) {
            return false;
        }
        TypeParameter other = (TypeParameter)obj;
        if (this.bound == null ? other.bound != null : !this.bound.equals(other.bound)) {
            return false;
        }
        return this.type.equals(other.type);
    }

    public String toString() {
        return String.format("TypeParameter[type=%s, bound=%s]", this.type == null ? "" : this.type, this.bound == null ? "" : this.bound);
    }
}

