/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.util.msgpush.RobotDbUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.PerfmanCollector;
import org.jivesoftware.openfire.plugin.util.StatusEnum;
import org.jivesoftware.openfire.plugin.util.StatusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class StatusWithOutSubIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(StatusWithOutSubIQHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/statuswithoutsub");
    private static final String COMMAND = "query";
    private static final String STATUS_XMLNS = "http://weaver.com.cn/statuswithoutsub";

    public StatusWithOutSubIQHandler() {
        super("StatusWithOutSubIQHandler");
        Log.info("init status iq handler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        IQ reply = IQ.createResultIQ((IQ)packet);
        if (!StatusUtils.isStatusOpen() || !StatusUtils.isStatusSyncOpen()) {
            Log.debug("system closed the status sync interface.");
            reply.setError(PacketError.Condition.not_allowed);
            return reply;
        }
        if (packet.getFrom() == null) {
            Log.debug("invalid packet, no handle, packet id:{}", (Object)packet.getID());
            return null;
        }
        PerfmanCollector.incrStatusQueryCaculater();
        String data = packet.getElement().elementText(COMMAND);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement(COMMAND);
        HashSet<String> onlineDev = new HashSet<String>();
        HashSet<String> offlineDev = new HashSet<String>();
        HashSet<String> allOnlineDev = new HashSet<String>();
        HashSet<String> awayDev = new HashSet<String>();
        HashSet<String> uidList = new HashSet<String>();
        Log.debug("get status, from jid:{}, uid array:{}, request id:{}", new Object[]{packet.getFrom().toString(), data, packet.getID()});
        if (packet.getType().equals((Object)IQ.Type.get)) {
            JSONArray jsonUserIdArray = JSON.parseArray((String)data);
            int userNum = jsonUserIdArray.size();
            int maxLimit = StatusUtils.getStatusSubscribeMaxNum();
            int validUserNum = 0;
            for (int index = 0; index < userNum; ++index) {
                String userId = jsonUserIdArray.getString(index);
                if (userId.isEmpty() || userId.equals("null")) {
                    Log.debug("query status list have null userid");
                    continue;
                }
                boolean isNotAdd = uidList.add(userId);
                if (!isNotAdd) {
                    Log.debug("already added into set, skip this userid:{}", (Object)userId);
                    continue;
                }
                if (++validUserNum > maxLimit) {
                    Log.warn("query status list too large, limit is {}, break", (Object)maxLimit);
                    break;
                }
                StatusEnum pcStatus = StatusUtils.getStatus(userId, "pc");
                StatusEnum mobileStatus = StatusUtils.getStatus(userId, "mobile");
                if (RobotDbUtil.userIdList != null && RobotDbUtil.userIdList.contains(userId)) {
                    pcStatus = StatusEnum.DEV_ONLINE;
                    mobileStatus = StatusEnum.DEV_ONLINE;
                }
                if (RobotDbUtil.onLineUserIdList != null && RobotDbUtil.onLineUserIdList.contains(userId)) {
                    pcStatus = StatusEnum.DEV_ONLINE;
                    mobileStatus = StatusEnum.DEV_ONLINE;
                }
                boolean pcOnline = true;
                boolean mobileOnline = true;
                boolean pcAway = false;
                if (pcStatus == StatusEnum.DEV_OFFLINE) {
                    pcOnline = false;
                }
                if (mobileStatus == StatusEnum.DEV_OFFLINE) {
                    mobileOnline = false;
                }
                if (pcStatus == StatusEnum.DEV_AWAY) {
                    pcAway = true;
                }
                if (!pcOnline && !mobileOnline) {
                    offlineDev.add(userId);
                }
                if (pcOnline && mobileOnline) {
                    if (pcAway) {
                        StatusUtils.addDevList(userId, mobileStatus, "mobile", onlineDev, offlineDev);
                    } else {
                        allOnlineDev.add(userId);
                    }
                }
                if (!mobileOnline && pcOnline) {
                    if (pcAway) {
                        awayDev.add(userId);
                    } else {
                        StatusUtils.addDevList(userId, pcStatus, "pc", onlineDev, offlineDev);
                    }
                }
                if (!mobileOnline || pcOnline) continue;
                StatusUtils.addDevList(userId, mobileStatus, "mobile", onlineDev, offlineDev);
            }
            this.fillReply(ele, onlineDev, offlineDev, allOnlineDev, awayDev);
        }
        return reply;
    }

    private String getUidFromJID(JID jid) {
        if (jid == null) {
            return null;
        }
        String node = jid.getNode();
        if (StringUtils.isNumeric((CharSequence)(node = StatusUtils.conNodeToID(node)))) {
            return node;
        }
        return null;
    }

    private void fillReply(Element ele, Collection<String> onlineDev, Collection<String> offlineDev, Collection<String> allOnlineDev, Collection<String> awayDev) {
        if (ele == null || onlineDev == null) {
            return;
        }
        JSONArray array = new JSONArray();
        HashMap<String, Collection<String>> resultMap = new HashMap<String, Collection<String>>();
        if (!onlineDev.isEmpty()) {
            resultMap = new HashMap();
            resultMap.put("onlineUsers", onlineDev);
            array.add(resultMap);
        }
        if (!offlineDev.isEmpty()) {
            resultMap = new HashMap();
            resultMap.put("offlineUsers", offlineDev);
            array.add(resultMap);
        }
        if (!allOnlineDev.isEmpty()) {
            resultMap = new HashMap();
            resultMap.put("allOnlineUsers", allOnlineDev);
            array.add(resultMap);
        }
        if (!awayDev.isEmpty()) {
            resultMap = new HashMap();
            resultMap.put("away", awayDev);
            array.add(resultMap);
        }
        try {
            String content = array.toString();
            ele.addText(content);
            Log.debug("show status content:{}", (Object)content);
        }
        catch (Exception e) {
            Log.warn("fill status reply failed, make json str error, e:{}", (Object)e.getMessage());
        }
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

