/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.openfire.stats.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfmanCollector {
    private static Logger logger = LoggerFactory.getLogger(PerfmanCollector.class);
    private static long StartTime = System.currentTimeMillis();
    public static double curRate = 0.0;
    public static double maxRate = 0.0;
    private static long lastCollectTime = StartTime;
    private static long nowCollectTime = StartTime;
    private static final String IncomingStatKey = "server_bytes_in";
    private static final String OutgoingStatKey = "server_bytes_out";
    private static double avgNetBytes = 0.0;
    private static long avgCollectTime = 0L;
    private static volatile long statusQueryCaculater = 0L;
    private static volatile long statusSubscribeCaculater = 0L;
    private static volatile long statusRecvChangeCaculater = 0L;
    private static volatile long statusSendChangeCaculater = 0L;

    public static long getStatusQueryCaculater() {
        return statusQueryCaculater;
    }

    public static void incrStatusQueryCaculater() {
        if (++statusQueryCaculater < 0L) {
            statusQueryCaculater = 0L;
        }
        if (statusQueryCaculater % 100L == 0L) {
            logger.info("[perfman] status query caculate num:{}", (Object)statusQueryCaculater);
        }
    }

    public static long getStatusSubscribeCaculater() {
        return statusSubscribeCaculater;
    }

    public static void incrStatusSubscribeCaculater() {
        if (++statusSubscribeCaculater < 0L) {
            statusSubscribeCaculater = 0L;
        }
        if (statusSubscribeCaculater % 100L == 0L) {
            logger.info("[perfman] status subscribe caculate num:{}", (Object)statusSubscribeCaculater);
        }
    }

    public static long getStatusRecvChangeCaculater() {
        return statusRecvChangeCaculater;
    }

    public static void incrStatusRecvChangeCaculater() {
    }

    public static long getStatusSendChangeCaculater() {
        return statusSendChangeCaculater;
    }

    public static void incrStatusSendChangeCaculater() {
        if (++statusSendChangeCaculater < 0L) {
            statusSendChangeCaculater = 0L;
        }
        if (statusSendChangeCaculater % 100L == 0L) {
            logger.info("[perfman] status send change caculate num:{}", (Object)statusSendChangeCaculater);
        }
    }

    public static double getCpuLoadAverage() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        return osBean.getSystemLoadAverage();
    }

    public static double getCurNetLoadAverage() {
        return curRate;
    }

    public static double getAvgNetLoadAverage() {
        if (avgCollectTime == 0L) {
            return avgNetBytes * 1000.0 * 8.0;
        }
        double oneDayLoad = avgNetBytes * 1000.0 * 8.0 / (double)avgCollectTime;
        if (avgCollectTime > 86400000L) {
            avgCollectTime = 0L;
            avgNetBytes = 0.0;
        }
        return oneDayLoad;
    }

    public static double getMaxNetLoadAverage() {
        return maxRate;
    }

    private static double[] getTraffic() {
        double[] iobytes = new double[]{0.0, 0.0};
        Statistic incomingStat = StatisticsManager.getInstance().getStatistic(IncomingStatKey);
        Statistic outgoingStat = StatisticsManager.getInstance().getStatistic(OutgoingStatKey);
        if (incomingStat == null || outgoingStat == null) {
            logger.warn("no incoming or outgoing net stat");
            return iobytes;
        }
        iobytes[0] = incomingStat.sample();
        iobytes[1] = outgoingStat.sample();
        return iobytes;
    }

    public static void collectNetPerfman() {
        nowCollectTime = System.currentTimeMillis();
        if (nowCollectTime - lastCollectTime < 1000L) {
            return;
        }
        double[] iobytes = PerfmanCollector.getTraffic();
        logger.debug("incoming net:" + iobytes[0] + "kb, outgoing net:" + iobytes[1] + "kb, time diff:" + (nowCollectTime - lastCollectTime));
        curRate = (iobytes[0] + iobytes[1]) * 1000.0 * 8.0 / (double)(nowCollectTime - lastCollectTime);
        if (curRate > maxRate) {
            maxRate = curRate;
        }
        avgNetBytes += iobytes[0] + iobytes[1];
        avgCollectTime += nowCollectTime - lastCollectTime;
        lastCollectTime = nowCollectTime;
    }
}

