/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import com.weaver.util.msgpush.InterfacePropUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jivesoftware.admin.AuthCheckFilter;
import org.jivesoftware.openfire.IQRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.event.SessionEventDispatcher;
import org.jivesoftware.openfire.event.SessionEventListener;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.IQ.AllUserStatusIQHandler;
import org.jivesoftware.openfire.plugin.IQ.StatusIQHandler;
import org.jivesoftware.openfire.plugin.IQ.StatusWithOutSubIQHandler;
import org.jivesoftware.openfire.plugin.status.StatusNotifyQueueMgr;
import org.jivesoftware.openfire.plugin.status.StatusSubscribedNotifyTask;
import org.jivesoftware.openfire.plugin.util.OnlineSatusEnum;
import org.jivesoftware.openfire.plugin.util.StatusConfig;
import org.jivesoftware.openfire.plugin.util.StatusProp;
import org.jivesoftware.openfire.plugin.util.StatusUtils;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.user.PresenceEventDispatcher;
import org.jivesoftware.openfire.user.PresenceEventListener;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Presence;

public class StatusNotifyPlugin
implements Plugin,
PresenceEventListener,
PropertyEventListener,
SessionEventListener {
    private static final Logger Log = LoggerFactory.getLogger(StatusNotifyPlugin.class);
    private static final String TAG = "status ";
    private StatusNotifyQueueMgr redisRequestQueueMgr = null;
    private List<IQHandler> pluginRegisteredIqList = null;
    private StatusSubscribedNotifyTask statusSubscribedNotifyTask = null;
    public static boolean pcFirst = false;

    public void availableSession(ClientSession session, Presence presence) {
        if (session == null || session.isAnonymousUser()) {
            Log.debug("status session invalid");
            return;
        }
        if (!StatusUtils.isStatusOpen() || !StatusUtils.isStatusNotifyOpen()) {
            Log.debug("system closed the status notify interface.");
            return;
        }
        String resource = presence.getFrom().getResource();
        if ("mobile".equals(resource) || "pad".equals(resource)) {
            JID jid = presence.getFrom();
            this.saveMobileOnlineToRedis(jid);
        }
        boolean mobileOnline = false;
        boolean mobileNeedCheck = true;
        boolean pcOnline = false;
        boolean pcNeedCheck = true;
        if ("mobile".equals(resource) || "pad".equals(resource)) {
            mobileOnline = true;
            mobileNeedCheck = false;
        } else if ("pc".equals(resource)) {
            pcOnline = true;
            pcNeedCheck = false;
        }
        if (mobileNeedCheck) {
            JID mobileJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            mobileOnline = this.isDevOnline(mobileJID);
        }
        if (pcNeedCheck) {
            JID pcJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            pcOnline = this.isDevOnline(pcJID);
        }
        Log.debug("user status changed to:online, jid:{}, session presence:{}", (Object)presence.getFrom().toString(), (Object)session.getPresence().toString());
        boolean pcAway = false;
        if (pcOnline) {
            pcAway = this.isPcAway(new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true));
        }
        if (mobileOnline && pcOnline) {
            if (pcAway) {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.MOBILE_ONLINE.getDesc());
            } else {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.ALLDEV_ONLINE.getDesc());
            }
        } else if (mobileOnline && !pcOnline) {
            this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.MOBILE_ONLINE.getDesc());
        } else if (!mobileOnline && pcOnline) {
            if (pcAway) {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.AWAY.getDesc());
            } else {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.PC_ONLINE.getDesc());
            }
        } else if (!mobileOnline && !pcOnline) {
            this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.OFFLINE.getDesc());
        }
    }

    public void unavailableSession(ClientSession session, Presence presence) {
    }

    private boolean saveMobileOnlineToRedis(JID jid) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr == null) {
            return false;
        }
        try {
            long time = System.currentTimeMillis();
            String key = "mobile_presence_" + jid.toString();
            redisPoolMgr.set(key, String.valueOf(time), 172800);
            redisPoolMgr.zadd("msg:mobile:onlinequeue", System.currentTimeMillis(), key, 172800);
        }
        catch (Exception e) {
            Log.error("save Mobile Presence error.jid:{},error:{}", (Object)jid, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isOppositeDevOnline(JID jid) {
        JID oppositeJid = null;
        if (jid.getResource().equals("mobile")) {
            if (this.isDevOnline(jid)) {
                return true;
            }
            oppositeJid = new JID(jid.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            return this.isDevOnline(oppositeJid);
        }
        if (jid.getResource().equals("pc")) {
            oppositeJid = new JID(jid.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
        }
        return this.isDevOnline(oppositeJid);
    }

    private boolean isDevOnline(JID jid) {
        String resource = jid.getResource();
        if ("mobile".equals(resource)) {
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            if (redisPoolMgr == null) {
                return false;
            }
            try {
                String key = "mobile_presence_" + jid.toString();
                String value = redisPoolMgr.get(key);
                if (value != null && !value.isEmpty()) {
                    return true;
                }
                RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
                ClientSession client = routingTable.getClientRoute(jid);
                if (client == null || client.isAnonymousUser() || client.isClosed()) {
                    ClusterRedisUtil clusterRedisUtil;
                    String clusterNode;
                    ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
                    return clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty();
                }
                return true;
            }
            catch (Exception e) {
                Log.error("get Mobile Presence error.jid:{},e:{}", (Object)jid, (Object)e.getMessage());
                return false;
            }
        }
        RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
        ClientSession client = routingTable.getClientRoute(jid);
        if (client == null || client.isAnonymousUser() || client.isClosed()) {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            return clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty();
        }
        return true;
    }

    public void presenceChanged(ClientSession session, Presence presence) {
        String status;
        JID mobileJID;
        if (session == null || session.isAnonymousUser()) {
            Log.debug("status session invalid");
            return;
        }
        if (!StatusUtils.isStatusOpen() || !StatusUtils.isStatusNotifyOpen()) {
            Log.debug("system closed the status notify interface.");
            return;
        }
        String resource = presence.getFrom().getResource();
        boolean mobileOnline = false;
        boolean pcOnline = false;
        boolean mobileStatusHasCheck = false;
        if (Presence.Type.unavailable.equals((Object)presence.getType()) && ("mobile".equals(resource) || "pad".equals(resource)) && this.isDevOnline(mobileJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) {
            mobileOnline = true;
            mobileStatusHasCheck = true;
            return;
        }
        JID pcJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
        pcOnline = this.isDevOnline(pcJID);
        if (!mobileStatusHasCheck) {
            JID mobileJID2 = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            mobileOnline = this.isDevOnline(mobileJID2);
        }
        boolean pcAway = false;
        if (pcOnline && "pc".equals(presence.getFrom().getResource()) && "away".equals(status = presence.getStatus())) {
            pcAway = true;
        }
        if (mobileOnline && pcOnline) {
            if (pcAway) {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.MOBILE_ONLINE.getDesc());
            } else {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.ALLDEV_ONLINE.getDesc());
            }
        } else if (mobileOnline && !pcOnline) {
            this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.MOBILE_ONLINE.getDesc());
        } else if (!mobileOnline && pcOnline) {
            if (pcAway) {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.AWAY.getDesc());
            } else {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.PC_ONLINE.getDesc());
            }
        } else if (!mobileOnline && !pcOnline) {
            this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.OFFLINE.getDesc());
        }
    }

    public void subscribedToPresence(JID subscriberJID, JID authorizerJID) {
    }

    public void unsubscribedToPresence(JID unsubscriberJID, JID recipientJID) {
    }

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        Log.info("--status--initializePlugin--starting...");
        int threadNum = JiveGlobals.getIntProperty((String)StatusConfig.STATUS_THREAD_NUM_TAG, (int)StatusConfig.getRedisHandleThreadNum());
        int delay = JiveGlobals.getIntProperty((String)StatusConfig.STATUS_DELAY_TAG, (int)StatusConfig.getStatusDelaySecond());
        long speedLimit = JiveGlobals.getLongProperty((String)StatusConfig.STATUS_SPEED_LIMIT_TAG, (long)StatusConfig.getOutSpeedLimit());
        int redisRequestQueueCap = JiveGlobals.getIntProperty((String)StatusConfig.STATUS_QUEUE_CAPACITY_TAG, (int)StatusConfig.getRedisRequestQueueCap());
        StatusConfig.setRedisHandleThreadNum(threadNum);
        StatusConfig.setStatusDelaySecond(delay);
        StatusConfig.setOutSpeedLimit(speedLimit);
        StatusConfig.setRedisRequestQueueCap(redisRequestQueueCap);
        StatusNotifyQueueMgr.Instance();
        ExecutorService redisThreadPool = ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool();
        if (RedisPoolMgr.getInstance() != null) {
            StatusConfig.setUseRedisCache(true);
            StatusUtils.setStatusOpen(true);
        } else {
            Log.warn("status redis cache no open, or open redis failed. use local queue for status notification.");
            StatusConfig.setUseRedisCache(false);
        }
        this.redisRequestQueueMgr = StatusNotifyQueueMgr.Instance();
        this.pluginRegisteredIqList = new ArrayList<IQHandler>();
        this.statusSubscribedNotifyTask = new StatusSubscribedNotifyTask();
        redisThreadPool.execute(this.statusSubscribedNotifyTask);
        IQRouter iqRouter = XMPPServer.getInstance().getIQRouter();
        StatusIQHandler siqh = new StatusIQHandler(manager.getName((Plugin)this));
        iqRouter.addHandler((IQHandler)siqh);
        StatusWithOutSubIQHandler status = new StatusWithOutSubIQHandler();
        iqRouter.addHandler((IQHandler)status);
        AllUserStatusIQHandler statusall = new AllUserStatusIQHandler();
        iqRouter.addHandler((IQHandler)statusall);
        this.pluginRegisteredIqList.add(siqh);
        this.pluginRegisteredIqList.add(status);
        this.pluginRegisteredIqList.add(statusall);
        PresenceEventDispatcher.addListener((PresenceEventListener)this);
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        SessionEventDispatcher.addListener((SessionEventListener)this);
        StatusConfig.setShutDown(false);
        AuthCheckFilter.addExclude((String)"status/httpservice/api/status");
        pcFirst = StatusProp.isPcFirst();
        InterfacePropUtil.getUserList();
        Log.info("status start status notify plugin. redis worker thread num:{}, subscribe on channel:{}, delay:{}, speed limit:{}, redis queue cap:{}", new Object[]{threadNum, StatusConfig.getStatusChangeChannel(), delay, speedLimit, redisRequestQueueCap});
    }

    public void destroyPlugin() {
        Log.info("status destroy status plugin, shut down redis worker thread.");
        StatusConfig.setShutDown(true);
        if (this.statusSubscribedNotifyTask != null) {
            Log.info("shutdown status subscribe notify thread ...");
            this.statusSubscribedNotifyTask.setShutDown(true);
        }
        PresenceEventDispatcher.removeListener((PresenceEventListener)this);
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
        SessionEventDispatcher.removeListener((SessionEventListener)this);
        this.removeHandler();
    }

    private void removeHandler() {
        IQRouter iqRouter = XMPPServer.getInstance().getIQRouter();
        if (this.pluginRegisteredIqList != null && !this.pluginRegisteredIqList.isEmpty()) {
            for (IQHandler handler : this.pluginRegisteredIqList) {
                iqRouter.removeHandler(handler);
            }
            this.pluginRegisteredIqList.clear();
        }
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (property == null || params == null || property.isEmpty() || params.isEmpty()) {
            return;
        }
        if (StatusConfig.STATUS_DELAY_TAG.equals(property)) {
            int delay = Integer.parseInt((String)params.get("value"));
            if (delay == 0) {
                delay = 1;
                Log.warn("can not set delay to 0, force set it to 1");
            }
            StatusConfig.setStatusDelaySecond(delay);
            Log.info("status plugin, property set, key:{}, params:{}", (Object)property, (Object)params.toString());
        }
        if (StatusConfig.STATUS_SPEED_LIMIT_TAG.equals(property)) {
            long speedLimit = Long.parseLong((String)params.get("value"));
            StatusConfig.setOutSpeedLimit(speedLimit);
            Log.info("status plugin, property set, key:{}, params:{}", (Object)property, (Object)params.toString());
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    public void sessionCreated(Session session) {
    }

    public void sessionDestroyed(Session session) {
        JID mobileJID;
        if (!(session instanceof ClientSession)) {
            return;
        }
        ClientSession clientSession = (ClientSession)session;
        if (clientSession == null || clientSession.isAnonymousUser()) {
            Log.debug("status session invalid");
            return;
        }
        Log.debug("status, session destroyed, presence:{}, jid:{}, session:{}", new Object[]{clientSession.getPresence().toXML(), clientSession.getAddress().toString(), clientSession.toString()});
        JID jid = clientSession.getAddress();
        if (clientSession.getPresence() == null || clientSession.getPresence().getFrom() == null) {
            Log.debug("session destroy, presence is invalid, jid:{}", (Object)jid.toString());
            return;
        }
        ClusterPropBeanUtil clusterBeanPropUtil = ClusterPropBeanUtil.getInstance();
        if (clusterBeanPropUtil.isUseCluster()) {
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            clusterRedisUtil.delUserSessionFromRedis(jid, clusterBeanPropUtil.getClusterName());
        }
        if (!StatusUtils.isStatusOpen() || !StatusUtils.isStatusNotifyOpen()) {
            Log.debug("system closed the status notify interface.");
            return;
        }
        Presence presence = clientSession.getPresence();
        presence.setType(Presence.Type.unavailable);
        presence.setStatus("offline");
        presence.setFrom(jid);
        String resource = presence.getFrom().getResource();
        boolean mobileOnline = false;
        boolean pcOnline = false;
        boolean mobileStatusHasCheck = false;
        if (("mobile".equals(resource) || "pad".equals(resource)) && this.isDevOnline(mobileJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) {
            mobileOnline = true;
            mobileStatusHasCheck = true;
            return;
        }
        JID pcJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
        pcOnline = this.isDevOnline(pcJID);
        if (!mobileStatusHasCheck) {
            JID mobileJID2 = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            mobileOnline = this.isDevOnline(mobileJID2);
        }
        boolean pcAway = false;
        if (pcOnline) {
            pcAway = this.isPcAway(pcJID);
        }
        if (mobileOnline && pcOnline) {
            if (pcAway) {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.MOBILE_ONLINE.getDesc());
            } else {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.ALLDEV_ONLINE.getDesc());
            }
        } else if (mobileOnline && !pcOnline) {
            this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.MOBILE_ONLINE.getDesc());
        } else if (!mobileOnline && pcOnline) {
            if (pcAway) {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.AWAY.getDesc());
            } else {
                this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.PC_ONLINE.getDesc());
            }
        } else if (!mobileOnline && !pcOnline) {
            this.redisRequestQueueMgr.Push(presence.getFrom().getNode(), OnlineSatusEnum.OFFLINE.getDesc());
        }
    }

    private boolean isPcAway(JID jid) {
        RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
        ClientSession client = routingTable.getClientRoute(jid);
        if (client == null || client.isAnonymousUser() || client.isClosed()) {
            return false;
        }
        String status = client.getPresence().getStatus();
        return OnlineSatusEnum.AWAY.getDesc().equalsIgnoreCase(status);
    }

    public void anonymousSessionCreated(Session session) {
    }

    public void anonymousSessionDestroyed(Session session) {
    }

    public void resourceBound(Session session) {
    }
}

