/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.openfire.plugin.StatusNotifyPlugin;
import org.jivesoftware.openfire.plugin.util.StatusEnum;
import org.jivesoftware.openfire.plugin.util.StatusUtils;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(StatusServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            String weaversecret = JiveGlobals.getProperty((String)"serverSecret");
            String udid = StringUtils.defaultString((String)request.getHeader("udid"), (String)"");
            String timestamp = request.getHeader("timestamp");
            String sign = request.getHeader("sign");
            StringBuilder toSign = new StringBuilder(weaversecret).append(udid).append(timestamp);
            String signtemp = this.hexSHA1(toSign.toString());
            String method = request.getParameter("method");
            if (!signtemp.equals(sign)) {
                data.put("error", "authentic error");
            } else {
                HashMap<String, Serializable> result = new HashMap<String, Serializable>();
                if ("getUserStatus".equals(method)) {
                    String[] userIdsArr = null;
                    String userids = request.getParameter("userIds");
                    if (userids == null || userids.isEmpty()) {
                        Log.warn("getUserStatus userIds is null .");
                    }
                    if (userids != null && userids.contains(",") && userids.startsWith("[") && userids.endsWith("]")) {
                        userids = userids.substring(1, userids.length() - 1);
                        userIdsArr = userids.split(",");
                    } else {
                        userIdsArr = new String[]{userids};
                    }
                    HashSet<String> pcOnlineDev = new HashSet<String>();
                    HashSet<String> mobileOnlineDev = new HashSet<String>();
                    for (String userId : userIdsArr) {
                        if (userId != null) {
                            userId = userId.trim();
                        }
                        StatusEnum pcStatus = StatusUtils.getStatus(userId, "pc");
                        StatusEnum mobileStatus = StatusUtils.getStatus(userId, "mobile");
                        if (StatusNotifyPlugin.pcFirst) {
                            if (pcStatus != StatusEnum.DEV_OFFLINE) {
                                pcOnlineDev.add(userId);
                                continue;
                            }
                            if (mobileStatus == StatusEnum.DEV_OFFLINE) continue;
                            mobileOnlineDev.add(userId);
                            continue;
                        }
                        if (mobileStatus != StatusEnum.DEV_OFFLINE) {
                            mobileOnlineDev.add(userId);
                            continue;
                        }
                        if (pcStatus == StatusEnum.DEV_OFFLINE) continue;
                        pcOnlineDev.add(userId);
                    }
                    result.put("pcOnlineUsers", pcOnlineDev);
                    result.put("mobileOnlineUsers", mobileOnlineDev);
                } else if ("getAllOnlineUsers".equals(method)) {
                    HashSet onlineUsers = new HashSet();
                    result.put("onlineUsers", onlineUsers);
                } else {
                    result.put("status", Integer.valueOf(0));
                    response.sendError(404, "method not found.");
                }
                String str = JSON.toJSONString(result).toString();
                response.getOutputStream().write(str.getBytes("UTF-8"));
                response.setContentType("text/json; charset=UTF-8");
            }
        }
        catch (Exception e) {
            Log.error("doGet,request={},error={}", (Object)JSON.toJSONString((Object)request.getParameterMap()).toString(), (Object)e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public String hexSHA1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(value.getBytes("utf-8"));
            byte[] digest = md.digest();
            return this.byteToHexString(digest);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String byteToHexString(byte[] bytes) {
        return String.valueOf(Hex.encodeHex((byte[])bytes));
    }

    public void destroy() {
        super.destroy();
    }
}

