/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.status;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.openfire.plugin.util.StatusConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusNotifyQueueMgr {
    private static final Logger Log = LoggerFactory.getLogger(StatusNotifyQueueMgr.class);
    private Map<String, String> waitStatusChangeQueue = new HashMap<String, String>();
    private Map<String, String> sendStatusChangeQueue = new HashMap<String, String>();
    private static StatusNotifyQueueMgr inst = null;

    public static synchronized StatusNotifyQueueMgr Instance() {
        if (null == inst) {
            inst = new StatusNotifyQueueMgr();
            Log.info("init status modify queue manager, queue cap:{}", (Object)StatusConfig.getRedisRequestQueueCap());
        }
        return inst;
    }

    private StatusNotifyQueueMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Push(String key, String value) {
        Map<String, String> map = this.waitStatusChangeQueue;
        synchronized (map) {
            this.waitStatusChangeQueue.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> GetStatusNotifications() {
        Map<String, String> map = this.waitStatusChangeQueue;
        synchronized (map) {
            try {
                this.waitStatusChangeQueue.wait(StatusConfig.getStatusDelaySecond() * 1000);
            }
            catch (InterruptedException e) {
                Log.warn("GetStatusNotifications InterruptedException");
            }
            if (!this.sendStatusChangeQueue.isEmpty()) {
                Log.warn("the send queue is not empty, clear it before drainTo send queue, but maybe lost status notice, left size:{}", (Object)this.sendStatusChangeQueue.size());
                this.sendStatusChangeQueue.clear();
            }
            this.sendStatusChangeQueue.putAll(this.waitStatusChangeQueue);
            this.waitStatusChangeQueue.clear();
        }
        return this.sendStatusChangeQueue;
    }
}

