/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.status;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.util.WStringUtils;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.dom4j.Element;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.PerfmanCollector;
import org.jivesoftware.openfire.plugin.status.StatusNotifyQueueMgr;
import org.jivesoftware.openfire.plugin.util.StatusConfig;
import org.jivesoftware.openfire.plugin.util.StatusEnum;
import org.jivesoftware.openfire.plugin.util.StatusSuscribeUtil;
import org.jivesoftware.openfire.plugin.util.StatusUtils;
import org.jivesoftware.openfire.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class StatusSubscribedNotifyTask
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(StatusSubscribedNotifyTask.class);
    private SessionManager sessionManager = null;
    private String uuid = null;
    private RoutingTable routingTable = null;
    private Map<String, Collection<String>> statusMap = new HashMap<String, Collection<String>>();
    private List<String> onLineUsers = new ArrayList<String>();
    private List<String> offlineUsers = new ArrayList<String>();
    private static int maxNotifyUserNum = 500;
    private static int sendCnt = 0;
    private volatile boolean isShutDown = false;
    private volatile boolean isMobileStatusNotifyOpen = false;
    private volatile boolean isPcStatusNotifyOpen = false;
    private Map<String, Presence> filteredPresenceList = new HashMap<String, Presence>();

    public StatusSubscribedNotifyTask() {
        this.uuid = StatusUtils.getUDID();
        maxNotifyUserNum = StatusUtils.getStatusSubscribeMaxNum();
        this.isShutDown = false;
        Log.info("init status subscribe notify task, max subscribe num is {}", (Object)maxNotifyUserNum);
    }

    private String makeStatusElement(List<String> onLineUsers, List<String> offlineUsers) {
        JSONArray array = new JSONArray();
        String content = "{}";
        if (onLineUsers != null && !onLineUsers.isEmpty()) {
            this.statusMap.clear();
            this.statusMap.put("onlineUsers", onLineUsers);
            array.add(this.statusMap);
        }
        if (offlineUsers != null && !offlineUsers.isEmpty()) {
            this.statusMap.clear();
            this.statusMap.put("offlineUsers", offlineUsers);
            array.add(this.statusMap);
        }
        try {
            content = array.toString();
            Log.debug("make status, show status content:{}", (Object)content);
            onLineUsers.clear();
            offlineUsers.clear();
        }
        catch (Exception e) {
            Log.warn("make status reply failed, make json str error, e:{}", (Object)e.getMessage());
        }
        return content;
    }

    private int filterAndFormatPresence(BlockingQueue<Presence> queue) {
        if (null == queue || queue.isEmpty()) {
            return 0;
        }
        for (Presence presence : queue) {
            String fromNode = presence.getFrom().getNode();
            String fromUid = StatusUtils.conNodeToID(fromNode);
            if (fromUid == null || fromUid.isEmpty()) {
                Log.warn("status change, from uid is empty! discard it, username:{}", (Object)fromNode);
                continue;
            }
            this.filteredPresenceList.put(fromUid, presence);
        }
        for (Map.Entry entry : this.filteredPresenceList.entrySet()) {
            Presence presence = (Presence)entry.getValue();
            String uid = (String)entry.getKey();
            StatusEnum devStatus = StatusUtils.getStatusFromPresence(presence);
            String devSource = ((Presence)entry.getValue()).getFrom().getResource();
            StatusUtils.addDevList(uid, devStatus, devSource, this.onLineUsers, this.offlineUsers);
            String statusElementStr = this.makeStatusElement(this.onLineUsers, this.offlineUsers);
            presence.getElement().remove(presence.getChildElement("status", ""));
            Element statusElement = presence.addChildElement("status", "http://weaver.com.cn/status_notify");
            statusElement.addText(statusElementStr);
        }
        return 0;
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    public void setShutDown(boolean isShutDown) {
        this.isShutDown = isShutDown;
    }

    @Override
    public void run() {
        long printIndex = 0L;
        long printInterval = 6000L;
        Log.info("StatusSubscribedNotifyTask start status notify task.");
        this.sessionManager = SessionManager.getInstance();
        this.routingTable = XMPPServer.getInstance().getRoutingTable();
        while (!this.isShutDown) {
            this.isMobileStatusNotifyOpen = StatusUtils.isMobileStatusNotifyOpen();
            this.isPcStatusNotifyOpen = StatusUtils.isPcStatusNotifyOpen();
            Log.debug("StatusSubscribedNotifyTask running.");
            try {
                Map<String, String> queue = StatusNotifyQueueMgr.Instance().GetStatusNotifications();
                if (queue == null || queue.isEmpty()) {
                    if (printIndex < 0L) {
                        printIndex = 0L;
                    }
                    if (++printIndex % printInterval == 0L) {
                        Log.debug("StatusSubscribedNotifyTask no status change, status notify thread is alive.");
                    }
                    Thread.sleep(10000L);
                    continue;
                }
                this.filteredPresenceList.clear();
                this.SendTaskIntervalLocal(queue);
                queue.clear();
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                Log.error("StatusSubscribedNotifyTask notify thread exception:{}", (Object)e.getMessage());
            }
        }
        Log.warn("StatusSubscribedNotifyTask end status send. exit...");
    }

    private void SendTaskIntervalLocal(Map<String, String> queue) {
        maxNotifyUserNum = StatusUtils.getStatusSubscribeMaxNum();
        for (String username : queue.keySet()) {
            String status = queue.get(username);
            String uid = StatusSubscribedNotifyTask.getUserIdByUsername(username);
            Set<String> notifyUidList = StatusSuscribeUtil.getSubscribeStatusList(uid, maxNotifyUserNum);
            if (notifyUidList == null || notifyUidList.isEmpty()) {
                Log.debug("no user subscribe this uid:{}, no notify status change.", (Object)uid);
                continue;
            }
            this.notifyUserByUid(notifyUidList, this.makePresence(username, status, uid));
        }
    }

    private Presence makePresence(String username, String status, String userId) {
        Presence presence = new Presence();
        JID fromJID = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
        presence.setFrom(fromJID);
        presence.setID(StatusSubscribedNotifyTask.getRandomLowercase(12));
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(userId, status);
        list.add(map);
        String statusElementStr = JSON.toJSONString(list).toString();
        presence.getElement().remove(presence.getChildElement("status", ""));
        Element statusElement = presence.addChildElement("status", "http://weaver.com.cn/status_notify");
        statusElement.addText(statusElementStr);
        return presence;
    }

    public static String getRandomLowercase(int length) {
        StringBuffer udid = new StringBuffer();
        String model = "0123456789abcdefghijklmnopqrstuvwxyz";
        char[] m = model.toCharArray();
        for (int j = 0; j < length; ++j) {
            char c = m[(int)(Math.random() * 36.0)];
            udid = udid.append(c);
        }
        return udid.toString();
    }

    private static String getUserIdByUsername(String node) {
        if (node.startsWith("push|")) {
            return "-1";
        }
        int i = node.indexOf("|");
        if (i > 0) {
            return node.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return node;
    }

    private int notifyUserByUid(Set<String> notifyUidList, Presence presence) {
        int waitCnt = 0;
        block2: for (String uid : notifyUidList) {
            String node = this.makeNodeFromUid(uid);
            Collection sessions = this.sessionManager.getSessions(node);
            if (sessions.isEmpty()) {
                Log.debug("target no client online, no notify status, target username:{}.", (Object)node);
                JID mobileJid = new JID(node, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                JID pcJid = new JID(node, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
                ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
                if (!clusterPropBeanUtil.isUseCluster()) continue;
                ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
                String mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJid);
                String pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJid);
                if (mobileClusterNode != null && !mobileClusterNode.isEmpty()) {
                    presence.setID(StatusUtils.GenerateUUID());
                    presence.setTo(mobileJid);
                    clusterRedisUtil.saveToRedis(mobileClusterNode, presence);
                    if (mobileClusterNode.equals(pcClusterNode) || pcClusterNode == null || pcClusterNode.isEmpty()) continue;
                    presence.setID(StatusUtils.GenerateUUID());
                    presence.setTo(pcJid);
                    clusterRedisUtil.saveToRedis(pcClusterNode, presence);
                    continue;
                }
                if (pcClusterNode == null || pcClusterNode.isEmpty()) continue;
                presence.setID(StatusUtils.GenerateUUID());
                presence.setTo(pcJid);
                clusterRedisUtil.saveToRedis(pcClusterNode, presence);
                continue;
            }
            for (ClientSession devClient : sessions) {
                this.NotifyBySession(devClient, presence);
            }
            if (++sendCnt == -1) {
                sendCnt = 0;
            }
            while (!StatusConfig.getShutDown() && sendCnt % StatusConfig.getSendSessionCntOnce() == 0 && this.checkNeedWait()) {
                try {
                    if (++waitCnt * StatusConfig.getStatusSendIntervalMilliSecond() > 600000) {
                        Log.warn("wait for 10 minute, discard all status change, already send cnt:{}.", (Object)sendCnt);
                        return 0;
                    }
                    Log.debug("net load too big, status wait for {}ms, already send cnt:{}.", (Object)StatusConfig.getStatusSendIntervalMilliSecond(), (Object)sendCnt);
                    Thread.sleep(StatusConfig.getStatusSendIntervalMilliSecond());
                }
                catch (InterruptedException e) {
                    Log.error("thread sleep interrupted");
                    continue block2;
                }
            }
        }
        return 0;
    }

    private String makeNodeFromUid(String uid) {
        return uid + "|" + this.uuid;
    }

    private boolean checkNeedWait() {
        double netLoadOneDay;
        PerfmanCollector.collectNetPerfman();
        if (!StatusUtils.isStatusOverloadOpen()) {
            return false;
        }
        double cpuload = PerfmanCollector.getCpuLoadAverage();
        if (cpuload > (double)StatusUtils.getStatusMaxCpuLoadLimit()) {
            Log.warn("cpu load:{} too big, need wait...", (Object)cpuload);
            return true;
        }
        double netload = PerfmanCollector.getCurNetLoadAverage();
        if (netload > 1.1 * (netLoadOneDay = PerfmanCollector.getAvgNetLoadAverage())) {
            Log.warn("net load:{} bigger than max net load: 1.1*{}, need wait...", (Object)netload, (Object)netLoadOneDay);
            return true;
        }
        return false;
    }

    private int NotifyBySession(ClientSession client, Presence presence) {
        if (null == client || client.isClosed() || client.isAnonymousUser()) {
            Log.debug("no notify client, session is invalid.");
            return 1;
        }
        JID from = presence.getFrom();
        if (null == from || from.getNode().equals(client.getAddress().getNode())) {
            Log.debug("from jid is null or skip notify self.");
            return 0;
        }
        if (!this.isMobileStatusNotifyOpen && "mobile".equals(client.getAddress().getResource())) {
            Log.debug("no notify mobile status change, from:{}, to:{}, status:{}", new Object[]{from.getNode(), client.getAddress().getNode(), presence.getStatus()});
            return 0;
        }
        if (!this.isPcStatusNotifyOpen && "pc".equals(client.getAddress().getResource())) {
            Log.debug("no notify pc status change, from:{}, to:{}, status:{}", new Object[]{from.getNode(), client.getAddress().getNode(), presence.getStatus()});
            return 0;
        }
        if (!this.routingTable.isLocalRoute(client.getAddress())) {
            Log.debug("no notify remote jid:{}", (Object)client.getAddress().toString());
            return 0;
        }
        presence.setTo(client.getAddress());
        String id = presence.getID();
        if (WStringUtils.isEmpty((String)id) || "null".equals(id)) {
            presence.setID(StatusUtils.GenerateUUID());
        }
        client.process((Packet)presence);
        PerfmanCollector.incrStatusSendChangeCaculater();
        return 0;
    }
}

