/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusConfig {
    private static final Logger Log = LoggerFactory.getLogger(StatusConfig.class);
    private static int StatusDelaySecond = 2;
    private static int StatusSendIntervalMilliSecond = 100;
    private static int SendSessionCntOnce = 10;
    private static long OutPutSpeedLimit = 1000L;
    private static int RedisHandleThreadNum = 1;
    private static int RedisRequestQueueCap = Integer.MAX_VALUE;
    private static long RedisTimeOut = 2L;
    private static int NotifyLimit = 10;
    private static int StatusExpire = 43200;
    private static volatile boolean isShutDown = false;
    private static String StatusChangeChannel = "StatusChangeChannel";
    private static boolean IsUseRedisCache = false;
    private static String RedisCacheHost = "127.0.0.1";
    private static int RedisCachePort = 6379;
    private static int RedisPoolMaxCon = 500;
    private static int RedisPoolMaxIdle = 5;
    private static int RedisPoolMaxWait = 100;
    private static boolean RedisPoolBorrowTest = false;
    public static int ERROR_NO_OPEN_CACHE = 120;
    public static int ERROR_FILE_NOT_EXIST = 127;
    private static String CACHE_CONFIG_FILENAME = "conf" + File.separator + "cache.properties";
    private static String CACHE_OPEN_TAG = "cache.redis.open";
    private static String CACHE_HOST = "cache.redis.host";
    private static String CACHE_PORT = "cache.redis.port";
    private static String CACHE_MAX_CON = "cache.redis.maxcon";
    private static String CACHE_MAX_IDLE = "cache.redis.maxidle";
    private static String CACHE_MAX_WAIT = "cache.redis.maxwait";
    private static String CACHE_TEST = "cache.redis.test";
    private static String BOOLEAN_DEFAULT_VALUE = "false";
    public static String STATUS_THREAD_NUM_TAG = "status.redis.thread.num";
    public static String STATUS_DELAY_TAG = "status.notify.delay.second";
    public static String STATUS_SPEED_LIMIT_TAG = "status.notify.speed.limit";
    public static String STATUS_QUEUE_CAPACITY_TAG = "status.queue.capacity";
    public static String STATUS_TIMEOUT_TAG = "status.redis.timeout.second";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadRedisConfig() {
        int ret = 0;
        Properties properties = new Properties();
        String home = JiveGlobals.getHomeDirectory();
        InputStream is = null;
        String configPath = null;
        try {
            configPath = home + File.separator + CACHE_CONFIG_FILENAME;
            System.out.println("status notify plugin, load redis config: " + configPath);
            File configFile = new File(configPath);
            if (!configFile.exists()) {
                System.err.println("status notify plugin, redis config not exist, if no use redis as cache, ignore this. file: " + configPath);
                int n = ERROR_FILE_NOT_EXIST;
                return n;
            }
            is = new FileInputStream(configFile);
            properties.load(is);
            if (!Boolean.valueOf(properties.getProperty(CACHE_OPEN_TAG, BOOLEAN_DEFAULT_VALUE)).booleanValue()) {
                System.out.println("no open cache for status notify");
                int n = ERROR_NO_OPEN_CACHE;
                return n;
            }
            RedisCacheHost = properties.getProperty(CACHE_HOST, RedisCacheHost);
            RedisCachePort = Integer.valueOf(properties.getProperty(CACHE_PORT, "6379"));
            RedisPoolMaxCon = Integer.valueOf(properties.getProperty(CACHE_MAX_CON, "500"));
            RedisPoolMaxIdle = Integer.valueOf(properties.getProperty(CACHE_MAX_IDLE, "5"));
            RedisPoolMaxWait = Integer.valueOf(properties.getProperty(CACHE_MAX_WAIT, "100"));
            RedisPoolBorrowTest = Boolean.valueOf(properties.getProperty(CACHE_TEST, BOOLEAN_DEFAULT_VALUE));
            System.out.println("load redis cache config for status notify, addr:" + RedisCacheHost + ":" + RedisCachePort + ", max con:" + RedisPoolMaxCon + ", max idle:" + RedisPoolMaxIdle + ", max wait:" + RedisPoolMaxWait);
            Log.info("load redis cache config for status notify, addr:" + RedisCacheHost + ":" + RedisCachePort + ", max con:" + RedisPoolMaxCon + ", max idle:" + RedisPoolMaxIdle + ", max wait:" + RedisPoolMaxWait);
        }
        catch (IOException e) {
            System.err.println("status notify plugin, load redis config failed, if no use redis as cache, ignore this. err: " + e.getMessage());
            Log.error("status notify plugin, load redis config failed, if no use redis as cache, ignore this. err: " + e.getMessage());
            ret = ERROR_NO_OPEN_CACHE;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    Log.error("loadRedisConfig,error : {}", (Object)e1.getMessage());
                }
            }
        }
        return ret;
    }

    public static int getStatusDelaySecond() {
        return StatusDelaySecond;
    }

    public static void setStatusDelaySecond(int statusDelaySecond) {
        StatusDelaySecond = statusDelaySecond;
    }

    public static int getRedisHandleThreadNum() {
        return RedisHandleThreadNum;
    }

    public static void setRedisHandleThreadNum(int redisHandleThreadNum) {
        RedisHandleThreadNum = redisHandleThreadNum;
    }

    public static int getRedisRequestQueueCap() {
        return RedisRequestQueueCap;
    }

    public static void setRedisRequestQueueCap(int redisRequestQueueCap) {
        RedisRequestQueueCap = redisRequestQueueCap;
    }

    public static void setShutDown(boolean b) {
        isShutDown = b;
    }

    public static boolean getShutDown() {
        return isShutDown;
    }

    public static String getStatusChangeChannel() {
        return StatusChangeChannel;
    }

    public static void setStatusChangeChannel(String statusChangeChannel) {
        StatusChangeChannel = statusChangeChannel;
    }

    public static boolean isUseRedisCache() {
        return IsUseRedisCache;
    }

    public static void setUseRedisCache(boolean isUseRedisCache) {
        IsUseRedisCache = isUseRedisCache;
    }

    public static String getCacheHost() {
        return RedisCacheHost;
    }

    public static void setCacheHost(String cacheHost) {
        RedisCacheHost = cacheHost;
    }

    public static int getCachePort() {
        return RedisCachePort;
    }

    public static void setCachePort(int cachePort) {
        RedisCachePort = cachePort;
    }

    public static int getStatusExpire() {
        return StatusExpire;
    }

    public static void setStatusExpire(int statusExpire) {
        StatusExpire = statusExpire;
    }

    public static int getStatusSendIntervalMilliSecond() {
        return StatusSendIntervalMilliSecond;
    }

    public static void setStatusSendIntervalMilliSecond(int statusSendIntervalMilliSecond) {
        StatusSendIntervalMilliSecond = statusSendIntervalMilliSecond;
    }

    public static int getSendSessionCntOnce() {
        if (0 == SendSessionCntOnce) {
            return 1;
        }
        return SendSessionCntOnce;
    }

    public static void setSendSessionCntOnce(int sendSessionCntOnce) {
        SendSessionCntOnce = sendSessionCntOnce;
    }

    public static long getOutSpeedLimit() {
        if (0L == OutPutSpeedLimit) {
            return 1000L;
        }
        return OutPutSpeedLimit;
    }

    public static void setOutSpeedLimit(long limit) {
        if (0L != limit) {
            OutPutSpeedLimit = limit;
        }
    }

    public static long getRedisTimeOut() {
        return RedisTimeOut;
    }

    public static void setRedisTimeOut(long timeout) {
        if (0L != timeout) {
            RedisTimeOut = timeout;
        }
    }

    public static int getNotifyLimit() {
        return NotifyLimit;
    }

    public static void setNotifyLimit(int notifyLimit) {
        NotifyLimit = notifyLimit;
    }

    public static int getRedisPoolMaxCon() {
        return RedisPoolMaxCon;
    }

    public static void setRedisPoolMaxCon(int redisPoolMaxCon) {
        RedisPoolMaxCon = redisPoolMaxCon;
    }

    public static int getRedisPoolMaxIdle() {
        return RedisPoolMaxIdle;
    }

    public static void setRedisPoolMaxIdle(int redisPoolMaxIdle) {
        RedisPoolMaxIdle = redisPoolMaxIdle;
    }

    public static int getRedisPoolMaxWait() {
        return RedisPoolMaxWait;
    }

    public static void setRedisPoolMaxWait(int redisPoolMaxWait) {
        RedisPoolMaxWait = redisPoolMaxWait;
    }

    public static boolean isRedisPoolBorrowTest() {
        return RedisPoolBorrowTest;
    }

    public static void setRedisPoolBorrowTest(boolean redisPoolBorrowTest) {
        RedisPoolBorrowTest = redisPoolBorrowTest;
    }
}

