/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.WStringUtils;
import com.weaver.util.threadpool.FixedThreadPoolImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.openfire.plugin.PerfmanCollector;
import org.jivesoftware.openfire.plugin.util.StatusConfig;
import org.jivesoftware.openfire.plugin.util.StatusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusSuscribeUtil {
    private static final Logger Log = LoggerFactory.getLogger(StatusSuscribeUtil.class);
    private static final String SubscribeKeyFormat = "substatus_%s";
    private static final String Max32BitUnixTimeStamp = "2147483647";

    public static int asyncSubscribeStatus(String fUid, Collection<String> subsUidList, int expireSecond) {
        if (WStringUtils.isEmpty((String)fUid)) {
            Log.error("from uid is empty, no subscribe status");
            return 1;
        }
        long futureSecond = System.currentTimeMillis() / 1000L;
        futureSecond += (long)expireSecond;
        BatchStatusSubscriberMgr batchStatusSubscriberMgr = BatchStatusSubscriberMgr.getInstance();
        for (String target : subsUidList) {
            batchStatusSubscriberMgr.addTask(new StatusSubscribeTask(fUid, target, futureSecond));
        }
        return 0;
    }

    private static int subscribeStatus(String fUid, String subsUid, long expireTimeStamp) {
        if (fUid.equals(subsUid)) {
            Log.debug("skip subscribe self status, uid:{}", (Object)fUid);
            return 0;
        }
        String key = StatusSuscribeUtil.makeSubscribeKey(subsUid);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr == null) {
            Log.error("redis pool not inited.");
            return 0;
        }
        Double oldExpireTimeStamp = redisPoolMgr.zscore(key, fUid);
        if (oldExpireTimeStamp != null && expireTimeStamp <= (long)oldExpireTimeStamp.intValue()) {
            Log.debug("no need subscribe, already sibscribed, fuid:{}, peer:{}, expire at:{}", new Object[]{fUid, subsUid, oldExpireTimeStamp.intValue()});
            return 0;
        }
        if (oldExpireTimeStamp != null && expireTimeStamp - (long)oldExpireTimeStamp.intValue() < (long)(StatusUtils.getStatusPcExpire() / 2)) {
            Log.debug("no need subscribe, no expired, fuid:{}, peer:{}, expire at:{}", new Object[]{fUid, subsUid, oldExpireTimeStamp.intValue()});
            return 0;
        }
        PerfmanCollector.incrStatusSubscribeCaculater();
        Log.debug("status {} subscribe {}, expire at:{}s", new Object[]{fUid, subsUid, expireTimeStamp});
        return redisPoolMgr.zadd(key, expireTimeStamp, fUid, 2592000);
    }

    public static Set<String> getSubscribeStatusList(String fUid, int limitCount) {
        long currSecond = System.currentTimeMillis() / 1000L;
        String key = StatusSuscribeUtil.makeSubscribeKey(fUid);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr == null) {
            Log.error("redis pool not inited.");
            return Collections.emptySet();
        }
        return redisPoolMgr.zrangeByScore(key, String.valueOf(currSecond), Max32BitUnixTimeStamp, limitCount);
    }

    private static String makeSubscribeKey(String subsUid) {
        return String.format(SubscribeKeyFormat, subsUid);
    }

    static class BatchStatusSubscriber
    implements Runnable {
        private BlockingQueue<StatusSubscribeTask> waitTaskQueue = new LinkedBlockingQueue<StatusSubscribeTask>(this.taskQueueCap);
        private int taskQueueCap = 10000;

        public boolean addTask(StatusSubscribeTask task) {
            return this.waitTaskQueue.offer(task);
        }

        @Override
        public void run() {
            int printInterval = 0;
            Log.info("start status subscriber task, queue capacity:{}", (Object)this.waitTaskQueue.remainingCapacity());
            StatusSubscribeTask task = null;
            while (!StatusConfig.getShutDown()) {
                try {
                    task = this.waitTaskQueue.poll(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    Log.warn("subscribe task queue interrupted, continue ...");
                    continue;
                }
                if (null == task) {
                    if (++printInterval % 100 != 0) continue;
                    Log.debug("task is null, continue ...");
                    continue;
                }
                try {
                    if (0 != StatusSuscribeUtil.subscribeStatus(task.getFromUid(), task.getSubscribeUid(), task.getExpireSecond())) {
                        Log.warn("subscribe status failed, from:{}, subscribe target:{}", (Object)task.getFromUid(), (Object)task.getSubscribeUid());
                        continue;
                    }
                    Log.debug("subscribe status ok, from:{}, subscribe target:{}", (Object)task.getFromUid(), (Object)task.getSubscribeUid());
                }
                catch (Exception e) {
                    Log.error("status subscribe thread exception, err:{}", (Object)e.getMessage());
                }
            }
            Log.warn("exit status subscribe thread! left task num:{}", (Object)this.waitTaskQueue.size());
        }
    }

    static class BatchStatusSubscriberMgr {
        private static BatchStatusSubscriberMgr inst = null;
        private BatchStatusSubscriber batchStatusSubscriber = null;

        BatchStatusSubscriberMgr() {
        }

        static synchronized BatchStatusSubscriberMgr getInstance() {
            if (inst == null) {
                FixedThreadPoolImpl threadPool = ThreadPoolFactory.getFixedThreadPoolImpl();
                ExecutorService executorService = threadPool.getFixedThreadPool();
                inst = new BatchStatusSubscriberMgr();
                executorService.execute(inst.createSubscriber());
            }
            return inst;
        }

        private BatchStatusSubscriber createSubscriber() {
            Log.info("create status subscriber");
            this.batchStatusSubscriber = new BatchStatusSubscriber();
            return this.batchStatusSubscriber;
        }

        public boolean addTask(StatusSubscribeTask task) {
            return this.batchStatusSubscriber.addTask(task);
        }
    }

    static class StatusSubscribeTask {
        private String fromUid = null;
        private String subscribeUid = null;
        private long expireSecond = 0L;

        public StatusSubscribeTask(String fromUid, String subscribeUid, long futureSecond) {
            this.fromUid = fromUid;
            this.subscribeUid = subscribeUid;
            this.expireSecond = futureSecond;
        }

        public String getFromUid() {
            return this.fromUid;
        }

        public void setFromUid(String fromUid) {
            this.fromUid = fromUid;
        }

        public String getSubscribeUid() {
            return this.subscribeUid;
        }

        public void setSubscribeUid(String subscribeUid) {
            this.subscribeUid = subscribeUid;
        }

        public long getExpireSecond() {
            return this.expireSecond;
        }

        public void setExpireSecond(long expireSecond) {
            this.expireSecond = expireSecond;
        }
    }
}

