/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.dom4j.Element;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.status.StatusMessage;
import org.jivesoftware.openfire.plugin.util.StatusEnum;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Presence;

public class StatusUtils {
    private static final Logger Log = LoggerFactory.getLogger(StatusUtils.class);
    private static final String ID = "id";
    private static final String FROM = "from";
    private static final String TYPE = "type";
    private static final String PRIORITY = "priority";
    private static final String JSON_OBJ_PREFIX = "{";
    public static final String STATUS = "status";
    public static final int ONE_PRESENCE_ITEM_LIMIT = 500;
    public static final String STATUS_NOTIFY_NAMESPACE = "http://weaver.com.cn/status_notify";
    public static final String ONLINE_USER_LIST = "onlineUsers";
    public static final String OFFLINE_USER_LIST = "offlineUsers";
    public static final String ALL_ONLINE_USER_LIST = "allOnlineUsers";
    public static final String AWAY_USER_LIST = "away";
    public static final int STATUS_THROW_TIMEOUT = 600000;
    public static final String PC = "pc";
    public static final String MOBILE = "mobile";
    public static final String PAD = "pad";
    public static final String STATUS_SWITCH_OPEN_TAG = "optimize.status.switch.open";
    public static final String STATUS_SYNC_OPEN_TAG = "optimize.status.sync.open";
    public static final String STATUS_NOTIFY_OPEN_TAG = "optimize.status.notify.open";
    public static final String STATUS_MOBILE_NOTIFY_OPEN_TAG = "optimize.status.notify.mob.open";
    public static final String STATUS_PC_NOTIFY_OPEN_TAG = "optimize.status.notify.pc.open";
    public static final String STATUS_OVERLOAD_OPEN_TAG = "optimize.status.overload.open";
    public static final String STATUS_PC_EXPIRE_TAG = "optimize.status.pc.expire.second";
    public static final String STATUS_MOBILE_EXPIRE_TAG = "optimize.status.mob.expire.second";
    public static final String STATUS_MAX_CPULOAD_TAG = "optimize.status.max.cpuload";
    public static final String STATUS_SUBSCRIBE_MAX_NUM_TAG = "optimize.status.subscribe.num";
    private static int STATUS_PC_EXPIRE = 2592000;
    private static int STATUS_MOBILE_EXPIRE = 3600;
    private static int STATUS_SUBSCRIBE_MAX_NUM = 1000;
    private static int STATUS_MAX_CPULOAD_LIMIT = 1;
    private static String uuid = null;
    private static String domain = null;
    private static SessionManager sessionManager = null;

    public static int getStatusPcExpire() {
        STATUS_PC_EXPIRE = JiveGlobals.getIntProperty((String)STATUS_PC_EXPIRE_TAG, (int)STATUS_PC_EXPIRE);
        return STATUS_PC_EXPIRE;
    }

    public static int getStatusMobileExpire() {
        STATUS_MOBILE_EXPIRE = JiveGlobals.getIntProperty((String)STATUS_MOBILE_EXPIRE_TAG, (int)STATUS_MOBILE_EXPIRE);
        return STATUS_MOBILE_EXPIRE;
    }

    public static int getStatusMaxCpuLoadLimit() {
        STATUS_MAX_CPULOAD_LIMIT = JiveGlobals.getIntProperty((String)STATUS_MAX_CPULOAD_TAG, (int)STATUS_MAX_CPULOAD_LIMIT);
        return STATUS_MAX_CPULOAD_LIMIT;
    }

    public static int getStatusSubscribeMaxNum() {
        STATUS_SUBSCRIBE_MAX_NUM = JiveGlobals.getIntProperty((String)STATUS_SUBSCRIBE_MAX_NUM_TAG, (int)STATUS_SUBSCRIBE_MAX_NUM);
        return STATUS_SUBSCRIBE_MAX_NUM;
    }

    public static String GenerateUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static StatusMessage makeStatusMsg(Presence presence) {
        int now = (int)(System.currentTimeMillis() / 1000L);
        Element e = presence.addChildElement("time", STATUS);
        e.addText(String.valueOf(now));
        StatusMessage obj = new StatusMessage();
        obj.setContent(presence.toXML());
        obj.setMsgId(presence.getID());
        obj.setTimeStamp(now);
        obj.setShow(presence.getShow().ordinal());
        obj.setFrom(presence.getFrom().toString());
        return obj;
    }

    public static String Presence2Json(Presence presence) {
        if (presence.getFrom() == null) {
            return "{}";
        }
        HashMap<String, Object> pjo = new HashMap<String, Object>();
        pjo.put(ID, presence.getID());
        pjo.put(FROM, presence.getFrom().toString());
        if (0 != presence.getPriority()) {
            pjo.put(PRIORITY, presence.getPriority());
        }
        if (null != presence.getType()) {
            pjo.put(TYPE, presence.getType().toString());
        }
        if (null != presence.getStatus()) {
            pjo.put(STATUS, presence.getStatus());
        }
        return JSON.toJSONString(pjo);
    }

    public static Presence decodeStatusMsg(String data) {
        JSONObject jsonObject = null;
        Presence presence = null;
        if (!data.startsWith(JSON_OBJ_PREFIX)) {
            return presence;
        }
        try {
            jsonObject = JSON.parseObject((String)data);
            String fromJidStr = jsonObject.getString(FROM);
            String idStr = jsonObject.getString(ID);
            int priority = 0;
            String type = null;
            String status = null;
            JID fromJid = null;
            if (fromJidStr.contains("@")) {
                try {
                    fromJid = new JID(fromJidStr);
                }
                catch (Exception e) {
                    Log.warn("make jid failed, jid str:{}", (Object)fromJid);
                    return null;
                }
            }
            presence = new Presence();
            presence.setFrom(fromJid);
            if (idStr != null && !idStr.isEmpty()) {
                presence.setID(idStr);
            }
            if (jsonObject.containsKey((Object)PRIORITY) && 0 != (priority = jsonObject.getIntValue(PRIORITY))) {
                presence.setPriority(priority);
            }
            if (jsonObject.containsKey((Object)TYPE) && null != (type = jsonObject.getString(TYPE)) && !type.isEmpty()) {
                presence.setType(Presence.Type.valueOf((String)type));
            }
            if (jsonObject.containsKey((Object)STATUS) && null != (status = jsonObject.getString(STATUS)) && !status.isEmpty()) {
                presence.setStatus(status);
            }
        }
        catch (Exception e) {
            Log.warn("parse status change msg failed, data:{}", (Object)data);
            return presence;
        }
        return presence;
    }

    public static StatusEnum getStatusFromPresence(Presence presence) {
        StatusEnum type = null;
        if (presence != null) {
            Log.debug("get status, show presence:{}", (Object)presence.toXML());
        }
        if (presence == null) {
            type = StatusEnum.DEV_OFFLINE;
        } else {
            if (presence.getType() == Presence.Type.unavailable) {
                type = StatusEnum.DEV_OFFLINE;
                return type;
            }
            String statusStr = presence.getStatus();
            type = StatusEnum.DEV_AWAY.getDesc().equals(statusStr) ? StatusEnum.DEV_AWAY : (StatusEnum.DEV_ONBUSY.getDesc().equals(statusStr) ? StatusEnum.DEV_ONBUSY : (StatusEnum.DEV_NO_DISTURB.getDesc().equals(statusStr) ? StatusEnum.DEV_NO_DISTURB : (StatusEnum.DEV_HIDDEN.getDesc().equals(statusStr) ? StatusEnum.DEV_HIDDEN : (StatusEnum.DEV_ON_BUSINESS.getDesc().equals(statusStr) ? StatusEnum.DEV_ON_BUSINESS : (StatusEnum.DEV_ON_CALLING.getDesc().equals(statusStr) ? StatusEnum.DEV_ON_CALLING : StatusEnum.DEV_ONLINE)))));
        }
        if (presence != null) {
            Log.debug("{} status is {}", (Object)presence.getFrom().toString(), (Object)type);
        } else {
            Log.debug("user status is offline, presence is null");
        }
        return type;
    }

    public static StatusEnum getStatus(JID jid) {
        String resource = jid.getResource();
        if (MOBILE.equals(resource)) {
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            if (redisPoolMgr == null) {
                return StatusEnum.DEV_OFFLINE;
            }
            try {
                String key = "mobile_presence_" + jid.toString();
                String value = redisPoolMgr.get(key);
                if (value != null && !value.isEmpty()) {
                    return StatusEnum.DEV_ONLINE;
                }
                RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
                ClientSession client = routingTable.getClientRoute(jid);
                if (client == null || client.isAnonymousUser() || client.isClosed()) {
                    ClusterRedisUtil clusterRedisUtil;
                    String clusterNode;
                    ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
                    if (clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty()) {
                        return StatusEnum.DEV_ONLINE;
                    }
                    return StatusEnum.DEV_OFFLINE;
                }
                return StatusEnum.DEV_ONLINE;
            }
            catch (Exception e) {
                Log.error("get Mobile Presence error.jid:{}", (Object)jid);
                return StatusEnum.DEV_OFFLINE;
            }
        }
        if (sessionManager == null) {
            sessionManager = XMPPServer.getInstance().getSessionManager();
        }
        if (sessionManager == null) {
            Log.warn("get status failed, session manager is null");
            return StatusEnum.DEV_UNKNOWN;
        }
        StatusEnum type = null;
        ClientSession devSession = sessionManager.getSession(jid);
        if (devSession != null) {
            type = StatusUtils.getStatusFromPresence(devSession.getPresence());
        } else {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            if (clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty()) {
                return StatusEnum.DEV_ONLINE;
            }
            Log.debug("{} is offline, no presence", (Object)jid.toString());
            type = StatusEnum.DEV_OFFLINE;
        }
        return type;
    }

    public static StatusEnum getStatus(String userId, String resource) {
        JID jid = StatusUtils.makeJid(userId, resource);
        StatusEnum s = StatusUtils.getStatus(jid);
        return s;
    }

    public static JID makeJid(String id, String resource) {
        JID jid = null;
        if (uuid == null) {
            uuid = StatusUtils.getUDID();
        }
        if (uuid == null) {
            Log.error("status plugin get uuid failed!!!");
            return null;
        }
        if (domain == null) {
            domain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        }
        try {
            jid = new JID(id + "|" + uuid, domain, resource, true);
        }
        catch (Exception e) {
            Log.error("create jid failed, e:{}", (Object)e.getMessage());
        }
        return jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUDID() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block5: {
            String string;
            if (uuid != null) {
                return uuid;
            }
            con = null;
            pstmt = null;
            rs = null;
            try {
                String propvalue;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next() || (propvalue = rs.getString("propvalue")) == null) break block5;
                string = propvalue.toLowerCase();
            }
            catch (Exception e) {
                try {
                    Log.error("getUDID,error : {}", (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return string;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return null;
    }

    public static void addDevList(String userId, StatusEnum type, String dev, Collection<String> onlineDev, Collection<String> offlineDev) {
        if (type == null) {
            offlineDev.add(userId);
            return;
        }
        switch (type) {
            case DEV_ONLINE: {
                if (MOBILE.equals(dev)) {
                    onlineDev.add(String.format("%s/%s", userId, dev));
                    break;
                }
                onlineDev.add(userId);
                break;
            }
            case DEV_ONBUSY: 
            case DEV_AWAY: 
            case DEV_ON_CALLING: 
            case DEV_ON_BUSINESS: 
            case DEV_NO_DISTURB: 
            case DEV_HIDDEN: {
                onlineDev.add(userId);
                break;
            }
            case DEV_OFFLINE: {
                offlineDev.add(userId);
                break;
            }
            default: {
                Log.warn("unknown status type:{}, user id:{}", (Object)type, (Object)userId);
            }
        }
    }

    public static String conNodeToID(String node) {
        if (node == null) {
            return "";
        }
        int i = node.indexOf("|");
        if (i > 0) {
            return node.substring(0, i);
        }
        if (0 == i) {
            return "";
        }
        return node;
    }

    public static boolean isStatusOpen() {
        return JiveGlobals.getBooleanProperty((String)STATUS_SWITCH_OPEN_TAG, (boolean)false);
    }

    public static boolean isStatusSyncOpen() {
        return JiveGlobals.getBooleanProperty((String)STATUS_SYNC_OPEN_TAG, (boolean)true);
    }

    public static void setStatusOpen(boolean flag) {
        JiveGlobals.setProperty((String)STATUS_SWITCH_OPEN_TAG, (String)String.valueOf(flag));
        Log.info("set status switch flag:{}", (Object)flag);
    }

    public static boolean isStatusOverloadOpen() {
        return JiveGlobals.getBooleanProperty((String)STATUS_OVERLOAD_OPEN_TAG, (boolean)false);
    }

    public static boolean isStatusNotifyOpen() {
        return JiveGlobals.getBooleanProperty((String)STATUS_NOTIFY_OPEN_TAG, (boolean)true);
    }

    public static boolean isMobileStatusNotifyOpen() {
        return JiveGlobals.getBooleanProperty((String)STATUS_MOBILE_NOTIFY_OPEN_TAG, (boolean)true);
    }

    public static boolean isPcStatusNotifyOpen() {
        return JiveGlobals.getBooleanProperty((String)STATUS_PC_NOTIFY_OPEN_TAG, (boolean)true);
    }

    public static int getOnlineUserCount() {
        RedisPoolMgr redisPoolMgr;
        Set redisUsers;
        ClusterRedisUtil clusterRedisUtil;
        Set clusterNodes;
        ClusterPropBeanUtil clusterPropBeanUtil;
        HashSet<String> onlineUsers = new HashSet<String>();
        Collection clientSessions = SessionManager.getInstance().getSessions();
        if (clientSessions != null && clientSessions.size() > 0) {
            for (ClientSession c : clientSessions) {
                JID jid;
                if (c == null || !c.canFloodOfflineMessages() || (jid = c.getAddress()) == null) continue;
                onlineUsers.add(jid.getNode());
            }
        }
        if ((clusterPropBeanUtil = ClusterPropBeanUtil.getInstance()).isUseCluster() && null != (clusterNodes = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getClusterNodes())) {
            for (String clusterNode : clusterNodes) {
                List allOnlineUser = clusterRedisUtil.getAllOnlineUserByClusterNode(clusterNode);
                if (allOnlineUser == null || allOnlineUser.size() <= 0) continue;
                for (String jidStr : allOnlineUser) {
                    JID jid = new JID(jidStr, true);
                    onlineUsers.add(jid.getNode());
                }
            }
        }
        if ((redisUsers = (redisPoolMgr = RedisPoolMgr.getInstance()).zrange("msg:mobile:onlinequeue", 0L, -1L)) != null && redisUsers.size() > 0) {
            for (String key : redisUsers) {
                String value = redisPoolMgr.get(key);
                if (value != null && !value.isEmpty()) {
                    String jidstr = key.replace("mobile_presence_", "");
                    JID jid = new JID(jidstr, true);
                    onlineUsers.add(jid.getNode());
                    continue;
                }
                redisPoolMgr.zrem("msg:mobile:onlinequeue", key);
            }
        }
        return onlineUsers.size();
    }
}

