/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.ServerSwitch;
import com.xiaomi.xmpush.server.XMStringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;

public class HttpBase {
    protected static final String UTF8 = "UTF-8";
    protected static final int BACKOFF_INITIAL_DELAY = 1000;
    private static final String JDK_VERSION = System.getProperty("java.version", "UNKNOWN");
    private static final String OS = System.getProperty("os.name").toLowerCase();
    protected static final int MAX_BACKOFF_DELAY = 1024000;
    protected final Random random = new Random();
    protected final String security;
    protected final String token;
    protected final Region region;
    protected final boolean isVip;
    protected long lastRequestCostTime = 0L;
    protected ERROR lastRequestError = ERROR.SUCCESS;
    protected String lastRequestUrl = null;
    protected String lastRequestHost = null;
    protected String remoteHost = "";
    protected String remoteIp = "";
    protected Exception lastException = null;
    protected static final Logger logger = Logger.getLogger(HttpBase.class.getName());
    private static final String LOCAL_HOST_NAME = HttpBase.getLocalHostName();
    private static String LOCAL_IP;
    private static boolean useProxy;
    private static boolean needAuth;
    private static String proxyHost;
    private static int proxyPort;
    private static String user;
    private static String password;
    private static final SSLHandler sslVerifier;

    public HttpBase(String security) {
        this.security = security;
        this.token = null;
        this.region = Region.China;
        this.isVip = false;
    }

    public HttpBase(String security, boolean isVip) {
        this.security = security;
        this.token = null;
        this.region = Region.China;
        this.isVip = isVip;
    }

    public HttpBase(String security, String token) {
        this.security = security;
        this.token = token;
        this.region = Region.China;
        this.isVip = false;
    }

    public HttpBase(String security, String token, boolean isVip) {
        this.security = security;
        this.token = token;
        this.region = Region.China;
        this.isVip = isVip;
    }

    public HttpBase(String security, Region region) {
        this.security = security;
        this.token = null;
        this.region = region;
        this.isVip = false;
    }

    public HttpBase(String security, String token, Region region) {
        this.security = security;
        this.token = token;
        this.region = region;
        this.isVip = false;
    }

    private static String getLocalHostName() {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
            LOCAL_IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host;
    }

    protected IOException exception(int attemptNum) {
        String msg = "Failed to send http request after " + attemptNum + " attempts: remote server " + this.remoteHost + "(" + this.remoteIp + ")";
        if (this.lastException != null) {
            msg = msg + "\nException " + this.lastException.getClass().getCanonicalName() + " : " + this.lastException.getLocalizedMessage() + "\n" + this.lastException.getCause();
            StackTraceElement[] traces = this.lastException.getStackTrace();
            if (traces != null) {
                for (StackTraceElement trace : traces) {
                    msg = msg + "\n  " + trace.getClassName() + trace.getMethodName() + " (" + trace.getFileName() + ":" + trace.getLineNumber() + ")";
                }
            }
        }
        this.lastException = null;
        return new IOException(msg);
    }

    private HttpURLConnection httpRequest(HttpAction action, Constants.RequestPath requestPath) throws IOException {
        ServerSwitch.Server server = ServerSwitch.getInstance().selectServer(requestPath, this.region, this.isVip);
        long start = System.currentTimeMillis();
        boolean succ = false;
        try {
            HttpURLConnection result = action.action(server);
            succ = true;
            this.lastRequestError = ERROR.SUCCESS;
            Constants.autoSwitchHost = result.getHeaderField("X-PUSH-DISABLE-AUTO-SELECT-DOMAIN") == null;
            Constants.accessTimeOut = result.getHeaderFieldInt("X-PUSH-CLIENT-TIMEOUT-MS", 5000);
            String hosts = result.getHeaderField("X-PUSH-HOST-LIST");
            if (hosts != null) {
                ServerSwitch.getInstance().initialize(hosts);
            }
            HttpURLConnection httpURLConnection = result;
            return httpURLConnection;
        }
        catch (SocketTimeoutException e) {
            this.lastRequestError = ERROR.SocketTimeoutException;
            throw e;
        }
        catch (IOException e) {
            this.lastRequestError = ERROR.IOException;
            throw e;
        }
        finally {
            this.lastRequestCostTime = System.currentTimeMillis() - start;
            if (this.lastRequestCostTime > (long)Constants.accessTimeOut) {
                this.lastRequestError = ERROR.CostTooMuchTime;
                server.decrPriority();
            } else if (succ) {
                server.incrPriority();
            } else {
                server.decrPriority();
            }
            this.lastRequestUrl = requestPath.getPath();
            this.lastRequestHost = server.getHost();
        }
    }

    protected String getResponseBody(HttpURLConnection conn) throws IOException {
        String responseBody;
        int status = conn.getResponseCode();
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = HttpBase.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = HttpBase.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    protected HttpURLConnection doPost(final Constants.RequestPath requestPath, final String body) throws IOException {
        return this.httpRequest(new HttpAction(){

            @Override
            public HttpURLConnection action(ServerSwitch.Server server) throws IOException {
                return HttpBase.this.doPost(server, requestPath, "application/x-www-form-urlencoded;charset=UTF-8", body);
            }
        }, requestPath);
    }

    protected HttpURLConnection doGet(final Constants.RequestPath requestPath, final String parameter) throws IOException {
        return this.httpRequest(new HttpAction(){

            @Override
            public HttpURLConnection action(ServerSwitch.Server server) throws IOException {
                return HttpBase.this.doGet(server, requestPath, "application/x-www-form-urlencoded;charset=UTF-8", parameter);
            }
        }, requestPath);
    }

    protected HttpURLConnection doUpload(final Constants.RequestPath requestPath, final File file, final String parameter) throws IOException {
        return this.httpRequest(new HttpAction(){

            @Override
            public HttpURLConnection action(ServerSwitch.Server server) throws IOException {
                return HttpBase.this.doUpload(server, requestPath, file, parameter);
            }
        }, requestPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection doPost(ServerSwitch.Server server, Constants.RequestPath requestPath, String contentType, String body) throws IOException {
        if (requestPath == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        logger.fine("Sending post to " + server.getHost() + " " + requestPath.getPath());
        logger.finest("post body: " + body);
        HttpURLConnection conn = this.getConnection(server, requestPath);
        this.prepareConnection(conn);
        byte[] bytes = body.getBytes();
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.security);
        if (this.token != null) {
            conn.setRequestProperty("X-PUSH-AUDIT-TOKEN", this.token);
        }
        OutputStream out = conn.getOutputStream();
        try {
            out.write(bytes);
        }
        finally {
            HttpBase.close(out);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection doUpload(ServerSwitch.Server server, Constants.RequestPath requestPath, File file, String parameter) throws IOException {
        if (requestPath == null || file == null || !file.exists()) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        logger.fine("Upload to " + server.getHost() + " " + requestPath.getPath());
        logger.finest("post file name : " + file);
        String BOUNDARY = "------WKFB" + UUID.randomUUID().toString();
        String TWO_HYPHENS = "--";
        String LINE_END = "\r\n";
        HttpURLConnection conn = this.getConnection(server, requestPath, parameter);
        this.prepareConnection(conn);
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Charsert", UTF8);
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        conn.setRequestProperty("Authorization", "key=" + this.security);
        if (this.token != null) {
            conn.setRequestProperty("X-PUSH-AUDIT-TOKEN", this.token);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_END);
        sb.append(TWO_HYPHENS);
        sb.append(BOUNDARY);
        sb.append(LINE_END);
        sb.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"");
        sb.append(LINE_END);
        sb.append("Content-Type: image/*");
        sb.append(LINE_END);
        sb.append("Content-Lenght: " + file.length());
        sb.append(LINE_END);
        sb.append(LINE_END);
        FileInputStream in = new FileInputStream(file);
        OutputStream out = conn.getOutputStream();
        try {
            out.write(sb.toString().getBytes(UTF8));
            int bytes = 0;
            byte[] buffer = new byte[1024];
            while ((bytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
            }
            byte[] endData = (LINE_END + TWO_HYPHENS + BOUNDARY + TWO_HYPHENS + LINE_END).getBytes();
            out.write(endData);
            out.flush();
        }
        finally {
            HttpBase.close(out);
        }
        return conn;
    }

    protected HttpURLConnection doGet(ServerSwitch.Server server, Constants.RequestPath requestPath, String contentType, String parameter) throws IOException {
        if (requestPath == null || parameter == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        logger.fine("Sending get to " + server.getHost() + " " + requestPath.getPath());
        logger.finest("get parameter: " + parameter);
        HttpURLConnection conn = this.getConnection(server, requestPath, parameter);
        this.prepareConnection(conn);
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.security);
        conn.getInputStream();
        return conn;
    }

    protected void prepareConnection(HttpURLConnection conn) {
        conn.setRequestProperty("X-PUSH-SDK-VERSION", "JAVA_SDK_V2.2.20");
        conn.setRequestProperty("X-PUSH-JDK-VERSION", JDK_VERSION);
        conn.setRequestProperty("X-PUSH-OS", OS);
        conn.setRequestProperty("X-PUSH-REMOTEIP", this.remoteIp);
        if (LOCAL_HOST_NAME != null) {
            conn.setRequestProperty("X-PUSH-CLIENT-HOST", LOCAL_HOST_NAME);
        }
        if (LOCAL_IP != null) {
            conn.setRequestProperty("X-PUSH-CLIENT-IP", LOCAL_IP);
        }
        if (Constants.INCLUDE_LAST_METRICS) {
            if (this.lastRequestCostTime > 0L) {
                conn.setRequestProperty("X-PUSH-LAST-REQUEST-DURATION", this.lastRequestCostTime + "");
                this.lastRequestCostTime = 0L;
            }
            if (this.lastRequestUrl != null) {
                conn.setRequestProperty("X-PUSH-LAST-REQUEST-URL", this.lastRequestUrl);
                this.lastRequestUrl = null;
            }
            if (this.lastRequestHost != null) {
                conn.setRequestProperty("X-PUSH-LAST-REQUEST-HOST", this.lastRequestHost);
                this.lastRequestHost = null;
            }
            conn.setRequestProperty("X-PUSH-LAST-ERROR", this.lastRequestError.name());
            this.lastRequestError = ERROR.SUCCESS;
        }
        if (Constants.autoSwitchHost && ServerSwitch.getInstance().needRefreshHostList()) {
            conn.setRequestProperty("X-PUSH-HOST-LIST", "true");
        }
    }

    protected static StringBuilder newBody(String name, String value) {
        return new StringBuilder(HttpBase.nonNull(name)).append('=').append(HttpBase.nonNull(value));
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "IOException closing stream", e);
            }
        }
    }

    protected static StringBuilder newBodyWithArrayParameters(String name, List<String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == 0) {
                sb.append(HttpBase.nonNull(name)).append("=").append(URLEncoder.encode(HttpBase.nonNull(parameters.get(i)), UTF8));
                continue;
            }
            HttpBase.nonNull(sb).append('&').append(HttpBase.nonNull(name)).append('=').append(URLEncoder.encode(HttpBase.nonNull(parameters.get(i)), UTF8));
        }
        if (parameters.size() == 0) {
            sb.append(name).append("=").append("");
        }
        return sb;
    }

    protected static void addParameter(StringBuilder body, String name, String value) {
        HttpBase.nonNull(body).append('&').append(HttpBase.nonNull(name)).append('=').append(HttpBase.nonNull(value));
    }

    protected HttpURLConnection getConnection(ServerSwitch.Server server, Constants.RequestPath requestPath) throws IOException {
        return this.getConnection(server, requestPath, null);
    }

    protected HttpURLConnection getConnection(Constants.RequestPath requestPath) throws IOException {
        return this.getConnection(null, requestPath, null);
    }

    protected HttpURLConnection getConnection(ServerSwitch.Server server, Constants.RequestPath requestPath, String parameter) throws IOException {
        if (server == null) {
            server = ServerSwitch.getInstance().selectServer(requestPath, this.region, this.isVip);
        }
        String urlSpec = ServerSwitch.buildFullRequestURL(server, requestPath);
        if (parameter != null) {
            urlSpec = urlSpec + "?" + parameter;
        }
        URL url = new URL(urlSpec);
        if (useProxy) {
            return this.setProxy(url);
        }
        this.remoteHost = "";
        this.remoteIp = "";
        try {
            this.remoteHost = url.getHost();
            InetAddress address = InetAddress.getByName(this.remoteHost);
            this.remoteIp = address.getHostAddress();
        }
        catch (Exception e) {
            this.lastException = e;
            logger.log(Level.WARNING, "Get remote ip failed for " + this.remoteHost, e);
        }
        if (Constants.USE_HTTPS) {
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            return conn;
        }
        return (HttpURLConnection)url.openConnection();
    }

    private HttpsURLConnection setProxy(URL url) throws IOException {
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{sslVerifier}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(sslVerifier);
        }
        catch (Exception e) {
            logger.fine("https config ssl failure: " + e);
            this.lastException = e;
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection(proxy);
        if (needAuth) {
            String encoded = new String(Base64.encodeBase64((byte[])(user + ":" + password).getBytes()));
            httpsURLConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        }
        return httpsURLConnection;
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    protected static String getAndClose(InputStream stream) throws IOException {
        try {
            String string = HttpBase.getString(stream);
            return string;
        }
        finally {
            if (stream != null) {
                HttpBase.close(stream);
            }
        }
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.lastException = e;
            Thread.currentThread().interrupt();
        }
    }

    public static void setProxy(String host, int port) {
        HttpBase.setProxy(host, port, null, null);
    }

    public static void setProxy(String host, int port, String authUser, String authPassword) {
        if (XMStringUtils.isBlank(host) || port <= 0) {
            throw new IllegalArgumentException("proxy host or port invalid.");
        }
        useProxy = true;
        needAuth = !XMStringUtils.isBlank(authUser) && !XMStringUtils.isBlank(authPassword);
        proxyHost = host;
        proxyPort = port;
        user = authUser;
        password = authPassword;
    }

    public static void unsetProxy() {
        useProxy = false;
        needAuth = false;
    }

    static {
        useProxy = false;
        needAuth = false;
        sslVerifier = new SSLHandler();
    }

    private static class SSLHandler
    implements X509TrustManager,
    HostnameVerifier {
        private SSLHandler() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    }

    static interface HttpAction {
        public HttpURLConnection action(ServerSwitch.Server var1) throws IOException;
    }

    static enum ERROR {
        SUCCESS,
        SocketTimeoutException,
        IOException,
        CostTooMuchTime;

    }
}

