/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.Result;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Media
extends HttpBase {
    public Media(String security) {
        super(security);
    }

    public Media(String security, Region region) {
        super(security, region);
    }

    public Result upload(File file, boolean isIcon, boolean isGlobal) throws IOException {
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = Media.newBody("is_global", String.valueOf(isGlobal));
            Media.addParameter(sb, "is_icon", String.valueOf(isIcon));
            conn = this.doUpload(Constants.XmPushRequestPath.MEDIA_UPLOAD_IMAGE, file, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "IOException send message: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return this.getResponseResult(status, conn);
    }

    public Result uploadSmallIcon(File file) throws IOException {
        int status;
        HttpURLConnection conn;
        try {
            conn = this.doUpload(Constants.XmPushRequestPath.MEDIA_UPLOAD_SMALLICON, file, null);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "IOException send message: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return this.getResponseResult(status, conn);
    }

    public Result querySmallIconInfoByAppId(long appId) throws IOException {
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = Media.newBody("app_id", String.valueOf(appId));
            conn = this.doGet(Constants.XmPushRequestPath.MEDIA_UPLOAD_SMALLICON_QUERY, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "IOException send message: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return this.getResponseResult(status, conn);
    }

    private Result getResponseResult(int status, HttpURLConnection conn) throws IOException {
        String responseBody;
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Media.getAndClose(conn.getErrorStream());
                logger.finest("Plain upload error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                this.lastException = e;
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Media.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            throw new IOException("Invalid response from XmPush: " + responseBody);
        }
    }
}

