/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.message.iqauth.plugin.iqhandler;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.StreamError;

public class IQAuthHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQAuthHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", "jabber:iq:auth");
    private String serverName;
    private RoutingTable routingTable;

    public IQAuthHandler() {
        super("IQAuthHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException, PacketException {
        JID from = packet.getFrom();
        LocalClientSession session = (LocalClientSession)this.sessionManager.getSession(from);
        if (session == null) {
            Log.error("Error during authentication. Session not found in " + this.sessionManager.getPreAuthenticatedKeys() + " for key " + from);
            IQ reply = IQ.createResultIQ((IQ)packet);
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.internal_server_error);
            return reply;
        }
        IQ response = null;
        String username = null;
        String data = packet.getElement().elementText("query");
        JSONObject json = JSONObject.parseObject((String)data);
        if (IQ.Type.get != packet.getType()) {
            if (json != null && json.containsKey((Object)"username")) {
                username = json.getString("username");
            }
            String password = null;
            if (json != null && json.containsKey((Object)"xytyijdn")) {
                password = json.getString("xytyijdn");
            }
            String resource = null;
            if (json != null && json.containsKey((Object)"resource")) {
                resource = json.getString("resource");
            }
            if (username == null || password == null || resource == null) {
                return null;
            }
            try {
                response = this.login(username, resource, packet, password, session);
            }
            catch (UserNotFoundException e) {
                Log.error("IQAuthHander,user not found.username:{},password:{},resource:{}", new Object[]{username, password, resource});
                response = IQ.createResultIQ((IQ)packet);
                response.setChildElement(packet.getChildElement().createCopy());
                response.setError(PacketError.Condition.not_authorized);
                session.process((Packet)response);
            }
            catch (ConnectionException e) {
                Log.error("IQAuthHander,ConnectionException.username:{},password:{},resource:{}", new Object[]{username, password, resource});
                response = IQ.createResultIQ((IQ)packet);
                response.setChildElement(packet.getChildElement().createCopy());
                response.setError(PacketError.Condition.bad_request);
                session.process((Packet)response);
            }
            catch (InternalUnauthenticatedException e) {
                Log.error("IQAuthHander,InternalUnauthenticatedException.username:{},password:{},resource:{}", new Object[]{username, password, resource});
                response = IQ.createResultIQ((IQ)packet);
                response.setChildElement(packet.getChildElement().createCopy());
                response.setError(PacketError.Condition.internal_server_error);
                session.process((Packet)response);
            }
        }
        if (response == null) {
            response = IQ.createResultIQ((IQ)packet);
            response.setChildElement(packet.getChildElement().createCopy());
            response.setError(PacketError.Condition.undefined_condition);
        }
        session.process((Packet)response);
        return null;
    }

    private IQ login(String username, String resource, IQ packet, String password, LocalClientSession session) throws UnauthorizedException, UserNotFoundException, ConnectionException, InternalUnauthenticatedException {
        username = username.toLowerCase();
        AuthToken token = null;
        if (password != null) {
            token = AuthFactory.authenticate((String)username, (String)password);
        }
        if (token == null) {
            Log.error("IQAuthHander,user not found.username:{},password:{},resource:{}", new Object[]{username, password, resource});
            IQ response = IQ.createResultIQ((IQ)packet);
            response.setChildElement(packet.getChildElement().createCopy());
            response.setError(PacketError.Condition.not_authorized);
            return response;
        }
        username = token.getUsername().toLowerCase();
        ClientSession oldSession = this.routingTable.getClientRoute(new JID(username, this.serverName, resource, true));
        if (oldSession != null) {
            try {
                int conflictLimit = this.sessionManager.getConflictKickLimit();
                if (conflictLimit == -1) {
                    IQ reply = IQ.createResultIQ((IQ)packet);
                    reply.setChildElement(packet.getChildElement().createCopy());
                    reply.setError(PacketError.Condition.conflict);
                    session.process((Packet)reply);
                    return null;
                }
                int conflictCount = oldSession.incrementConflictCount();
                if (conflictCount <= conflictLimit) {
                    IQ reply = IQ.createResultIQ((IQ)packet);
                    reply.setChildElement(packet.getChildElement().createCopy());
                    reply.setError(PacketError.Condition.conflict);
                    session.process((Packet)reply);
                    return null;
                }
                StreamError error = new StreamError(StreamError.Condition.conflict);
                oldSession.deliverRawText(error.toXML());
                oldSession.close();
            }
            catch (Exception e) {
                Log.error("Error during login", (Throwable)e);
            }
        } else {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            JID jid = new JID(username, this.serverName, resource, true);
            if (clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty() && !clusterNode.equals(clusterPropBeanUtil.getClusterName())) {
                clusterRedisUtil.saveNeedKillSession(clusterNode, jid);
            }
        }
        session.setAuthToken(token, resource);
        packet.setFrom(session.getAddress());
        return IQ.createResultIQ((IQ)packet);
    }

    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.routingTable = server.getRoutingTable();
        this.serverName = server.getServerInfo().getXMPPDomain();
    }

    public void destory() {
        Log.info("IQAuthExtendHandler destory");
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

