/*
 * Decompiled with CFR 0.152.
 */
package com.wu.yzg.app.sdk.auth;

import com.wu.yzg.app.sdk.exception.ClientException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class AppAuth2 {
    private static final String ENC = "UTF-8";

    public static String appAuth2Treaty(String appid, String appSecret) {
        if (StringUtils.isBlank((String)appid) || StringUtils.isBlank((String)appSecret)) {
            throw new ClientException("\u9700\u914d\u7f6eappId\u548cappSecret");
        }
        String authorization = "OpenAuth2 version=\"%s\", appid=\"%s\", timestamp=%d, nonce=\"%s\", sign=\"%s\"";
        try {
            String version = "1.1";
            appid = URLEncoder.encode(appid, ENC);
            long timestamp = System.currentTimeMillis();
            String nonce = URLEncoder.encode(UUID.randomUUID().toString(), ENC);
            String sign = AppAuth2.shaHex(version, appid, timestamp + "", nonce, appSecret);
            sign = URLEncoder.encode(sign, ENC);
            authorization = String.format(authorization, version, appid, timestamp, nonce, sign);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(ENC, e);
        }
        return authorization;
    }

    public static String shaHex(String ... data) {
        Arrays.sort(data);
        String join = StringUtils.join((Object[])data);
        String sign = DigestUtils.sha1Hex((String)join);
        return sign;
    }
}

