/*
 * Decompiled with CFR 0.152.
 */
package com.wu.yzg.app.sdk.auth.filter;

import com.alibaba.fastjson.JSON;
import com.wu.yzg.app.sdk.impl.AuthServiceImpl;
import com.wu.yzg.app.sdk.inter.IAfterValidateTicket;
import com.wu.yzg.app.sdk.inter.impl.DefaultAfterTickectImpl;
import com.wu.yzg.app.sdk.model.Constant;
import com.wu.yzg.app.sdk.model.ResponseModel;
import com.wu.yzg.app.sdk.model.UserVo;
import com.wu.yzg.app.sdk.util.RequestUtils;
import com.wu.yzg.app.sdk.util.URLUtils;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketValidationFilter
implements Filter {
    private IAfterValidateTicket afterValidateTicket;
    private String after_class;
    private String login_url = null;
    private String yzg_url;
    private String appId;
    private String appSecret;
    private boolean force_login;
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketValidationFilter.class);
    private final String YZG_KEY = "yzg_ticket";

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        block11: {
            String localTicket;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            String ticket = request.getParameter("yzg_ticket");
            int type = 0;
            if (StringUtils.isBlank((String)ticket)) {
                ticket = request.getParameter("em_auth_code");
                type = 1;
            }
            if (StringUtils.isNotBlank((String)ticket) && ticket.contains("?")) {
                ticket = ticket.substring(0, ticket.indexOf("?"));
            }
            if ((localTicket = RequestUtils.getCookieValue(request, "yzg_ticket")) != null) {
                localTicket = URLDecoder.decode(localTicket, "UTF-8");
            }
            if (localTicket != null && localTicket.equals(ticket)) {
                LOGGER.warn("tickect[" + ticket + "] \u5df2\u7ecf\u5904\u7406,\u5ffd\u7565....");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (ticket != null) {
                try {
                    AuthServiceImpl authService = new AuthServiceImpl();
                    UserVo user = authService.getUser(ticket, type);
                    if (user != null) {
                        boolean bool = this.afterValidateTicket.after(request, response, user);
                        if (bool) {
                            req.setAttribute("user", (Object)user);
                            RequestUtils.setCookie(request, response, "yzg_ticket", ticket, -1);
                            chain.doFilter(req, resp);
                        } else {
                            this.doError(request, response, null);
                        }
                        break block11;
                    }
                    LOGGER.error("tickect[" + ticket + "] \u83b7\u53d6\u7528\u6237\u5931\u8d25");
                    this.doError(request, response, null);
                }
                catch (Exception e) {
                    LOGGER.error("tickect[" + ticket + "] \u83b7\u53d6\u5931\u8d25", (Throwable)e);
                    this.doError(request, response, e);
                }
            } else {
                chain.doFilter(req, resp);
            }
        }
    }

    private void doError(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, IOException {
        String accept = request.getHeader("Accept");
        String message = e == null ? "\u767b\u5f55\u5931\u8d25" : e.getMessage();
        ResponseModel model = new ResponseModel();
        model.setCode("9999");
        model.setMessage(message);
        message = JSON.toJSONString((Object)model);
        if (accept.contains("json") || this.login_url == null) {
            response.setContentType("application/json;charset=UTF-8");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(message.getBytes("UTF-8"));
            outputStream.flush();
            outputStream.close();
        } else {
            response.sendRedirect(this.login_url);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.after_class = this.getValue(this.after_class, "after_class", config);
        this.login_url = this.getValue(this.login_url, "login_url", config);
        this.appId = this.getValue(this.appId, "appId", config);
        this.appSecret = this.getValue(this.appSecret, "appSecret", config);
        this.yzg_url = this.getValue(this.yzg_url, "yzg_url", config);
        String forceLoginStr = this.getValue("false", "force_login", config);
        this.force_login = "true".equalsIgnoreCase(forceLoginStr);
        URLUtils.setMessageUrl(this.yzg_url);
        Constant.appId = this.appId;
        Constant.appSecret = this.appSecret;
        if (this.after_class != null) {
            try {
                Class<?> clz = Class.forName(this.after_class);
                Object obj = clz.newInstance();
                if (obj instanceof IAfterValidateTicket) {
                    this.afterValidateTicket = (IAfterValidateTicket)obj;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("after_class \u6ca1\u6709\u914d\u7f6e");
            }
            catch (InstantiationException e) {
                LOGGER.error("\u521d\u59cb\u5316 after_class \u9519\u8bef", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("\u521d\u59cb\u5316 after_class \u9519\u8bef", (Throwable)e);
            }
        }
        if (this.afterValidateTicket == null) {
            this.afterValidateTicket = new DefaultAfterTickectImpl();
        }
    }

    private String getValue(String old, String key, FilterConfig config) {
        String value = config.getInitParameter(key);
        return StringUtils.isBlank((String)value) ? old : value;
    }

    public String getLogin_url() {
        return this.login_url;
    }

    public void setLogin_url(String login_url) {
        this.login_url = login_url;
    }

    public String getYzg_url() {
        return this.yzg_url;
    }

    public void setYzg_url(String yzg_url) {
        this.yzg_url = yzg_url;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getAfter_class() {
        return this.after_class;
    }

    public void setAfter_class(String after_class) {
        this.after_class = after_class;
    }

    public boolean isReLogin() {
        return this.force_login;
    }

    public void setReLogin(boolean reLogin) {
        this.force_login = reLogin;
    }
}

