/*
 * Decompiled with CFR 0.152.
 */
package com.wu.yzg.app.sdk.impl;

import com.wu.yzg.app.sdk.inter.ITodoMsgService;
import com.wu.yzg.app.sdk.model.CreateTodoMsgAllReq;
import com.wu.yzg.app.sdk.model.ReadMsgVo;
import com.wu.yzg.app.sdk.model.TodoMessage;
import com.wu.yzg.app.sdk.util.ClientHttpHelper;
import com.wu.yzg.app.sdk.util.URLUtils;
import com.wu.yzg.app.sdk.util.WeaverURLUtils;
import java.util.Arrays;
import java.util.List;

public class TodoMsgServiceImpl
implements ITodoMsgService {
    @Override
    public TodoMessage createTodoMsg(TodoMessage todoMessage, String appId, String secret) {
        return ClientHttpHelper.executePostRequest(URLUtils.getCreateTodoMsg(), todoMessage, appId, secret, TodoMessage.class);
    }

    @Override
    public TodoMessage createTodoMsg(TodoMessage todoMessage, String appId, String secret, int apitype) {
        if (apitype == 0) {
            return this.createTodoMsg(todoMessage, appId, secret);
        }
        return ClientHttpHelper.executePostRequest(WeaverURLUtils.getCreateTodoMsg(), todoMessage, appId, secret, TodoMessage.class);
    }

    @Override
    public TodoMessage createTodoMsgByCode(TodoMessage todoMessage, String appId, String secret) {
        return ClientHttpHelper.executePostRequest(URLUtils.getCreateTodoMsgByCode(), todoMessage, appId, secret, TodoMessage.class);
    }

    @Override
    public TodoMessage createTodoMsgByCode(TodoMessage todoMessage, String appId, String secret, int apitype) {
        if (apitype == 0) {
            return this.createTodoMsgByCode(todoMessage, appId, secret);
        }
        return ClientHttpHelper.executePostRequest(WeaverURLUtils.getCreateTodoMsgByCode(), todoMessage, appId, secret, TodoMessage.class);
    }

    @Override
    public List<TodoMessage> createTodoMsgAll(List<TodoMessage> todoMessages, String appId, String secret) {
        CreateTodoMsgAllReq req = new CreateTodoMsgAllReq();
        req.setTodoMessages(todoMessages);
        return ClientHttpHelper.executePostRequest(URLUtils.getCreateTodoMsgAll(), req, appId, secret, CreateTodoMsgAllReq.class).getTodoMessages();
    }

    @Override
    public List<TodoMessage> createTodoMsgAll(List<TodoMessage> todoMessages, String appId, String secret, int apitype) {
        if (apitype == 0) {
            return this.createTodoMsgAll(todoMessages, appId, secret);
        }
        CreateTodoMsgAllReq req = new CreateTodoMsgAllReq();
        req.setTodoMessages(todoMessages);
        return ClientHttpHelper.executePostRequest(WeaverURLUtils.getCreateTodoMsgAll(), req, appId, secret, CreateTodoMsgAllReq.class).getTodoMessages();
    }

    @Override
    public List<TodoMessage> createTodoMsgByCodeAll(List<TodoMessage> todoMessages, String appId, String secret) {
        CreateTodoMsgAllReq req = new CreateTodoMsgAllReq();
        req.setTodoMessages(todoMessages);
        return ClientHttpHelper.executePostRequest(URLUtils.getCreateTodoMsgByCodeAll(), req, appId, secret, CreateTodoMsgAllReq.class).getTodoMessages();
    }

    @Override
    public List<TodoMessage> createTodoMsgByCodeAll(List<TodoMessage> todoMessages, String appId, String secret, int apitype) {
        if (apitype == 0) {
            return this.createTodoMsgByCodeAll(todoMessages, appId, secret);
        }
        CreateTodoMsgAllReq req = new CreateTodoMsgAllReq();
        req.setTodoMessages(todoMessages);
        return ClientHttpHelper.executePostRequest(WeaverURLUtils.getCreateTodoMsgByCodeAll(), req, appId, secret, CreateTodoMsgAllReq.class).getTodoMessages();
    }

    @Override
    public Long doMsg(Long msgId, String appId, String secret) {
        ReadMsgVo readMsgVo = new ReadMsgVo();
        readMsgVo.setMsgIds(Arrays.asList(msgId));
        return ClientHttpHelper.executePostRequest(URLUtils.getDoTodoMsg(), readMsgVo, appId, secret, ReadMsgVo.class).getMsgIds().get(0);
    }

    @Override
    public Long doMsg(Long msgId, String appId, String secret, int apitype) {
        if (apitype == 0) {
            return this.doMsg(msgId, appId, secret);
        }
        ReadMsgVo readMsgVo = new ReadMsgVo();
        readMsgVo.setMsgIds(Arrays.asList(msgId));
        return ClientHttpHelper.executePostRequest(WeaverURLUtils.getDoMsgBatch(), readMsgVo, appId, secret, ReadMsgVo.class).getMsgIds().get(0);
    }

    @Override
    public List<Long> doMsgAll(List<Long> msgIds, String appId, String secret) {
        ReadMsgVo readMsgVo = new ReadMsgVo();
        readMsgVo.setMsgIds(msgIds);
        return ClientHttpHelper.executePostRequest(URLUtils.getDoTodoMsg(), readMsgVo, appId, secret, ReadMsgVo.class).getMsgIds();
    }

    @Override
    public List<Long> doMsgAll(List<Long> msgIds, String appId, String secret, int apitype) {
        if (apitype == 0) {
            return this.doMsgAll(msgIds, appId, secret);
        }
        ReadMsgVo readMsgVo = new ReadMsgVo();
        readMsgVo.setMsgIds(msgIds);
        return ClientHttpHelper.executePostRequest(WeaverURLUtils.getDoMsgBatch(), readMsgVo, appId, secret, ReadMsgVo.class).getMsgIds();
    }
}

