/*
 * Decompiled with CFR 0.152.
 */
package com.wu.yzg.app.sdk.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wu.yzg.app.sdk.auth.AppAuth2;
import com.wu.yzg.app.sdk.exception.ClientException;
import com.wu.yzg.app.sdk.model.Constant;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Auth2HttpUtils {
    public static final String UTF_8 = "UTF-8";

    public static String get(String pUrl) {
        return Auth2HttpUtils.get(pUrl, UTF_8);
    }

    public static String post(String pUrl, Object data) {
        return Auth2HttpUtils.post(pUrl, data, UTF_8);
    }

    public static String get(String pUrl, String charset) {
        InputStream inStream = null;
        try {
            String result;
            URL url = new URL(pUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-type", "application/json");
            urlConn.setRequestProperty("authorization", Auth2HttpUtils.getAuthorization());
            urlConn.setRequestMethod("GET");
            urlConn.connect();
            inStream = urlConn.getInputStream();
            String string = result = new String(Auth2HttpUtils.readInputStream(inStream), charset);
            return string;
        }
        catch (MalformedURLException e) {
            throw new ClientException("URL\u534f\u8bae\u3001\u683c\u5f0f\u6216\u8005\u8def\u5f84\u9519\u8bef:" + pUrl, e);
        }
        catch (ProtocolException e) {
            throw new ClientException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    throw new ClientException(e.getMessage(), e);
                }
            }
        }
    }

    public static String post(String pUrl, Object data, String charset) {
        InputStream inStream = null;
        try {
            String result;
            if (data == null) {
                String string = null;
                return string;
            }
            if (data instanceof Collection && ((Collection)data).size() < 0) {
                String string = null;
                return string;
            }
            String jsonData = "";
            jsonData = data instanceof Collection ? JSONArray.toJSONString((Object)data) : JSONObject.toJSONString((Object)data);
            URL url = new URL(pUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-type", "application/json");
            urlConn.setRequestProperty("authorization", Auth2HttpUtils.getAuthorization());
            urlConn.setRequestMethod("POST");
            urlConn.setDoInput(true);
            urlConn.connect();
            Auth2HttpUtils.writeOutputStream(urlConn.getOutputStream(), jsonData, charset);
            inStream = urlConn.getInputStream();
            String string = result = new String(Auth2HttpUtils.readInputStream(inStream), charset);
            return string;
        }
        catch (MalformedURLException e) {
            throw new ClientException("URL\u534f\u8bae\u3001\u683c\u5f0f\u6216\u8005\u8def\u5f84\u9519\u8bef:" + pUrl, e);
        }
        catch (ProtocolException e) {
            throw new ClientException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    throw new ClientException(e.getMessage(), e);
                }
            }
        }
    }

    public static String generateUrl(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            try {
                String value = entry.getValue();
                if (entry.getValue() != null) {
                    value = URLEncoder.encode(entry.getValue(), UTF_8);
                }
                sb.append("&").append(entry.getKey()).append("=").append(value);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.substring(1);
    }

    public static void writeOutputStream(OutputStream outputStream, String data, String charset) throws Exception {
        BufferedOutputStream outStream = new BufferedOutputStream(outputStream);
        outputStream.write(data.getBytes(charset));
        outStream.close();
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        byte[] data = outStream.toByteArray();
        outStream.close();
        inStream.close();
        return data;
    }

    private static String getAuthorization() {
        if (StringUtils.isBlank((String)Constant.appId) || StringUtils.isBlank((String)Constant.appSecret)) {
            throw new ClientException("\u8bf7\u8bbe\u7f6eappId\u548cappSecret");
        }
        return AppAuth2.appAuth2Treaty(Constant.appId, Constant.appSecret);
    }
}

