/*
 * Decompiled with CFR 0.152.
 */
package com.wu.yzg.app.sdk.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wu.yzg.app.sdk.auth.AppAuth2;
import com.wu.yzg.app.sdk.exception.ClientException;
import com.wu.yzg.app.sdk.model.Constant;
import com.wu.yzg.app.sdk.model.RestObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRestHelper {
    private static Logger logger = LoggerFactory.getLogger(ClientRestHelper.class);
    private static HttpClient httpClient = HttpClients.createDefault();
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();

    public static final <T> T executeGetRequest(String url, Object data, Class<T> resultClass) {
        HttpGet httpRequest = null;
        try {
            String queryStr = ClientRestHelper.generateUrl(data);
            httpRequest = StringUtils.isNotBlank((String)queryStr) ? new HttpGet(url + "?" + queryStr) : new HttpGet(url);
            logger.info("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)queryStr);
            httpRequest.addHeader("Content-Type", "application/json;charset=utf-8");
            httpRequest.addHeader("authorization", ClientRestHelper.getAuthorization());
            httpRequest.setConfig(requestConfig);
            Date date = new Date();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            logger.info("\u8bf7\u6c42\u65f6\u957f{}", (Object)((new Date().getTime() - date.getTime()) / 1000L));
            int code = httpResponse.getStatusLine().getStatusCode();
            logger.info("\u8bf7\u6c42\u7ed3\u679ccode:{}", (Object)code);
            if (code == 200) {
                HttpEntity httpEntity = httpResponse.getEntity();
                String resultJSON = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                logger.info("\u8bf7\u6c42\u7ed3\u679c:{}", (Object)resultJSON);
                EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                RestObject result = (RestObject)JSON.parseObject((String)resultJSON, RestObject.class);
                if (!result.getCode().equals("0001")) {
                    throw new ClientException(result.getMessage());
                }
                Object object = JSON.parseObject((String)result.getData(), resultClass);
                return (T)object;
            }
            try {
                throw new ClientException("\u8bf7\u6c42" + url + "\u5931\u8d25,code:" + code + "data:" + queryStr);
            }
            catch (Exception e) {
                throw new ClientException(e.getMessage(), e);
            }
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
        }
    }

    public static final <T> T executePostRequest(String url, Object data, Class<T> resultClass) {
        HttpPost httpRequest = new HttpPost(url);
        try {
            httpRequest.setConfig(requestConfig);
            String jsonData = JSON.toJSONString((Object)data);
            logger.info("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)jsonData);
            StringEntity entity = new StringEntity(jsonData, "utf-8");
            httpRequest.setEntity((HttpEntity)entity);
            httpRequest.addHeader("Content-Type", "application/json;charset=utf-8");
            httpRequest.addHeader("authorization", ClientRestHelper.getAuthorization());
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            int code = httpResponse.getStatusLine().getStatusCode();
            logger.info("\u8bf7\u6c42\u7ed3\u679ccode:{}", (Object)code);
            if (code == 200) {
                HttpEntity httpEntity = httpResponse.getEntity();
                String resultJSON = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                logger.info("\u8bf7\u6c42\u7ed3\u679c:{}", (Object)resultJSON);
                EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                RestObject result = (RestObject)JSON.parseObject((String)resultJSON, RestObject.class);
                if (!result.getCode().equals("0001")) {
                    throw new ClientException(result.getMessage());
                }
                Object object = JSON.parseObject((String)result.getData(), resultClass);
                return (T)object;
            }
            try {
                throw new ClientException("\u8bf7\u6c42" + url + "\u5931\u8d25,code:" + code + "data:" + jsonData);
            }
            catch (Exception e) {
                throw new ClientException(e.getMessage(), e);
            }
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
        }
    }

    public static final <T> List<T> executePostRequestList(String url, Object data, Class<T> resultClass) {
        HttpPost httpRequest = new HttpPost(url);
        try {
            httpRequest.setConfig(requestConfig);
            String jsonData = JSON.toJSONString((Object)data);
            logger.info("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)jsonData);
            StringEntity entity = new StringEntity(jsonData, "utf-8");
            httpRequest.setEntity((HttpEntity)entity);
            httpRequest.addHeader("Content-Type", "application/json;charset=utf-8");
            httpRequest.addHeader("authorization", ClientRestHelper.getAuthorization());
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            int code = httpResponse.getStatusLine().getStatusCode();
            logger.info("\u8bf7\u6c42\u7ed3\u679ccode:{}", (Object)code);
            if (code == 200) {
                HttpEntity httpEntity = httpResponse.getEntity();
                String resultJSON = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                logger.info("\u8bf7\u6c42\u7ed3\u679c:{}", (Object)resultJSON);
                EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                RestObject result = (RestObject)JSON.parseObject((String)resultJSON, RestObject.class);
                if (!result.getCode().equals("0001")) {
                    throw new ClientException(result.getMessage());
                }
                List list = JSON.parseArray((String)result.getRows(), resultClass);
                return list;
            }
            try {
                throw new ClientException("\u8bf7\u6c42" + url + "\u5931\u8d25,data:" + jsonData);
            }
            catch (Exception e) {
                throw new ClientException(e.getMessage(), e);
            }
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
        }
    }

    private static String getAuthorization() {
        if (StringUtils.isBlank((String)Constant.appId) || StringUtils.isBlank((String)Constant.appSecret)) {
            throw new ClientException("\u8bf7\u8bbe\u7f6eappId\u548cappSecret");
        }
        return AppAuth2.appAuth2Treaty(Constant.appId, Constant.appSecret);
    }

    public static String generateUrl(Object data) {
        if (data == null) {
            return "";
        }
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)data));
        Iterator it = jsonObject.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            try {
                Object value = entry.getValue();
                if (entry.getValue() != null) {
                    value = URLEncoder.encode(entry.getValue().toString(), "UTF-8");
                }
                sb.append("&").append((String)entry.getKey()).append("=").append(value);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.substring(1);
    }
}

