/*
 * Decompiled with CFR 0.152.
 */
package com.wu.yzg.app.sdk.util;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class RequestUtils {
    public static String getRemoteAddr(HttpServletRequest req) {
        String[] ips;
        String ip = req.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank((String)ip) && (ips = StringUtils.split((String)ip, (char)',')) != null) {
            for (String tmpip : ips) {
                if (StringUtils.isBlank((String)tmpip) || !RequestUtils.isIPAddr(tmpip = tmpip.trim()) || tmpip.startsWith("10.") || tmpip.startsWith("192.168.") || "127.0.0.1".equals(tmpip)) continue;
                return tmpip.trim();
            }
        }
        if (RequestUtils.isIPAddr(ip = req.getHeader("x-real-ip"))) {
            return ip;
        }
        ip = req.getRemoteAddr();
        if (ip.indexOf(46) == -1) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static boolean isRobot(HttpServletRequest req) {
        String ua = req.getHeader("user-agent");
        if (StringUtils.isBlank((String)ua)) {
            return false;
        }
        return ua != null && (ua.indexOf("Baiduspider") != -1 || ua.indexOf("Googlebot") != -1 || ua.indexOf("sogou") != -1 || ua.indexOf("sina") != -1 || ua.indexOf("iaskspider") != -1 || ua.indexOf("ia_archiver") != -1 || ua.indexOf("Sosospider") != -1 || ua.indexOf("YoudaoBot") != -1 || ua.indexOf("yahoo") != -1 || ua.indexOf("yodao") != -1 || ua.indexOf("MSNBot") != -1 || ua.indexOf("spider") != -1 || ua.indexOf("Twiceler") != -1 || ua.indexOf("Sosoimagespider") != -1 || ua.indexOf("naver.com/robots") != -1 || ua.indexOf("Nutch") != -1 || ua.indexOf("spider") != -1);
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie ck : cookies) {
            if (!StringUtils.equalsIgnoreCase((String)name, (String)ck.getName())) continue;
            return ck;
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie ck : cookies) {
            if (!StringUtils.equalsIgnoreCase((String)name, (String)ck.getName())) continue;
            return ck.getValue();
        }
        return null;
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge) {
        RequestUtils.setCookie(request, response, name, value, maxAge, true);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, boolean all_sub_domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String name, boolean all_sub_domain) {
        RequestUtils.setCookie(request, response, name, "", 0, all_sub_domain);
    }

    public static String getDomainOfServerName(String host) {
        if (RequestUtils.isIPAddr(host)) {
            return null;
        }
        String[] names = StringUtils.split((String)host, (char)'.');
        int len = names.length;
        if (len == 1) {
            return null;
        }
        if (len == 3) {
            return RequestUtils.makeup(names[len - 2], names[len - 1]);
        }
        if (len > 3) {
            String dp = names[len - 2];
            if (dp.equalsIgnoreCase("com") || dp.equalsIgnoreCase("gov") || dp.equalsIgnoreCase("net") || dp.equalsIgnoreCase("edu") || dp.equalsIgnoreCase("org")) {
                return RequestUtils.makeup(names[len - 3], names[len - 2], names[len - 1]);
            }
            return RequestUtils.makeup(names[len - 2], names[len - 1]);
        }
        return host;
    }

    public static boolean isIPAddr(String addr) {
        if (StringUtils.isEmpty((String)addr)) {
            return false;
        }
        String[] ips = StringUtils.split((String)addr, (char)'.');
        if (ips.length != 4) {
            return false;
        }
        try {
            int ipa = Integer.parseInt(ips[0]);
            int ipb = Integer.parseInt(ips[1]);
            int ipc = Integer.parseInt(ips[2]);
            int ipd = Integer.parseInt(ips[3]);
            return ipa >= 0 && ipa <= 255 && ipb >= 0 && ipb <= 255 && ipc >= 0 && ipc <= 255 && ipd >= 0 && ipd <= 255;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String makeup(String ... ps) {
        StringBuilder s = new StringBuilder();
        for (int idx = 0; idx < ps.length; ++idx) {
            if (idx > 0) {
                s.append('.');
            }
            s.append(ps[idx]);
        }
        return s.toString();
    }

    public static int getHttpPort(HttpServletRequest req) {
        try {
            return new URL(req.getRequestURL().toString()).getPort();
        }
        catch (MalformedURLException excp) {
            return 80;
        }
    }

    public static int getParam(HttpServletRequest req, String param, int defaultValue) {
        return NumberUtils.toInt((String)req.getParameter(param), (int)defaultValue);
    }

    public static long getParam(HttpServletRequest req, String param, long defaultValue) {
        return NumberUtils.toLong((String)req.getParameter(param), (long)defaultValue);
    }

    public static String getParam(HttpServletRequest req, String param, String defaultValue) {
        String value = req.getParameter(param);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }
}

