/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client.http.impl;

import com.alibaba.xxpt.gateway.shared.client.http.AbstractRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class PostRequest
extends AbstractRequest {
    private final HttpPost httpPost;
    private final List<NameValuePair> nameValues;

    private PostRequest(int timeout, URI uri, String version) {
        super(timeout, version);
        this.httpPost = new HttpPost(uri);
        this.nameValues = new ArrayList<NameValuePair>();
    }

    public static PostRequest newInstance(int timeout, URI uri, String version) {
        return new PostRequest(timeout, uri, version);
    }

    @Override
    protected HttpUriRequest newHttpRequest() {
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(this.nameValues, Consts.UTF_8);
        this.httpPost.setEntity((HttpEntity)entity);
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(super.getTimeout()).setConnectTimeout(super.getTimeout()).setConnectionRequestTimeout(super.getTimeout()).build();
        this.httpPost.setConfig(requestConfig);
        return this.httpPost;
    }

    public PostRequest addParameter(String name, String value) {
        if (this.isEmpty(value)) {
            return this;
        }
        this.nameValues.add((NameValuePair)new BasicNameValuePair(name, value));
        super.addSignParameter(name, value);
        return this;
    }

    public PostRequest addHeader(String name, String value) {
        if (this.isEmpty(value)) {
            return this;
        }
        this.httpPost.addHeader(name, value);
        return this;
    }

    @Override
    public String methodName() {
        return "POST";
    }

    public List<NameValuePair> getNameValues() {
        return this.nameValues;
    }
}

