/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.notify;

import com.gexin.fastjson.JSON;
import com.gexin.rp.sdk.dto.GtReq;
import java.util.LinkedList;
import java.util.List;

public class Notify {
    private String title;
    private String content;
    private String payload;
    private String intent;
    private String url;
    private Integer notifyId;
    private GtReq.NotifyInfo.Type type;
    private List<ExtKV> extKVList = new LinkedList<ExtKV>();

    public List<ExtKV> getExtKVList() {
        return this.extKVList;
    }

    public Notify addExtKVToAll(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.ALL));
        return this;
    }

    public Notify addHWExtKV(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.HW));
        return this;
    }

    public Notify addXMExtKV(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.XM));
        return this;
    }

    public Notify addMZExtKV(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.MZ));
        return this;
    }

    public Notify addOPExtKV(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.OP));
        return this;
    }

    public Notify addVVExtKV(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.VV));
        return this;
    }

    public Notify addFCMExtKV(String key, Object value) {
        this.extKVList.add(new ExtKV(key, value, ExtKV.PLATFORM_CONSTRAINS.FCM));
        return this;
    }

    public Integer getNotifyId() {
        return this.notifyId;
    }

    public void setNotifyId(Integer notifyId) {
        if (notifyId < 0) {
            throw new RuntimeException("notifyId need greater than 0");
        }
        this.notifyId = notifyId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getIntent() {
        return this.intent;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public GtReq.NotifyInfo.Type getType() {
        return this.type;
    }

    public void setType(GtReq.NotifyInfo.Type type) {
        this.type = type;
    }

    public static class ExtKV {
        private String key;
        private String value;
        private PLATFORM_CONSTRAINS constrains = PLATFORM_CONSTRAINS.ALL;

        public ExtKV(String key, Object value, PLATFORM_CONSTRAINS constrains) {
            this.key = key;
            this.value = JSON.toJSONString((Object)value);
            this.constrains = constrains;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public PLATFORM_CONSTRAINS getConstrains() {
            return this.constrains;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtKV extKV = (ExtKV)o;
            if (this.key != null ? !this.key.equals(extKV.key) : extKV.key != null) {
                return false;
            }
            if (this.value != null ? !this.value.equals(extKV.value) : extKV.value != null) {
                return false;
            }
            return this.constrains == extKV.constrains;
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.constrains != null ? this.constrains.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ExtKV{key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", constrains=" + (Object)((Object)this.constrains) + '}';
        }

        public static enum PLATFORM_CONSTRAINS {
            HW,
            XM,
            MZ,
            OP,
            VV,
            FCM,
            ALL,
            ST;

        }
    }
}

