/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.server.util;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearConverThreadUtil
extends Thread {
    private List<String> userIds;
    private static final Logger Log = LoggerFactory.getLogger(ClearConverThreadUtil.class);
    private static final String CONVERSATION_QUEUE = "conversation:queue";
    private static final String CONVERSATION_ITMES = "conversation:itmes:";
    private static final String CONVERSATION_RIGHT = "conversation:right:";
    private static final String CONVERSATION_TOP = "conversation:top:";

    public ClearConverThreadUtil(List<String> userIds) {
        this.userIds = userIds;
    }

    @Override
    public void run() {
        Log.info("start deleteConver userIds:{}", (Object)this.userIds.size());
        if (this.userIds != null && this.userIds.size() > 1) {
            for (int i = 0; i < this.userIds.size(); ++i) {
                this.deleteConv(this.userIds.get(i));
                this.deleteConvFromDb(this.userIds.get(i));
            }
        } else if (this.userIds != null && this.userIds.size() == 1) {
            this.deleteConv(this.userIds.get(0));
            this.deleteConvFromDb(this.userIds.get(0));
        }
        Log.info("end deleteConver userIds:{}", (Object)this.userIds.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConvFromDb(String userId) {
        Log.info("start deleteConvFromDb userId:{}", (Object)userId);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("update social_IMRecentConver set isdel = '1' where targetId like ? ");
            pstmt.setString(1, "%" + userId + "%");
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteConvFromDb,error:{},userId:{}", (Object)e.getMessage(), (Object)userId);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        Log.info("end deleteConvFromDb userId:{}", (Object)userId);
    }

    private void deleteConv(String userId) {
        Log.info("start redis delete conv :{}", (Object)userId);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        Set converSations = redisPoolMgr.Keys("conversation:itmes:*" + userId + "*");
        Log.info("this user has :{} converSations", (Object)converSations.size());
        for (String conver : converSations) {
            String[] s = null;
            if (conver != null && conver.contains(":")) {
                s = conver.split(":");
            }
            if (s == null || s.length != 4) continue;
            String userid = s[3];
            String targetId = s[2];
            this.deleteOFConversation(userid, targetId);
        }
        Log.info("end redis delete conv :{}", (Object)userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteOFConversation(String userid, String targetid) {
        Log.info("deleteOFConversation,userid:{},targetid:{}", (Object)userid, (Object)targetid);
        if (this.deleteOFConversationRedis(userid, targetid)) {
            return 1;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        long updatetime = new Date().getTime();
        int result = 0;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" update social_IMRecentConver set isdel = '1',updatetime=? where userid = ? and targetid = ? ");
            pstmt.setLong(1, updatetime);
            pstmt.setString(2, userid);
            pstmt.setString(3, targetid);
            result = pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error("deleteOFConversation,error.userid:{},targetid:{},error:{}", new Object[]{userid, targetid, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return result;
    }

    public boolean deleteOFConversationRedis(String userId, String targetId) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        boolean result = false;
        try {
            String key = this.getConversationItmesKeyHead(targetId) + userId;
            result = redisPoolMgr.hexists(key, "isdel");
            if (result) {
                redisPoolMgr.hset(key, "isdel", "1");
                redisPoolMgr.hset(key, "istop", "0");
                redisPoolMgr.zadd(this.getConversationRightKey(userId), System.currentTimeMillis(), key, 604800);
                redisPoolMgr.zadd(CONVERSATION_QUEUE, System.currentTimeMillis(), key, 604800);
            }
            redisPoolMgr.zrem(this.getConversationTopKey(userId), key);
        }
        catch (Exception e) {
            Log.error("ConversationRedisCacheUtil->deleteOFConversation: userid:{},targetid:{}, error:{}", new Object[]{userId, targetId, e.getMessage()});
        }
        return false;
    }

    private String getConversationRightKey(String userId) {
        return CONVERSATION_RIGHT + userId;
    }

    private String getConversationItmesKeyHead(String targetId) {
        return CONVERSATION_ITMES + targetId + ":";
    }

    private String getConversationTopKey(String userId) {
        return CONVERSATION_TOP + userId;
    }
}

