/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.server.util.TurnOverUser;
import com.weaver.util.ServerInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class ReductionUserGroupForTurnoverUtil {
    private static final Logger Log = LoggerFactory.getLogger(ReductionUserGroupForTurnoverUtil.class);

    public static void reductionUserGroupForTurnoverUtil(String userId) {
        String username = (userId + "|" + ServerInfo.SYSTEM_UDID).toLowerCase();
        List<TurnOverUser> list = ReductionUserGroupForTurnoverUtil.getTurnOverUserList(userId);
        for (TurnOverUser user : list) {
            ReductionUserGroupForTurnoverUtil.turnOverUser(username, user.getGroupId(), user.getIsManager(), user.getIsAdmin());
        }
    }

    private static void turnOverUser(String username, String groupId, String isManager, String isAdmin) {
        Group group = null;
        try {
            group = GroupManager.getInstance().getGroup(groupId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (group == null) {
            return;
        }
        if ("1".equals(isAdmin)) {
            ArrayList<JID> adminList = new ArrayList<JID>();
            for (JID adminuser : group.getAdmins()) {
                adminList.add(adminuser);
            }
            group.getMembers().remove(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            group.getAdmins().add(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            for (JID jid : adminList) {
                group.getAdmins().remove(jid);
                group.getMembers().add(jid);
            }
        } else {
            group.getMembers().add(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        }
        if ("1".equals(isManager)) {
            PersistableMap groupProp = group.getProperties();
            JSONArray groupManagerArray = null;
            if (groupProp != null && groupProp.containsKey((Object)"groupManagers")) {
                String groupManager = (String)groupProp.get((Object)"groupManagers");
                groupManagerArray = JSON.parseArray((String)groupManager);
            } else {
                groupManagerArray = new JSONArray();
            }
            if (groupManagerArray != null && !groupManagerArray.contains((Object)username)) {
                groupManagerArray.add((Object)username);
            }
            groupProp.put((Object)"groupManagers", (Object)groupManagerArray.toString().toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TurnOverUser> getTurnOverUserList(String userId) {
        ArrayList<TurnOverUser> list = new ArrayList<TurnOverUser>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select groupid,isUserAdmn,isUserMngr from ofturnover where userid = ? ");
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String groupId = rs.getString("groupid");
                String isUserAdmn = rs.getString("isUserAdmn");
                String isUserMngr = rs.getString("isUserMngr");
                TurnOverUser e = new TurnOverUser();
                e.setGroupId(groupId);
                e.setIsAdmin(isUserAdmn);
                e.setIsManager(isUserMngr);
                list.add(e);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getTurnOverUserList ,userId :{} ,errorMsg :{} ,e :{} ", new Object[]{userId, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }
}

