/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.server.util.PushDevice;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernameUtil {
    private static final Logger Log = LoggerFactory.getLogger(UsernameUtil.class);

    public static String getUserName(String user, String username) {
        String language = UsernameUtil.getLanguage(user);
        return UsernameUtil.formatMultiLang(username, language);
    }

    private static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    private static String formatMultiLang(String s, String lang) {
        if (lang == null || lang.isEmpty() || UsernameUtil.isInteger(lang)) {
            lang = "zh";
        }
        String langName = null;
        try {
            JSONObject json = JSON.parseObject((String)s);
            if (json != null) {
                Iterator iterator;
                if (json.containsKey((Object)lang)) {
                    langName = json.getString(lang);
                }
                if ((langName == null || langName.isEmpty()) && json.containsKey((Object)"en")) {
                    langName = json.getString("en");
                }
                if ((langName == null || langName.isEmpty()) && json.containsKey((Object)"zh")) {
                    langName = json.getString("zh");
                }
                if ((langName == null || langName.isEmpty()) && (iterator = json.keySet().iterator()).hasNext()) {
                    String key = (String)iterator.next();
                    langName = json.getString(key);
                }
            }
        }
        catch (Exception e) {
            langName = s;
        }
        return langName;
    }

    private static String getLanguage(String user) {
        PushDevice pd = UsernameUtil.get(user);
        if (pd == null) {
            return UsernameUtil.getFDB(user);
        }
        return pd.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFDB(String userid) {
        String language222;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block5: {
            String language222;
            con = null;
            pstmt = null;
            rs = null;
            String SELECT_OFPUSHDEVICE = "SELECT userid,devicetype,token,pushStatus,language,pushKitDeviceToken,mobileVersion,packageName from OFPUSHDEVICE where userid = ?";
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_OFPUSHDEVICE);
            pstmt.setString(1, userid);
            rs = pstmt.executeQuery();
            if (!rs.next()) break block5;
            String string = language222 = rs.getString("language");
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return string;
        }
        try {
            language222 = null;
        }
        catch (Exception e) {
            try {
                Log.error("getFDB,userId={},{},err={}", (Object)userid, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return null;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return language222;
    }

    private static PushDevice get(String key) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        String value = null;
        try {
            key = "push_device:" + key;
            value = redisPoolMgr.get(key);
        }
        catch (Exception e) {
            Log.error("get PushCacheUtil key : {} , error : {} ", (Object)key, (Object)e.getMessage());
            return null;
        }
        return UsernameUtil.getPushDevice(value);
    }

    private static PushDevice getPushDevice(String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        return (PushDevice)JSON.parseObject((String)json, PushDevice.class);
    }
}

