/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.cache;

import com.weaver.cache.redis.RedisPoolMgr;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceResourcesCacheUtil {
    private static final Logger Log = LoggerFactory.getLogger(DeviceResourcesCacheUtil.class);
    private static final String deviceResourcesCacheName = "Device Resources Cache";
    private static final String redisCacheKey = "device_resource_";
    private Cache<String, String> deviceResourcesCache = null;
    private static DeviceResourcesCacheUtil instance = null;
    private RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();

    private DeviceResourcesCacheUtil() {
        if (this.redisPoolMgr == null) {
            this.deviceResourcesCache = CacheFactory.createCache((String)deviceResourcesCacheName);
            Log.info("redis server not install. now user cache name is : {}", (Object)deviceResourcesCacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceResourcesCacheUtil getInstance() {
        if (instance != null) return instance;
        Class<DeviceResourcesCacheUtil> clazz = DeviceResourcesCacheUtil.class;
        synchronized (DeviceResourcesCacheUtil.class) {
            if (instance != null) return instance;
            instance = new DeviceResourcesCacheUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void put(String username, String resource, int expire) {
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheKey + username;
                this.redisPoolMgr.setex(key, resource, expire);
            } else {
                this.deviceResourcesCache.put((Object)username, (Object)resource);
            }
        }
        catch (Exception e) {
            Log.error("put resources  to cache or redis error.username:{},:{},error:{}", new Object[]{username, resource, e.getMessage()});
        }
    }

    public void remove(String username) {
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheKey + username;
                this.redisPoolMgr.del(key);
            } else {
                this.deviceResourcesCache.remove((Object)username);
            }
        }
        catch (Exception e) {
            Log.error("remove resources from cache or redis error.username:{},error:{}", (Object)username, (Object)e.getMessage());
        }
    }

    public String get(String username) {
        String resource = null;
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheKey + username;
                resource = this.redisPoolMgr.get(key);
            } else {
                resource = (String)this.deviceResourcesCache.get((Object)username);
            }
        }
        catch (Exception e) {
            Log.error("get resources from cache or redis error.username :{},error:{}", (Object)username, (Object)e.getMessage());
        }
        return resource != null ? resource : "";
    }
}

