/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(FileDownloadServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        String os = System.getProperty("os.name");
        String fileSaveRootPath = "./../../../work/logs/openfirelog/";
        String zipName = null;
        String zipFilePath = null;
        BufferedInputStream bis = null;
        ZipOutputStream zipOutput = null;
        byte[] buffer = new byte[]{};
        int read = 0;
        try {
            zipName = "emessage.zip";
            zipFilePath = fileSaveRootPath + zipName;
            bis = null;
            zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFilePath)));
            buffer = new byte[1024];
            read = 0;
            File sourceFile = new File(fileSaveRootPath);
            File[] listFiles = sourceFile.listFiles();
            if (null != listFiles && 0 != listFiles.length) {
                for (File f : listFiles) {
                    if (f.getName().equals(zipName)) continue;
                    ZipEntry zEntry = new ZipEntry(f.getName());
                    zipOutput.putNextEntry(zEntry);
                    bis = new BufferedInputStream(new FileInputStream(f));
                    while ((read = bis.read(buffer)) != -1) {
                        zipOutput.write(buffer, 0, read);
                    }
                }
            }
        }
        catch (IOException e) {
            Log.error("log zip zipFile input error, failed");
        }
        finally {
            if (null != bis) {
                bis.close();
            }
            if (null != zipOutput) {
                zipOutput.close();
            }
        }
        try (ServletOutputStream out = response.getOutputStream();
             FileInputStream in = new FileInputStream(new File(zipFilePath));){
            response.setHeader("Content-Type", "application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(zipName, "UTF-8"));
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            Log.error("log zip zipFile output error, failed");
        }
        finally {
            try {
                File zfile = new File(zipFilePath);
                zfile.delete();
            }
            catch (Exception e) {
                Log.error("delete log zip zipFile failed");
            }
        }
    }
}

