/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import com.alibaba.fastjson.JSON;
import com.weaver.util.SecurityUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.servlet.ServerPlugin;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessAddGroupUsers;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessAddRobot;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessChangeGroupName;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessCheckSecret;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessCheckServerNetworkStatus;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessCreateGroup;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessDelRobot;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessDeleteOfGroup;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessGetDeviceOnLine;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessGetServerInfo;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessGetToken;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessKillUserOffline;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessModifyNameOfUser;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessPublishDingMessage;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessPublishGroupMessage;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessPublishMessage;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessPushSet;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessQueryGroupUserList;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessSetGroupIcon;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessSetMessageWithdrawTime;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessSetMsgProperties;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessSetNoConverApplication;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessTurnover;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessUnregister;
import org.jivesoftware.openfire.plugin.servlet.strategy.ProcessUpdateRobot;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.plugin.util.CodeUtil;
import org.jivesoftware.openfire.plugin.util.GetRequestAddress;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(HttpServiceServlet.class);
    ExecutorService fixedThreadPool = ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool();
    private String uuid = null;
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();
    private static Map<String, ServletStrategy> handlerMap = new HashMap<String, ServletStrategy>();

    public void destroy() {
        super.destroy();
    }

    private void printRequest(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nHeader\n");
        Enumeration headerReqName = request.getHeaderNames();
        while (headerReqName.hasMoreElements()) {
            String name = (String)headerReqName.nextElement();
            String value = request.getHeader(name);
            sb.append(name + " => " + value + "\n");
        }
        sb.append("Parameter\n");
        Enumeration reqName = request.getParameterNames();
        while (reqName.hasMoreElements()) {
            String name = (String)reqName.nextElement();
            String value = request.getParameter(name);
            sb.append(name + " => " + value + "\n");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String method = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("method"), (CharSequence)"");
            Map<String, Object> result = new HashMap<String, Object>();
            HashMap<String, String> data = new HashMap<String, String>();
            String requestIp = GetRequestAddress.getIpAdrress(request);
            Long startTime = System.currentTimeMillis();
            if (method.equals("joinUp")) {
                String adminPassword;
                String emServerUrl;
                String adminPasswordParam = StringUtils.defaultString((String)request.getHeader("password"), (String)"");
                String customerId = request.getParameter("customerId");
                String customerName = request.getParameter("customerName");
                if (customerName != null && !customerName.isEmpty() && customerId != null && !customerId.isEmpty()) {
                    SecurityUtil.saveOfCustomerInfo((String)customerId, (String)customerName);
                }
                if ((emServerUrl = request.getParameter("emServerUrl")) != null && !emServerUrl.isEmpty()) {
                    JiveGlobals.setProperty((String)"emServerUrl", (String)emServerUrl);
                }
                if (!adminPasswordParam.equals(HttpServiceServlet.getMD5String(adminPassword = AuthFactory.getPassword((String)"admin")))) {
                    if (JiveGlobals.getBooleanProperty((String)"password-default", (boolean)false)) {
                        result.put("error", "auth error");
                        result.put("errcode", 403);
                        result.put("errormsg", "\u6d88\u606f\u670d\u52a1\u5bc6\u7801\u9519\u8bef,\u9ed8\u8ba4\u5bc6\u7801\u5728emp/msgsvr/openfire/conf/defaultPassword.txt");
                    } else {
                        result.put("error", "auth error");
                        result.put("errcode", 403);
                        result.put("errormsg", "\u6d88\u606f\u670d\u52a1\u5bc6\u7801\u9519\u8bef");
                    }
                } else {
                    result.put("secret", ServerInfo.SYSTEM_SECRET);
                    result.put("udid", ServerInfo.SYSTEM_UDID);
                    result.put("errcode", 0);
                    String msgDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
                    result.put("msgDomain", msgDomain);
                }
            } else {
                ServerPlugin sp = ServerPlugin.serverPlugin;
                String weaversecret = sp.getSecrect();
                String udid = StringUtils.defaultString((String)request.getHeader("udid"), (String)"");
                String timestamp = request.getHeader("timestamp");
                String sign = request.getHeader("sign");
                StringBuilder toSign = new StringBuilder(weaversecret).append(udid).append(timestamp);
                String signtemp = CodeUtil.hexSHA1(toSign.toString());
                if (!signtemp.equals(sign)) {
                    data.put("error", "authentic error");
                } else if (!"".equals(method)) {
                    ServletStrategy servletStrategy = handlerMap.get(method);
                    if (null != servletStrategy) {
                        result = servletStrategy.process(result, request, requestIp, this.fixedThreadPool);
                    } else {
                        result.put("status", 0);
                        response.sendError(404, "method not found.");
                    }
                }
            }
            String str = JSON.toJSONString(result);
            Long endTime = System.currentTimeMillis();
            Log.info("doGet,method:{},requestIp:{},result:{},costTime : {} ms", new Object[]{method, requestIp, str, endTime - startTime});
            response.getOutputStream().write(str.getBytes("UTF-8"));
            response.setContentType("text/json; charset=UTF-8");
        }
        catch (Exception e) {
            Log.error("doGet,request={},error={}", (Object)JSON.toJSONString((Object)request.getParameterMap()).toString(), (Object)e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
    }

    public static void main(String[] args) {
        System.out.println(HttpServiceServlet.getMD5String("qrcb_xtbgqrcb6735572bcc184ad982455da1b940ea91OX2vpFnsV"));
    }

    private static String getMD5String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        handlerMap.put("checkSecret", new ProcessCheckSecret());
        handlerMap.put("getToken", new ProcessGetToken());
        handlerMap.put("publishMessage", new ProcessPublishMessage());
        handlerMap.put("publishGroupMessage", new ProcessPublishGroupMessage());
        handlerMap.put("createGroup", new ProcessCreateGroup());
        handlerMap.put("deleteOfGroup", new ProcessDeleteOfGroup());
        handlerMap.put("addGroupUsers", new ProcessAddGroupUsers());
        handlerMap.put("changeGroupName", new ProcessChangeGroupName());
        handlerMap.put("checkServerNetworkStatus", new ProcessCheckServerNetworkStatus());
        handlerMap.put("getDeviceOnLine", new ProcessGetDeviceOnLine());
        handlerMap.put("modifyNameOfUser", new ProcessModifyNameOfUser());
        handlerMap.put("publishDingMessage", new ProcessPublishDingMessage());
        handlerMap.put("pushSet", new ProcessPushSet());
        handlerMap.put("queryGroupUserList", new ProcessQueryGroupUserList());
        handlerMap.put("setGroupIcon", new ProcessSetGroupIcon());
        handlerMap.put("turnover", new ProcessTurnover());
        handlerMap.put("unregister", new ProcessUnregister());
        handlerMap.put("killUserOffline", new ProcessKillUserOffline());
        handlerMap.put("getServerInfo", new ProcessGetServerInfo());
        handlerMap.put("setWithdrawTime", new ProcessSetMessageWithdrawTime());
        handlerMap.put("setMsgProperties", new ProcessSetMsgProperties());
        handlerMap.put("addrobot", new ProcessAddRobot());
        handlerMap.put("updaterobot", new ProcessUpdateRobot());
        handlerMap.put("delrobot", new ProcessDelRobot());
        handlerMap.put("setNoConverApplication", new ProcessSetNoConverApplication());
    }
}

