/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import com.alibaba.fastjson.JSON;
import com.weaver.util.ServerCheckUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.openfire.plugin.util.DBUtil;
import org.jivesoftware.openfire.plugin.util.HttpProxyForPush;
import org.jivesoftware.openfire.security.SecurityAuditManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(PushServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecurityAuditManager sa = SecurityAuditManager.getInstance();
            String type = req.getParameter("type");
            type = StringUtils.escapeHTMLTags((String)type);
            if ("save".equals(type)) {
                String appKey = req.getParameter("appKey");
                String secret = req.getParameter("secret");
                appKey = StringUtils.escapeHTMLTags((String)appKey);
                secret = StringUtils.escapeHTMLTags((String)secret);
                JiveGlobals.setProperty((String)"jpushAppKey", (String)appKey);
                JiveGlobals.setProperty((String)"jpushSecret", (String)secret);
                result.put("result", true);
                sa.logEvent("admin", "save appKey and secret: ", "[" + appKey + "] [" + secret + "]ip [" + req.getRemoteAddr() + "]");
            } else if ("pushSet".equals(type)) {
                String pushSet = req.getParameter("pushSet");
                pushSet = StringUtils.escapeHTMLTags((String)pushSet);
                JiveGlobals.setProperty((String)"pushSet", (String)pushSet);
                result.put("result", true);
                sa.logEvent("admin", "set pushSet: " + pushSet, req.getRemoteAddr());
            } else if ("pushStatus".equals(type)) {
                String pushStatus = req.getParameter("pushStatus");
                if ("true".equals(pushStatus = StringUtils.escapeHTMLTags((String)pushStatus))) {
                    JiveGlobals.setProperty((String)"pushStatus", (String)"0");
                } else if ("false".equals(pushStatus)) {
                    JiveGlobals.setProperty((String)"pushStatus", (String)"1");
                }
                result.put("result", true);
                sa.logEvent("admin", "set pushStatus", pushStatus + "ip [" + req.getRemoteAddr() + "]");
            } else if ("pushKitSecret".equals(type)) {
                String pushKitSecret = req.getParameter("pushKitSecret");
                pushKitSecret = StringUtils.escapeHTMLTags((String)pushKitSecret);
                JiveGlobals.setProperty((String)"pushKitSecret", (String)(pushKitSecret + "ip [" + req.getRemoteAddr() + "]"));
                result.put("result", true);
                sa.logEvent("admin", "set pushKitSecret: ", pushKitSecret);
            } else if ("saveNetPushProxy".equals(type)) {
                String userProxy = req.getParameter("userProxy");
                String proxyHost = req.getParameter("proxyHost");
                String proxyPort = req.getParameter("proxyPort");
                String propxyNeedAuth = req.getParameter("propxyNeedAuth");
                String proxyUsername = req.getParameter("proxyUsername");
                String proxyPassword = req.getParameter("proxyPassword");
                userProxy = StringUtils.escapeHTMLTags((String)userProxy);
                proxyHost = StringUtils.escapeHTMLTags((String)proxyHost);
                proxyPort = StringUtils.escapeHTMLTags((String)proxyPort);
                propxyNeedAuth = StringUtils.escapeHTMLTags((String)propxyNeedAuth);
                proxyUsername = StringUtils.escapeHTMLTags((String)proxyUsername);
                proxyPassword = StringUtils.escapeHTMLTags((String)proxyPassword);
                HttpProxyForPush hpfp = HttpProxyForPush.getInstance();
                if ("true".equals(userProxy)) {
                    if (proxyHost != null && !proxyHost.isEmpty() && proxyPort != null && !proxyPort.isEmpty()) {
                        hpfp.setUserProxy(Boolean.valueOf(userProxy));
                        hpfp.setProxyHost(proxyHost);
                        hpfp.setProxyPort(Integer.parseInt(proxyPort));
                        if ("true".equals(propxyNeedAuth)) {
                            if (proxyUsername != null && !proxyUsername.isEmpty() && proxyPassword != null && !proxyPassword.isEmpty()) {
                                hpfp.setPropxyNeedAuth(Boolean.valueOf(propxyNeedAuth));
                                hpfp.setProxyUsername(proxyUsername);
                                hpfp.setProxyPassword(proxyPassword);
                            }
                        } else {
                            hpfp.setPropxyNeedAuth(Boolean.valueOf(propxyNeedAuth));
                        }
                    }
                } else {
                    hpfp.setUserProxy(Boolean.valueOf(userProxy));
                    if ("false".equals(propxyNeedAuth)) {
                        hpfp.setPropxyNeedAuth(Boolean.valueOf(propxyNeedAuth));
                    }
                }
                result.put("code", 200);
                JiveGlobals.setProperty((String)"httpProxyForPushUpdate", (String)String.valueOf(System.currentTimeMillis()));
                sa.logEvent("admin", "saveNetPushProxy", "[" + userProxy + "][" + proxyHost + "][" + proxyPort + "][" + propxyNeedAuth + "][" + proxyUsername + "][" + proxyPassword + "]ip [" + req.getRemoteAddr() + "]");
            } else if (type.equals("setUserUnifiedPush")) {
                String isUserUnifiedPush = req.getParameter("isUserUnifiedPush");
                String isUserUnifiedPushValue = req.getParameter("isUserUnifiedPushValue");
                isUserUnifiedPush = StringUtils.escapeHTMLTags((String)isUserUnifiedPush);
                isUserUnifiedPushValue = StringUtils.escapeHTMLTags((String)isUserUnifiedPushValue);
                if ("true".equals(isUserUnifiedPush) || "false".equals(isUserUnifiedPush) || "1".equals(isUserUnifiedPush) || "2".equals(isUserUnifiedPush)) {
                    JiveGlobals.setProperty((String)"isUserUnifiedPush", (String)isUserUnifiedPush);
                }
                if (isUserUnifiedPushValue != null && !isUserUnifiedPushValue.isEmpty()) {
                    JiveGlobals.setProperty((String)"isUserUnifiedPushValue", (String)isUserUnifiedPushValue);
                }
                result.put("isUserUnifiedPushValue", isUserUnifiedPushValue);
                result.put("isUserUnifiedPush", isUserUnifiedPush);
                result.put("result", true);
                sa.logEvent("admin", "set isUserUnifiedPush", "[" + isUserUnifiedPush + "][" + isUserUnifiedPushValue + "]ip [" + req.getRemoteAddr() + "]");
            } else if ("savePushInfo".equals(type)) {
                String appName;
                String packagename = req.getParameter("packagename");
                if (packagename != null) {
                    packagename = packagename.trim();
                }
                if ((appName = req.getParameter("appName")) != null) {
                    appName = appName.trim();
                }
                packagename = StringUtils.escapeHTMLTags((String)packagename);
                appName = StringUtils.escapeHTMLTags((String)appName);
                if (packagename == null || packagename.isEmpty() || appName == null || appName.isEmpty()) {
                    Log.warn("savePushInfo .appName or packagename is null ,packagename:{},appName:{}", (Object)packagename, (Object)appName);
                    result.put("code", "404");
                } else {
                    DBUtil.savaPushInfo(packagename, appName);
                    sa.logEvent("admin", "savePushInfo", "[" + packagename + "][" + appName + "]ip [" + req.getRemoteAddr() + "]");
                }
            } else if ("deletePushInfo".equals(type)) {
                String packagename = req.getParameter("packagename");
                packagename = StringUtils.escapeHTMLTags((String)packagename);
                DBUtil.deletePushInfo(packagename);
                sa.logEvent("admin", "deletePushInfo", "[" + packagename + "]ip [" + req.getRemoteAddr() + "]");
            } else if ("clearMsgError".equals(type)) {
                ServerCheckUtil.clearHistoryMsgERROR();
                sa.logEvent("admin", "\u5220\u9664\u6d88\u606f\u5165\u5e93\u5931\u8d25\u8bb0\u5f55", "ip [" + req.getRemoteAddr() + "]");
            }
        }
        catch (Exception e) {
            result.put("result", false);
            Log.error("doGet,error:{}", (Object)e.getMessage());
        }
        String jsonStr = JSON.toJSONString(result).toString();
        if (jsonStr != null && !"".equals(jsonStr)) {
            resp.setContentType("application/json; charset=utf-8");
            resp.getOutputStream().write(jsonStr.getBytes("UTF-8"));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }
}

