/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.UUID;
import org.jivesoftware.admin.AuthCheckFilter;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.bean.ActionMessage;
import org.jivesoftware.openfire.plugin.bean.RongGroup;
import org.jivesoftware.openfire.plugin.cache.DeviceResourcesCacheUtil;
import org.jivesoftware.openfire.plugin.util.ActionType;
import org.jivesoftware.openfire.plugin.util.InitUsersThread;
import org.jivesoftware.openfire.plugin.util.OldGroupInitThread;
import org.jivesoftware.openfire.plugin.util.SyncUsersTimerTask;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.PresenceEventDispatcher;
import org.jivesoftware.openfire.user.PresenceEventListener;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class ServerPlugin
implements Plugin,
Component,
PresenceEventListener {
    private static final Logger Log = LoggerFactory.getLogger(ServerPlugin.class);
    public static ServerPlugin serverPlugin;
    public String serviceName = "serverapi";
    private PluginManager pluginManager;
    private ComponentManager componentManager;
    private GroupManager groupManager;
    private UserManager userManager;
    private Timer timer;
    SyncUsersTimerTask sutk = null;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        Log.info("--group--initializePlugin--starting...");
        serverPlugin = this;
        this.pluginManager = manager;
        this.componentManager = ComponentManagerFactory.getComponentManager();
        try {
            this.componentManager.addComponent(this.serviceName, (Component)this);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.groupManager = GroupManager.getInstance();
        this.userManager = UserManager.getInstance();
        this.timer = new Timer();
        this.genaraSecrect();
        ServerInfo.SYSTEM_UDID = this.getOriginalUDID();
        ServerInfo.SYSTEM_CID = this.getOriginalCID();
        AuthCheckFilter.addExclude((String)"server/httpservice/api");
        PresenceEventDispatcher.addListener((PresenceEventListener)this);
        Log.info("server plugin init end ");
    }

    private Date getTimerStartTime() {
        int time = new Random().nextInt(100);
        return new Date(ServerPlugin.getTimeofToday() + 93600000L + (long)(time * 1000));
    }

    private static long getTimeofToday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    public void destroyPlugin() {
        if (this.componentManager != null) {
            try {
                this.componentManager.removeComponent(this.serviceName);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.groupManager = null;
        this.userManager = null;
        this.sutk.cancel();
        PresenceEventDispatcher.removeListener((PresenceEventListener)this);
        AuthCheckFilter.removeExclude((String)"server/resetadminpassword");
    }

    public String getDescription() {
        return this.pluginManager.getDescription((Plugin)this);
    }

    public String getName() {
        return this.pluginManager.getName((Plugin)this);
    }

    public void initialize(JID arg0, ComponentManager arg1) throws ComponentException {
    }

    public void processPacket(Packet packet) {
        if (packet instanceof Message) {
            Message message = (Message)packet;
            this.processMessage(message);
        }
    }

    public void shutdown() {
    }

    public void start() {
    }

    private void processMessage(Message message) {
    }

    public void sendMessage(Message message) {
        String toUsername = message.getTo().getNode();
        try {
            User user = this.userManager.getUser(toUsername);
            message.setTo(new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            this.componentManager.sendPacket((Component)this, (Packet)message);
        }
        catch (ComponentException e) {
            Log.error("sendMessage,message={},error={}", (Object)message.toString(), (Object)e.getMessage());
        }
        catch (UserNotFoundException e1) {
            Log.error("sendMessage,user not found.username={},message={}", (Object)toUsername, (Object)message.toString());
        }
    }

    public void sendMessageToGroup(Message message) {
        try {
            this.componentManager.sendPacket((Component)this, (Packet)message);
        }
        catch (ComponentException e) {
            Log.error("sendMessageToGroup,message={},error={}", (Object)message.toString(), (Object)e.getMessage());
        }
    }

    public void recreateGroup(String groupName, String description, List<String> users, String adminuserid) {
        try {
            if (users.size() == 0) {
                return;
            }
            Group group = this.groupManager.createGroup(groupName, description);
            for (String username : users) {
                try {
                    User user = this.userManager.getUser(username = username.toLowerCase());
                    if (user == null) continue;
                    boolean addflag = group.getMembers().add(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    Log.debug("recreateGroup ,addMembers ok,username={},groupName={},addflag={}", new Object[]{username, groupName, addflag});
                }
                catch (UserNotFoundException e) {
                    Log.error("recreateGroup,addMembers error,username={},error={}", (Object)username, (Object)e.getMessage());
                }
            }
            if (adminuserid != null && adminuserid.length() > 0) {
                group.getAdmins().clear();
                boolean addflag = group.getAdmins().add(new JID(adminuserid.toLowerCase(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                Log.debug("recreateGroup ,addAdmins ok,username={},groupName={},addflag={}", new Object[]{adminuserid.toLowerCase(), groupName, addflag});
            } else if (users.size() > 0) {
                group.getMembers().remove(new JID(users.get(0).toLowerCase(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                group.getAdmins().clear();
                boolean addflag = group.getAdmins().add(new JID(users.get(0).toLowerCase(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                Log.debug("recreateGroup ,add Default Admins ok,username={},groupName={},addflag={}", new Object[]{users.get(0).toLowerCase(), groupName, addflag});
            }
        }
        catch (GroupAlreadyExistsException e) {
            Log.error("recreateGroup error,groupName={},description ={},users={},adminuserid={},error={}", new Object[]{groupName, description, users, adminuserid, e.getMessage()});
            return;
        }
    }

    public void createGroup(String groupName, String description, List<String> users, String isDisableMsgRead, String isDisableAddUser, List<String> members) {
        try {
            Object groupPropMap;
            if (members == null) {
                members = new ArrayList<String>();
            }
            if (users.size() == 0) {
                Log.warn("createGroup ,no attached username, no create group:{}", (Object)groupName);
                return;
            }
            Group group = this.groupManager.createGroup(groupName, description);
            if ("true".equals(isDisableMsgRead)) {
                groupPropMap = group.getProperties();
                groupPropMap.put((Object)"isDisableMsgRead", (Object)"true");
            }
            if ("true".equals(isDisableAddUser)) {
                groupPropMap = group.getProperties();
                groupPropMap.put((Object)"isDisableAddUser", (Object)"true");
            }
            for (String username : users) {
                try {
                    User user = this.userManager.getUser(username = username.toLowerCase());
                    if (user == null) continue;
                    boolean addflag = group.getMembers().add(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    Log.debug("createGroup ,add attached username={}, addflag={}", (Object)username, (Object)addflag);
                }
                catch (UserNotFoundException e) {
                    Log.error("createGroup,user not found.username={}", (Object)username);
                }
            }
            boolean addflag = group.getAdmins().add(new JID(users.get(0).toLowerCase(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            Log.debug("createGroup ,add admin username={}, addflag={}", (Object)users.get(0).toLowerCase(), (Object)addflag);
        }
        catch (GroupAlreadyExistsException e) {
            Log.error("createGroup,group is exist:{}", (Object)groupName);
        }
    }

    public void deleteGroup(JID fromJID, String groupId, String needSendMsg) {
        Group group = null;
        User user = null;
        try {
            group = this.groupManager.getGroup(groupId);
            user = this.userManager.getUser(fromJID.getNode());
        }
        catch (GroupNotFoundException e) {
            Log.error("deleteGroup.fromJID :{} .groupID:{}.group is not found .", (Object)fromJID.toString(), (Object)groupId);
            return;
        }
        catch (UserNotFoundException e) {
            Log.error("deleteGroup .fromJID :{} .groupID :{} .user is not found .", (Object)fromJID.toString(), (Object)groupId);
        }
        PersistableMap groupPropMap = group.getProperties();
        groupPropMap.put((Object)"deleteGroup", (Object)"true");
        groupPropMap.put((Object)"dissolution_time", (Object)String.valueOf(System.currentTimeMillis()));
        if ("true".equalsIgnoreCase(needSendMsg)) {
            final Group grouptemp = group;
            final User usertemp = user;
            String extensiontemp = "deleteGroup";
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    ActionMessage diz = new ActionMessage(10, usertemp.getUID(), "deleteGroup");
                    infoMessage.setBody(diz.toString());
                    Log.info("deleteGroup for admin infoMessage:{}", (Object)infoMessage.toString());
                    ServerPlugin sp = serverPlugin;
                    sp.sendMessageToGroup(infoMessage);
                    try {
                        Collection admins = grouptemp.getAdmins();
                        Collection members = grouptemp.getMembers();
                        ArrayList<JID> adminsList = new ArrayList<JID>();
                        for (JID jid : admins) {
                            adminsList.add(jid);
                        }
                        ArrayList<JID> membersList = new ArrayList<JID>();
                        for (JID jid : members) {
                            membersList.add(jid);
                        }
                        for (JID jid : adminsList) {
                            grouptemp.getAdmins().remove(jid);
                        }
                        for (JID jid : membersList) {
                            grouptemp.getMembers().remove(jid);
                        }
                    }
                    catch (Exception e) {
                        Log.error("delete Group.delete groupMembers error:{},groupId:{}", (Object)e.getMessage(), (Object)grouptemp.getName());
                    }
                }
            });
        } else {
            try {
                Collection admins = group.getAdmins();
                Collection members = group.getMembers();
                ArrayList<JID> adminsList = new ArrayList<JID>();
                for (JID jid : admins) {
                    adminsList.add(jid);
                }
                ArrayList<JID> membersList = new ArrayList<JID>();
                for (JID jid : members) {
                    membersList.add(jid);
                }
                for (JID jid : adminsList) {
                    group.getAdmins().remove(jid);
                }
                for (JID jid : membersList) {
                    group.getMembers().remove(jid);
                }
            }
            catch (Exception e) {
                Log.error("delete Group.delete groupMembers error:{},groupId:{}", (Object)e.getMessage(), (Object)group.getName());
            }
        }
    }

    public void addGroupUsers(String groupName, List<String> users, String needSendMsg, String fromUserId) {
        try {
            Group group = this.groupManager.getGroup(groupName);
            ArrayList<String> addUserList = new ArrayList<String>();
            for (String username : users) {
                try {
                    User user = this.userManager.getUser(username = username.toLowerCase());
                    if (user == null) continue;
                    Collection groupMembers = group.getMembers();
                    Collection groupAdmins = group.getAdmins();
                    JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    if (groupMembers == null || groupMembers.contains(jid) || groupAdmins.contains(jid)) continue;
                    group.getMembers().add(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    addUserList.add(username);
                }
                catch (UserNotFoundException e) {
                    Log.error("addGroupUsers failed. user is not found.username={}", (Object)username);
                }
            }
            if ("true".equalsIgnoreCase(needSendMsg) && addUserList.size() > 0) {
                this.sendMessageToGroup(groupName, fromUserId, addUserList, ActionType.ActionInviteUser);
            }
        }
        catch (GroupNotFoundException e) {
            Log.error("addGroupUsers,group is not found.group={}", (Object)groupName);
        }
    }

    public void deleteGroupUsers(String groupName, List<String> users, String needSendMsg, String fromUserId) {
        try {
            Group group = this.groupManager.getGroup(groupName);
            Log.debug("deleteGroupUsers, group:{} user cnt:{}", (Object)groupName, (Object)group.getMembers().size());
            ArrayList<String> removeUserList = new ArrayList<String>();
            for (String username : users) {
                try {
                    username = username.toLowerCase();
                    User user = this.userManager.getUser(username);
                    if (user != null) {
                        Collection groupMembers = group.getMembers();
                        Collection groupAdmins = group.getAdmins();
                        JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                        if (groupMembers == null || !groupMembers.contains(jid) && !groupAdmins.contains(jid)) continue;
                        removeUserList.add(username);
                        continue;
                    }
                    Log.warn("deleteGroupUsers, user not found, user name:{}", (Object)username);
                }
                catch (UserNotFoundException e) {
                    Log.error("deleteGroupUsers,user is not found.username:{}", (Object)username);
                }
            }
            if ("true".equalsIgnoreCase(needSendMsg) && removeUserList.size() > 0) {
                this.sendMessageToGroup(groupName, fromUserId, removeUserList, ActionType.ActionDeleteUser);
            }
            if (removeUserList.size() > 0) {
                Iterator<String> iterator = removeUserList.iterator();
                while (iterator.hasNext()) {
                    String username;
                    username = iterator.next();
                    group.getMembers().remove(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                }
                if (group.getAdmins().size() == 0 && group.getMembers().size() > 0 && (iterator = group.getMembers().iterator()).hasNext()) {
                    JID memJid = (JID)iterator.next();
                    group.getMembers().remove(memJid);
                    group.getAdmins().add(memJid);
                }
            }
            Log.debug("deleteGroupUsers, done group:{} user cnt:{}", (Object)groupName, (Object)group.getMembers().size());
        }
        catch (GroupNotFoundException e) {
            Log.error("deleteGroupUsers .group is not found.group:{}", (Object)groupName);
        }
    }

    public void changeGroupName(String groupName, String description) {
        try {
            Group group = this.groupManager.getGroup(groupName);
            group.setDescription(description);
        }
        catch (GroupNotFoundException e) {
            Log.error("changerGroupName,group is not found.group:{}", (Object)groupName);
        }
    }

    public List<String> queryGroupUserList(String groupName) {
        List<String> userList = null;
        try {
            Group group = this.groupManager.getGroup(groupName);
            Collection users = group.getAll();
            userList = new ArrayList<String>(users.size());
            for (JID jid : users) {
                if (jid == null) {
                    Log.warn("queryGroupUserList, jid is null, skip user. group name:{}", (Object)groupName);
                    continue;
                }
                Log.debug("queryGroupUserList, add one username:{}", (Object)jid.getNode());
                String uid = this.getUidFromJID(jid);
                if (!"".equals(uid) && uid != null) {
                    userList.add(uid);
                    continue;
                }
                Log.warn("queryGroupUserList, uid is empty, skip user. group name:{}", (Object)groupName);
            }
        }
        catch (GroupNotFoundException e) {
            Log.error("queryGroupUserList,group is not found.group:{}", (Object)groupName);
            userList = Collections.emptyList();
        }
        return userList;
    }

    private String getUidFromJID(JID jid) {
        String jidStr = jid.getNode();
        if (jidStr.startsWith("push|")) {
            return "-1";
        }
        int i = jidStr.indexOf("|");
        if (i > 0) {
            return jidStr.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return jidStr;
    }

    public void genaraSecrect() {
        String serverSecret = JiveGlobals.getProperty((String)"serverSecret");
        if (serverSecret == null || serverSecret.equals("")) {
            serverSecret = StringUtils.randomString((int)8);
            JiveGlobals.setProperty((String)"serverSecret", (String)serverSecret);
        }
        ServerInfo.SYSTEM_SECRET = serverSecret;
    }

    public String getSecrect() {
        return JiveGlobals.getProperty((String)"serverSecret");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getUDID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue.toLowerCase();
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = WeaverStringUtil.getRandomLowercase(6);
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "rongAppUDIDNew");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID.toLowerCase();
            }
            catch (Exception e) {
                try {
                    ServerPlugin.Log.error("getUDID,error={}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getOriginalCID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='systemcid'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue.toLowerCase();
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = UUID.randomUUID().toString();
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "systemcid");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID;
            }
            catch (Exception e) {
                try {
                    ServerPlugin.Log.error("getUDID,error={}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getOriginalUDID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue.toLowerCase();
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = WeaverStringUtil.getRandomLowercase(1);
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "rongAppUDIDNew");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID;
            }
            catch (Exception e) {
                try {
                    ServerPlugin.Log.error("getUDID,error={}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initUsersMethod() {
        Log.info("server plugin initUsers start");
        boolean initUsers = JiveGlobals.getBooleanProperty((String)"initUsers");
        if (initUsers) {
            Log.info("initUsers is true not need to initUsers");
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select count(*) as userCount from  HrmResource");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer userCount = Integer.parseInt(rs.getString("userCount"));
                if (userCount == null || userCount <= 0) continue;
                InitUsersThread initUsersThread = new InitUsersThread(userCount);
                initUsersThread.run();
            }
        }
        catch (SQLException e) {
            try {
                Log.error("initUsersMethod,error:{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return;
    }

    private void oldGroupInit() {
        boolean oldGroupIsInit = JiveGlobals.getBooleanProperty((String)"oldGroupIsInit");
        if (!oldGroupIsInit) {
            int oldGroupCount = this.getOldGroupCount();
            if (oldGroupCount > 0) {
                OldGroupInitThread oldGroupInitThread = new OldGroupInitThread(oldGroupCount);
                oldGroupInitThread.run();
            }
            JiveGlobals.setProperty((String)"oldGroupIsInit", (String)"true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOldGroupCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block4: {
            int n;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" select count(*) as oldGroupCount from social_allgroupinfos ");
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                n = Integer.parseInt(rs.getString("oldGroupCount"));
            }
            catch (SQLException e) {
                try {
                    Log.error("server plugin getOldGroupCount exception, err:{}", (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return n;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return 0;
    }

    private void sendMessageToGroup(String groupName, String fromUid, List<String> uidList, ActionType actionType) {
        ServerPlugin sp = serverPlugin;
        String msgid = StringUtils.randomString((int)8);
        String extension = null;
        extension = ActionType.ActionRenameGroup == actionType ? uidList.get(0) : this.makeExtension(uidList);
        Message infoMessage = new Message();
        infoMessage.setID(msgid);
        infoMessage.setType(Message.Type.chat);
        infoMessage.setFrom(new JID("admin", XMPPServer.getInstance().getServerInfo().getXMPPDomain(), groupName, true));
        infoMessage.setTo(new JID(groupName, "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        ActionMessage diz = new ActionMessage(actionType, fromUid, extension);
        infoMessage.setBody(diz.toString());
        sp.sendMessageToGroup(infoMessage);
    }

    private String makeExtension(List<String> uidList) {
        if (uidList.isEmpty()) {
            return "";
        }
        int size = uidList.size();
        StringBuffer stringBuffer = new StringBuffer(16 * size);
        for (int i = 0; i < size; ++i) {
            stringBuffer.append(uidList.get(i));
            if (i == size - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RongGroup> getOldGroups() {
        long startTime = System.currentTimeMillis();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String UDID = this.getUDID();
        ArrayList<RongGroup> groups = new ArrayList<RongGroup>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select groupid,groupname,createuserid,members from social_allgroupinfos");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String adminuserid;
                RongGroup rg = new RongGroup();
                String groupid = rs.getString("groupid");
                String groupname = rs.getString("groupname");
                String createuserid = rs.getString("createuserid");
                String members = rs.getString("members");
                if (members == null || members.equals("")) continue;
                String[] memberlist = members.split(",");
                rg.groupid = groupid;
                rg.groupname = groupname;
                rg.adminuserid = adminuserid = createuserid + "|" + UDID;
                for (String mem : memberlist) {
                    String userid = mem + "|" + UDID;
                    rg.members.add(userid);
                }
                groups.add(rg);
            }
        }
        catch (Exception e) {
            try {
                Log.error("server plugin getOldGroups exception, already got group count:{}, err:{}", (Object)groups.size(), (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        long endTime = System.currentTimeMillis();
        Log.info("done server plugin getOldGroups, cost time:{}ms, group count:{}", (Object)(endTime - startTime), (Object)groups.size());
        return groups;
    }

    public void availableSession(ClientSession session, Presence presence) {
        String deviceResource;
        if (presence.getPriority() == 1 && (deviceResource = presence.getElement().elementTextTrim("device")) != null && !deviceResource.isEmpty()) {
            DeviceResourcesCacheUtil.getInstance().put(presence.getFrom().toString(), deviceResource, 604800);
        }
    }

    public void unavailableSession(ClientSession session, Presence presence) {
    }

    public void presenceChanged(ClientSession session, Presence presence) {
    }

    public void subscribedToPresence(JID subscriberJID, JID authorizerJID) {
    }

    public void unsubscribedToPresence(JID unsubscriberJID, JID recipientJID) {
        System.out.println(unsubscriberJID);
    }
}

