/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.SyncUsersThread;
import org.jivesoftware.openfire.plugin.util.TransferHistoryMsgToMongoDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServerServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(UserServerServlet.class);
    public static boolean isTransferHistoryMsg = false;
    public static boolean isSyncUser = false;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Log.info("UserServerServlet,params={}", (Object)JSON.toJSONString((Object)req.getParameterMap()).toString());
        try {
            String type = req.getParameter("type");
            if ("syncusers".equals(type)) {
                Integer userCount = this.getUserCount();
                if (userCount != null && userCount > 0) {
                    SyncUsersThread syncUserThread = new SyncUsersThread();
                    syncUserThread.start();
                    result.put("code", 100);
                } else {
                    result.put("code", 200);
                }
            } else if ("transferHistoryMsg".equals(type)) {
                TransferHistoryMsgToMongoDB transferHistoryMsgToMongoDB = new TransferHistoryMsgToMongoDB();
                transferHistoryMsgToMongoDB.start();
                result.put("code", 100);
            } else if ("getTransferStatus".equals(type)) {
                result.put("code", String.valueOf(isTransferHistoryMsg));
            }
        }
        catch (Exception e) {
            result.put("code", 500);
            Log.error("UserServerServlet,error={}", (Object)e.getMessage());
        }
        String jsonStr = JSON.toJSONString(result).toString();
        if (jsonStr != null && !"".equals(jsonStr)) {
            resp.setContentType("application/json; charset=utf-8");
            resp.getOutputStream().write(jsonStr.getBytes("UTF-8"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getUserCount() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Integer userCount = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select count(*) as userCount from  HrmResource");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userCount = Integer.parseInt(rs.getString("userCount"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserCount,error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return userCount;
    }

    public void destroy() {
        super.destroy();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }
}

