/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import com.weaver.util.SecurityVersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.plugin.util.NetDetectionUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessCheckServerNetworkStatus
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessCheckServerNetworkStatus.class);
    private static final String WEAPP_PUSH_CONFIG = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "weAppPush.properties";
    private static String pushUrl = "https://pushserver.weaver.com.cn/api/im/push/send";
    private static String access_tokenUrl = "https://pushserver.weaver.com.cn/api/im/auth/token";

    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        int jpushApiCode;
        this.loadWeAppPushConfig();
        boolean allPushIsGood = true;
        ArrayList<String> badAddress = new ArrayList<String>();
        if (allPushIsGood && (jpushApiCode = NetDetectionUtil.testUrl(access_tokenUrl)) == 500) {
            allPushIsGood = false;
            badAddress.add(access_tokenUrl);
        }
        if (allPushIsGood) {
            int etPushApiCode = NetDetectionUtil.testUrl(pushUrl);
            if (etPushApiCode == 500) {
                allPushIsGood = false;
            }
            badAddress.add(pushUrl);
        }
        if (allPushIsGood) {
            result.put("result", "1");
            JiveGlobals.setProperty((String)"pushNetStatus", (String)String.valueOf(System.currentTimeMillis()));
            badAddress.clear();
        } else {
            result.put("result", "0");
        }
        result.put("badAddress", badAddress);
        Version version = XMPPServer.getInstance().getServerInfo().getVersion();
        String securityVerscsui = SecurityVersionUtil.getSecurityVersion();
        String serverVersion = version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        result.put("version", serverVersion);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWeAppPushConfig() {
        InputStream is = null;
        try {
            String appKeyStr;
            File file = new File(WEAPP_PUSH_CONFIG);
            if (!file.exists()) {
                return;
            }
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            pushUrl = prop.getProperty("pushUrl").trim();
            if (pushUrl != null) {
                pushUrl = pushUrl.trim();
            }
            if ((access_tokenUrl = prop.getProperty("access_tokenUrl").trim()) != null) {
                access_tokenUrl = access_tokenUrl.trim();
            }
            if ((appKeyStr = prop.getProperty("appKey")) != null) {
                appKeyStr = appKeyStr.trim();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

