/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.action.GroupService;
import org.jivesoftware.openfire.plugin.bean.ActionMessage;
import org.jivesoftware.openfire.plugin.servlet.ServerPlugin;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.plugin.util.ActionType;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessCreateGroup
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessCreateGroup.class);

    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        String fromUserId = request.getParameter("fromUserId").toLowerCase();
        String userIds = request.getParameter("userIds");
        String description = request.getParameter("description");
        String isDisableMsgRead = request.getParameter("isDisableMsgRead");
        String isDisableAddUser = request.getParameter("isDisableAddUser");
        List<String> users = WeaverStringUtil.getList(userIds);
        GroupService gs = new GroupService();
        String groupName = UUID.randomUUID().toString().toLowerCase();
        ArrayList<String> members = new ArrayList<String>();
        gs.createGroup(groupName, description, users, isDisableMsgRead, isDisableAddUser, members);
        result.put("groupName", groupName);
        result.put("members", members);
        String needSendMsg = request.getParameter("needSendMsg");
        if ("true".equalsIgnoreCase(needSendMsg)) {
            this.sendActionMsgToGroup(groupName, fromUserId, users, ActionType.ActionInviteUser);
        }
        return result;
    }

    private void sendActionMsgToGroup(String groupName, String fromUid, List<String> uidList, ActionType actionType) {
        ServerPlugin sp = ServerPlugin.serverPlugin;
        String msgid = StringUtils.randomString((int)8);
        String extension = null;
        extension = ActionType.ActionRenameGroup == actionType ? uidList.get(0) : this.makeExtension(uidList);
        Message infoMessage = new Message();
        infoMessage.setID(msgid);
        infoMessage.setType(Message.Type.chat);
        infoMessage.setFrom(new JID("admin", XMPPServer.getInstance().getServerInfo().getXMPPDomain(), groupName, true));
        infoMessage.setTo(new JID(groupName, "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        ActionMessage diz = new ActionMessage(actionType, fromUid, extension);
        infoMessage.setBody(diz.toString());
        sp.sendMessageToGroup(infoMessage);
    }

    private String makeExtension(List<String> uidList) {
        if (uidList.isEmpty()) {
            return "";
        }
        int size = uidList.size();
        StringBuffer stringBuffer = new StringBuffer(16 * size);
        for (int i = 0; i < size; ++i) {
            stringBuffer.append(uidList.get(i));
            if (i == size - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }
}

