/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.cache.DeviceResourcesCacheUtil;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.jivesoftware.openfire.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class ProcessGetDeviceOnLine
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessGetDeviceOnLine.class);

    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        String userIds = request.getParameter("userIds");
        SessionManager sessionManager = XMPPServer.getInstance().getSessionManager();
        List<String> userIdsList = WeaverStringUtil.getList(userIds);
        for (String userId : userIdsList) {
            JID mobileJID;
            String mobileClusterNode;
            JID pcJID;
            String pcClusterNode;
            Collection sessions = sessionManager.getSessions(userId);
            HashMap<String, String> tempResult = new HashMap<String, String>();
            tempResult.put("pc", "-1");
            tempResult.put("mobile", "-1");
            boolean pcOnline = false;
            boolean mobileOnline = true;
            for (ClientSession clientSession : sessions) {
                if ("pc".equals(clientSession.getAddress().getResource())) {
                    pcOnline = true;
                } else if ("mobile".equals(clientSession.getAddress().getResource())) {
                    mobileOnline = true;
                }
                String device = DeviceResourcesCacheUtil.getInstance().get(clientSession.getAddress().toString());
                if (device == null || device.isEmpty()) {
                    device = clientSession.getAddress().getResource();
                }
                tempResult.put(clientSession.getAddress().getResource(), device);
            }
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            if (!pcOnline && clusterPropBeanUtil.isUseCluster() && (pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID = new JID(userId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !pcClusterNode.isEmpty()) {
                String device = DeviceResourcesCacheUtil.getInstance().get(pcJID.toString());
                if (device == null || device.isEmpty()) {
                    device = "pc";
                }
                tempResult.put("pc", device);
            }
            if (!mobileOnline && clusterPropBeanUtil.isUseCluster() && (mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJID = new JID(userId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !mobileClusterNode.isEmpty()) {
                tempResult.put("mobile", DeviceResourcesCacheUtil.getInstance().get(mobileJID.toString()));
            }
            result.put(userId, tempResult);
        }
        Log.info("getDeviceOnLine result:{},requestIp:{}", (Object)result.toString(), (Object)requestIp);
        return result;
    }
}

