/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import com.sun.management.OperatingSystemMXBean;
import com.weaver.cache.redis.RedisFileConfig;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.SecurityVersionUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Version;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessGetServerInfo
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessGetServerInfo.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        String os = System.getProperty("os.name") + " / " + System.getProperty("os.arch");
        int byteToMb = 0x100000;
        long physicalFree = osmxb.getFreePhysicalMemorySize() / (long)byteToMb;
        long physicalTotal = osmxb.getTotalPhysicalMemorySize() / (long)byteToMb;
        long physicalUse = physicalTotal - physicalFree;
        result.put("systemVersion", os);
        result.put("physicalTotal", physicalTotal + "M");
        result.put("physicalFree", physicalFree + "M");
        result.put("applicationServer", ServerInfo.JETTY_VERSION);
        Version version = XMPPServer.getInstance().getServerInfo().getVersion();
        String serverVersion = version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        result.put("serverVersion", serverVersion);
        String securityVersion = SecurityVersionUtil.getSecurityVersion();
        result.put("securityVersion", securityVersion);
        String vmName = System.getProperty("java.vm.name");
        vmName = vmName == null ? "" : " -- " + vmName;
        String javaVersion = System.getProperty("java.version") + "/" + System.getProperty("java.vendor") + vmName;
        result.put("javaVersion", javaVersion);
        result.put("homeDirectory", JiveGlobals.getHomeDirectory());
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int)runtime.freeMemory() / 0x100000;
        double maxMemory = (double)runtime.maxMemory() / 1048576.0;
        int totalMemory = (int)runtime.totalMemory() / 0x100000;
        int usedMemory = totalMemory - freeMemory;
        result.put("jvmMaxMemory", (int)maxMemory + "M");
        result.put("jvmUsedMemory", usedMemory + "M");
        String clusterInfo = "0";
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (clusterPropBeanUtil.isUseCluster()) {
            clusterInfo = "1";
        }
        result.put("clusterInfo", clusterInfo);
        try {
            HashMap<String, String> redisInfo = new HashMap<String, String>();
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            String redisVersion = redisPoolMgr.info("Server");
            String[] versionStr = redisVersion.split("\n");
            for (int i = 0; i < versionStr.length; ++i) {
                String s = versionStr[i];
                String[] detail = s.split(":");
                if (!detail[0].equals("redis_version")) continue;
                redisInfo.put("version", detail[1].substring(0, detail[1].length() - 1));
            }
            String redisHost = RedisFileConfig.getRedisCacheHost() + ":" + RedisFileConfig.getRedisCachePort();
            redisInfo.put("host", redisHost);
            String used_memory = redisPoolMgr.info("memory");
            String[] strs = used_memory.split("\n");
            for (int i = 0; i < strs.length; ++i) {
                String s = strs[i];
                String[] detail = s.split(":");
                if (detail[0].equals("used_memory_human")) {
                    redisInfo.put("used_memory", detail[1].substring(0, detail[1].length() - 1));
                }
                if (detail[0].equals("total_system_memory_human")) {
                    redisInfo.put("total_system_memory_human", detail[1].substring(0, detail[1].length() - 1));
                }
                if (!detail[0].equals("maxmemory_human")) continue;
                String maxmemory_human = detail[1].substring(0, detail[1].length() - 1);
                if ("0B".equals(maxmemory_human)) {
                    maxmemory_human = "-1";
                }
                redisInfo.put("maxmemory_human", maxmemory_human);
            }
            result.put("redisInfo", redisInfo);
        }
        catch (Exception e) {
            Log.error("ProcessGetSeverInfo,getRedisInfo error :{} ", (Object)e.getMessage());
        }
        Connection con = null;
        try {
            con = DbConnectionManager.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            HashMap<String, String> dbInfo = new HashMap<String, String>();
            String dBversion = metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion();
            dbInfo.put("version", dBversion);
            dbInfo.put("dbUrl", metaData.getURL());
            ConnectionPoolDefinitionIF poolDef = ProxoolFacade.getConnectionPoolDefinition((String)"openfire");
            dbInfo.put("minCon", String.valueOf(poolDef.getMinimumConnectionCount()));
            dbInfo.put("maxCon", String.valueOf(poolDef.getMaximumConnectionCount()));
            SnapshotIF poolStats = ProxoolFacade.getSnapshot((String)"openfire", (boolean)true);
            dbInfo.put("activeCon", String.valueOf(100 * poolStats.getActiveConnectionCount() / poolStats.getMaximumConnectionCount()));
            result.put("dbInfo", dbInfo);
        }
        catch (Exception e) {
            Log.error("ProcessGetSeverInfo,getDbInfo error :{} ", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection((Connection)con);
        }
        return result;
    }
}

