/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import com.weaver.util.SecurityVersionUtil;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.action.TokenService;
import org.jivesoftware.openfire.plugin.cache.DeviceResourcesCacheUtil;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class ProcessGetToken
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessGetToken.class);

    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        Log.debug("ProcessGetToken ,start :{} ", (Object)System.currentTimeMillis());
        String userId = request.getParameter("userId");
        String name = request.getParameter("name");
        String url = request.getParameter("url");
        String langData = request.getParameter("langData");
        if (langData != null && !langData.isEmpty()) {
            name = langData;
        }
        TokenService ts = new TokenService();
        Log.debug("ProcessGetToken userId:{},name:{},url:{}", new Object[]{userId, name, url});
        String userSec = ts.getToken(userId, name, url, true);
        result.put("token", userSec);
        Log.debug("ProcessGetToken ,startCheckUserOnline :{} ", (Object)System.currentTimeMillis());
        SessionManager sessionManager = XMPPServer.getInstance().getSessionManager();
        Collection sessions = sessionManager.getSessions(userId);
        boolean pcOnline = false;
        for (ClientSession clientSession : sessions) {
            if (!"pc".equals(clientSession.getAddress().getResource())) continue;
            pcOnline = true;
            result.put("device", DeviceResourcesCacheUtil.getInstance().get(clientSession.getAddress().toString()));
        }
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (!pcOnline && clusterPropBeanUtil.isUseCluster()) {
            JID pcJID = new JID(userId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            String pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID);
            if (pcClusterNode != null && !pcClusterNode.isEmpty()) {
                pcOnline = true;
            }
        }
        Log.debug("ProcessGetToken ,startGetMarsEnabled :{} ", (Object)System.currentTimeMillis());
        boolean marsEnabled = JiveGlobals.getBooleanProperty((String)"xmpp.mars.marsEnabled", (boolean)false);
        HashMap<String, Object> mobileConfig = new HashMap<String, Object>();
        mobileConfig.put("marsEnabled", marsEnabled);
        int etValue = 1;
        mobileConfig.put("etPushEnabled", JiveGlobals.getIntProperty((String)"etPushEnabled", (int)etValue));
        HashMap<String, Object> marsSetting = new HashMap<String, Object>();
        if (marsEnabled) {
            int version = JiveGlobals.getIntProperty((String)"xmpp.mars.version", (int)1);
            marsSetting.put("version", version);
            String longIP = JiveGlobals.getProperty((String)"xmpp.mars.longIP", (String)"");
            marsSetting.put("longIP", longIP);
            int longPort = JiveGlobals.getIntProperty((String)"xmpp.mars.longPort", (int)-1);
            if (-1 != longPort) {
                marsSetting.put("longPort", longPort);
            } else {
                marsSetting.put("longPort", "");
            }
            String shortIP = JiveGlobals.getProperty((String)"xmpp.mars.shortIP", (String)"");
            marsSetting.put("shortIP", shortIP);
            int shortPort = JiveGlobals.getIntProperty((String)"xmpp.mars.shortPort", (int)-1);
            if (-1 != shortPort) {
                marsSetting.put("shortPort", shortPort);
            } else {
                marsSetting.put("shortPort", "");
            }
            String shortPrePath = JiveGlobals.getProperty((String)"xmpp.mars.shortPrePath", (String)"");
            marsSetting.put("shortPrePath", shortPrePath);
            int compressType = JiveGlobals.getIntProperty((String)"xmpp.mars.compressType", (int)0);
            marsSetting.put("compressType", compressType);
            int encrtyType = JiveGlobals.getIntProperty((String)"xmpp.mars.encrtyType", (int)1);
            marsSetting.put("encrtyType", encrtyType);
            int LoginEncrtyType = JiveGlobals.getIntProperty((String)"xmpp.mars.LoginEncrtyType", (int)2);
            marsSetting.put("LoginEncrtyType", LoginEncrtyType);
            String LoginEncrtyKey = JiveGlobals.getProperty((String)"xmpp.mars.LoginEncrtyKey", (String)"default");
            marsSetting.put("LoginEncrtyKey", LoginEncrtyKey);
            String longCmdId = JiveGlobals.getProperty((String)"xmpp.mars.longCmdId", (String)"");
            marsSetting.put("longCmdId", longCmdId);
            String shortCmdId = JiveGlobals.getProperty((String)"xmpp.mars.shortCmdId", (String)"");
            marsSetting.put("shortCmdId", shortCmdId);
            String bothCmdId = JiveGlobals.getProperty((String)"xmpp.mars.bothCmdId", (String)"");
            marsSetting.put("bothCmdId", bothCmdId);
            int defaultLinkType = JiveGlobals.getIntProperty((String)"xmpp.mars.defaultLinkType", (int)0);
            marsSetting.put("defaultLinkType", defaultLinkType);
            String debuguser = JiveGlobals.getProperty((String)"xmpp.mars.debuguser", (String)"");
            marsSetting.put("debuguser", debuguser);
            mobileConfig.put("marsSetting", marsSetting);
        }
        Log.debug("ProcessGetToken ,startGetServerVersion :{} ", (Object)System.currentTimeMillis());
        Version version = XMPPServer.getInstance().getServerInfo().getVersion();
        String serverVersion = version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        result.put("serverVersion", serverVersion);
        Log.debug("ProcessGetToken ,startGetSecurityVersion :{} ", (Object)System.currentTimeMillis());
        String securityVersion = SecurityVersionUtil.getSecurityVersion();
        result.put("securityVersion", securityVersion);
        result.put("mobileConfig", mobileConfig);
        result.put("pcOnline", pcOnline);
        Log.info("getToken end userid:{}, name:{},result:{},requestIp:{}", new Object[]{userId, name, result.toString(), requestIp});
        return result;
    }
}

