/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.plugin.util.SendFGroupMessageThread;
import org.jivesoftware.openfire.plugin.util.SendPublishMessageThread;
import org.jivesoftware.openfire.plugin.util.SendPublishMessageToMobileOrPcThread;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPublishMessage
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessPublishMessage.class);

    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        String fromUserId = request.getParameter("fromUserId");
        String toUserId = request.getParameter("toUserId");
        String toGroupId = request.getParameter("toGroupId");
        String objectName = request.getParameter("objectName");
        String resource = request.getParameter("resource");
        String content = request.getParameter("content");
        String toResource = request.getParameter("toResource");
        if (Log.isDebugEnabled()) {
            Log.debug("workflow push--content:" + content);
            Log.debug("workflow push--toUserId:" + toUserId);
        }
        if ("mobile".equals(toResource) || "pc".equals(toResource)) {
            List<String> tousers = WeaverStringUtil.getList(toUserId);
            fixedThreadPool.execute(new SendPublishMessageToMobileOrPcThread(tousers, content, fromUserId, resource, toResource));
        } else {
            if (toUserId != null && !toUserId.isEmpty()) {
                List<String> tousers = WeaverStringUtil.getList(toUserId);
                fixedThreadPool.execute(new SendPublishMessageThread(tousers, content, fromUserId, resource));
            }
            if (toGroupId != null && !toGroupId.isEmpty()) {
                result.put("toGroupId", toGroupId);
                fixedThreadPool.execute(new SendFGroupMessageThread(fromUserId, toGroupId, content, resource));
            }
        }
        Log.info("publishMessage ,fromUserId :{} ,toUserId: {} ,toGroupId :{} ,objectName:{} ,resource :{} ,content :{},toResource:{} ", new Object[]{fromUserId, toUserId, toGroupId, objectName, resource, content, toResource});
        return result;
    }
}

