/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.server.util.UsernameUtil;
import com.weaver.util.GroupNoticeUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.bean.ActionMessage;
import org.jivesoftware.openfire.plugin.servlet.ServerPlugin;
import org.jivesoftware.openfire.plugin.servlet.strategy.ServletStrategy;
import org.jivesoftware.openfire.plugin.util.DBUtil;
import org.jivesoftware.openfire.plugin.util.KillUserOfflineUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessTurnover
implements ServletStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessTurnover.class);

    @Override
    public Map process(Map result, HttpServletRequest request, String requestIp, ExecutorService fixedThreadPool) {
        block15: {
            String userids = request.getParameter("userids");
            GroupManager groupManager = GroupManager.getInstance();
            UserManager userManager = UserManager.getInstance();
            Log.info("turnover,userids:{},requestIp:{}", (Object)userids, (Object)requestIp);
            try {
                if (userids == null) break block15;
                long opTime = System.currentTimeMillis();
                String[] userIdArray = userids.split(",");
                for (int i = 0; i < userIdArray.length; ++i) {
                    try {
                        String userid = userIdArray[i];
                        String username = userid + "|" + ServerInfo.SYSTEM_UDID;
                        User user = null;
                        String operaterName = null;
                        try {
                            user = userManager.getUser(username);
                            user.setIsTurnover(true);
                            operaterName = UsernameUtil.getUserName(username, user.getName());
                        }
                        catch (UserNotFoundException e) {
                            Log.warn("turnover,user : {} not found .", (Object)username);
                            continue;
                        }
                        Collection groups = groupManager.getGroups(user);
                        if (null != groups && groups.size() > 0) {
                            int isUserAdmn = 0;
                            int isUserMngr = 0;
                            for (Group group : groups) {
                                JSONArray groupManagerArray;
                                String groupManagers;
                                PersistableMap groupPropMap;
                                JID userJid = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                                group.getMembers().remove(userJid);
                                if (group.getAdmins().contains(userJid)) {
                                    group.getAdmins().remove(userJid);
                                    isUserAdmn = 1;
                                }
                                if ((groupPropMap = group.getProperties()) != null && groupPropMap.containsKey((Object)"groupManagers") && (groupManagers = (String)groupPropMap.get((Object)"groupManagers")) != null && !groupManagers.isEmpty() && (groupManagerArray = JSON.parseArray((String)groupManagers)) != null) {
                                    if (groupManagerArray.contains((Object)user.getUID())) {
                                        isUserMngr = 1;
                                        groupManagerArray.remove((Object)user.getUID());
                                    }
                                    groupPropMap.put((Object)"groupManagers", (Object)groupManagerArray.toString());
                                }
                                try {
                                    String content = operaterName + "\u9000\u51fa\u4e86\u7fa4\u7ec4";
                                    this.sendMessageToGroup(user, group, content);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                result.put(userid, "true");
                                DBUtil.recordTurnover(userid, group.getName(), isUserAdmn, isUserMngr, requestIp, opTime);
                                Log.info("userid:{} turnover.and exit groupId:{},isUserAdmn:{},isUserMngr:{},requestIp is:{}", new Object[]{userid, group.getDescription(), isUserAdmn, isUserMngr, requestIp});
                            }
                        } else {
                            DBUtil.recordTurnover(userid, "", 0, 0, requestIp, opTime);
                            Log.info("userid:{} turnover with no groups,requestIp is:{}", (Object)userid, (Object)requestIp);
                        }
                        KillUserOfflineUtil.killUserOffline(userid, null);
                        continue;
                    }
                    catch (Exception e) {
                        Log.error("turnover,userids:{}.error:{},e:{}", new Object[]{userids, e.getMessage(), e});
                    }
                }
            }
            catch (Exception e) {
                Log.error("turnover,userids:{}.error:{},e:{}", new Object[]{userids, e.getMessage(), e});
            }
        }
        return result;
    }

    private void sendMessageToGroup(User user, Group group, String content) {
        final User usertemp = user;
        final Group grouptemp = group;
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                String show_userIds;
                String extension = usertemp.getUID();
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                ActionMessage diz = new ActionMessage(2, usertemp.getUID(), extension);
                diz.setContent(finalContent);
                Collection admins = grouptemp.getAdmins();
                StringBuilder adminsArray = new StringBuilder("");
                for (JID admin : admins) {
                    adminsArray.append(admin.getNode());
                    adminsArray.append(",");
                }
                if (adminsArray.length() > 1) {
                    diz.setAdmins(adminsArray.toString().substring(0, adminsArray.toString().length() - 1));
                }
                int groupLeaveOutNotice = JiveGlobals.getIntProperty((String)"groupLeaveOutNotice", (int)0);
                if (GroupNoticeUtil.checkGroupJudgtActiveDay((String)grouptemp.getName())) {
                    if (0 == groupLeaveOutNotice) {
                        diz.setShow_userIds("-1");
                        diz.setNo_conv("1");
                        diz.setNo_db("1");
                    } else if (1 == groupLeaveOutNotice) {
                        show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                        diz.setShow_userIds(show_userIds);
                        diz.setTo_users(show_userIds);
                    } else if (2 == groupLeaveOutNotice) {
                        diz.setShow_userIds("0");
                    }
                } else {
                    diz.setNo_conv("1");
                    if (0 == groupLeaveOutNotice) {
                        diz.setShow_userIds("-1");
                        diz.setNo_db("1");
                    } else if (1 == groupLeaveOutNotice) {
                        show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                        diz.setShow_userIds("-1");
                        diz.setTo_users(show_userIds);
                    } else if (2 == groupLeaveOutNotice) {
                        diz.setShow_userIds("-1");
                    }
                }
                infoMessage.setBody(diz.toString());
                ServerPlugin sp = ServerPlugin.serverPlugin;
                sp.sendMessageToGroup(infoMessage);
            }
        });
    }
}

