/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.bean.PushInfoFullBean;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class DBUtil {
    private static final Logger Log = LoggerFactory.getLogger(DBUtil.class);
    private static final String SELECT_ISNEWMOBILE = " SELECT * FROM OFUSERPROP where username = ? and name = 'IsNewMobile' ";
    private static final String UPDATE_ISNEWMOBILE = " update ofuserprop set propvalue = ? where username = ? and name = 'IsNewMobile' ";
    private static final String INSERT_ISNEWMOBILE = " insert into ofuserprop (username,name,propvalue) values (?,'IsNewMobile',?) ";
    private static String Delete_OFPUSHDEVICEBYUSER = " update OFPUSHDEVICE set token = '-1' where userid = ?";
    private static final String DELETE_PUSHINFO = "delete from ofpushinfoNEW where packagename = ? ";
    private static final String SELECT_PUSHINFO_all = " select packagename,appName from ofpushinfoNEW ";
    private static final String SELECT_PUSHINFO = " select packagename,appName from ofpushinfoNEW where packagename = ? ";
    private static final String UPDATE_PUSHINFO = " update ofpushinfoNEW set appName=? where packagename = ? ";
    private static final String INSERT_PUSHINFO = " insert into ofpushinfoNEW (packagename,appName) values(?,?) ";
    private static final String INSERT_OFTURNOVER = "insert into ofturnover (userid,groupid,isUserAdmn,isUserMngr,requestIp,opTime) values (?,?,?,?,?,?)";
    private static String pushInfoKey = "pushInfoKey:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deletePushInfo(String packageName) {
        Log.info("deletePushInfo,packageName:{}", (Object)packageName);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PUSHINFO);
            pstmt.setString(1, packageName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deletePushInfo error:{},packageName:{}", (Object)e.getMessage(), (Object)packageName);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            redisPoolMgr.del(pushInfoKey + packageName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PushInfoFullBean> getPushInfoFullBean() {
        ArrayList<PushInfoFullBean> pushInfoFullBeanList = new ArrayList<PushInfoFullBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_PUSHINFO_all);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PushInfoFullBean pushIfb = new PushInfoFullBean();
                pushIfb.setPackageName(rs.getString("packagename"));
                String appName = rs.getString("appName");
                if (appName == null || appName.isEmpty()) {
                    pushIfb.setAppName("E-Mobile");
                } else {
                    pushIfb.setAppName(appName);
                }
                pushInfoFullBeanList.add(pushIfb);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getPushInfoFullBean error : {}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return pushInfoFullBeanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savaPushInfo(String packagename, String appName) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block6: {
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(SELECT_PUSHINFO);
                pstmt.setString(1, packagename);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(UPDATE_PUSHINFO);
                    pstmt.setString(1, appName);
                    pstmt.setString(2, packagename);
                    pstmt.executeUpdate();
                    break block6;
                }
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(INSERT_PUSHINFO);
                pstmt.setString(1, packagename);
                pstmt.setString(2, appName);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                try {
                    Log.error("savePushInfo.error:{},,packagename:{},appName:{}", new Object[]{e.getMessage(), packagename, appName});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            redisPoolMgr.set(pushInfoKey + packagename, appName, 2592000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String userid, String resource) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            DBUtil.unregisterResource(userid, resource);
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(Delete_OFPUSHDEVICEBYUSER);
            pstmt.setString(1, userid.toLowerCase());
            pstmt.execute();
            RedisPoolMgr redis = RedisPoolMgr.getInstance();
            if (redis != null) {
                redis.del("push_device:" + userid);
                JID jid = new JID(userid, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                redis.del("mobile_presence_" + jid.toString());
            } else {
                Cache pushCache = CacheFactory.createCache((String)"Push Device Cache");
                pushCache.remove((Object)userid.toLowerCase());
            }
            Log.info("unregisterPush ok,userid :{}", (Object)userid);
        }
        catch (Exception e) {
            try {
                Log.info("unregisterPush,userid={},err={}", (Object)userid, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResource(String userid, String resource) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("  update OFPUSHDEVICE set token = '-1' where userid = ? and (userType = ? or userType is null) ");
            pstmt.setString(1, userid.toLowerCase());
            pstmt.setString(2, resource);
            pstmt.execute();
            RedisPoolMgr redis = RedisPoolMgr.getInstance();
            if (redis != null) {
                redis.del("push_device:" + userid + resource);
                JID jid = new JID(userid, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                redis.del("mobile_presence_" + jid.toString());
            } else {
                Cache pushCache = CacheFactory.createCache((String)"Push Device Cache");
                pushCache.remove((Object)userid.toLowerCase());
            }
            Log.info("unregisterPush ok,userid :{}", (Object)userid);
        }
        catch (Exception e) {
            try {
                Log.info("unregisterPush,userid={},err={}", (Object)userid, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordTurnover(String userid, String groupId, int isUserAdmn, int isUserMngr, String requestIp, long opTime) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_OFTURNOVER);
            pstmt.setString(1, userid);
            pstmt.setString(2, groupId);
            pstmt.setInt(3, isUserAdmn);
            pstmt.setInt(4, isUserMngr);
            pstmt.setString(5, requestIp);
            pstmt.setLong(6, opTime);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error("http turnover record err ,userid={}, description={}, isUserAdmn={}, isUserMngr={}, requestIp={}, err={}", new Object[]{userid, groupId, isUserAdmn, isUserMngr, requestIp, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordIsNewMobile(String IsNewMobile, String username) {
        username = username.toLowerCase();
        Log.info("recordIsNewMobile.IsNewMobile:{},username:{}", (Object)IsNewMobile, (Object)username);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_ISNEWMOBILE);
            pstmt.setString(1, username.toLowerCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(UPDATE_ISNEWMOBILE);
                pstmt.setString(1, IsNewMobile);
                pstmt.setString(2, username);
            } else {
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(INSERT_ISNEWMOBILE);
                pstmt.setString(1, username);
                pstmt.setString(2, IsNewMobile);
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("recordIsNewMobile.error.IsNewMobile:{},username:{},error:{}", new Object[]{IsNewMobile, username, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }
}

