/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.ServerInfo;
import com.weaver.util.WeiSouPropertiesUtil;
import com.weaver.util.subtable.historymsg.MsgIndexUpdateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.bean.DingBean;
import org.jivesoftware.openfire.plugin.bean.DingReciver;
import org.jivesoftware.openfire.plugin.bean.DingReply;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingDataBaseUtil {
    private static final Logger Log = LoggerFactory.getLogger(DingDataBaseUtil.class);
    private static final String INSERT_MOBILE_DING = "insert into mobile_ding (sendid,content,scopeid,messageid,udid,operate_date,ding_module,had_send,isdel,isPrivate) values (?,?,?,?,?,?,?,?,0,?)";
    private static final String INSERT_MOBILE_DING_FORDM = "insert into mobile_ding (id,sendid,content,scopeid,messageid,udid,operate_date,ding_module,had_send,isdel,isPrivate) values (?,?,?,?,?,?,?,?,?,0,?)";
    private static final String INSERT_MOBILE_DINGRECIVER = "insert into mobile_dingReciver (dingid,userid,confirm,isdel) values (?,?,?,0)";
    private static final String SELECT_MOBILE_DING_BY_ID = "select * from mobile_ding where id =? and isdel <> 1";
    private static final String SELECT_MOBILE_DINGRECIVER_BY_DINGID = "select * from mobile_dingReciver where dingid =? and isdel <> 1";
    private static final String SELECT_MOBILE_DINGREPLY_BY_DINGID = "select * from mobile_dingReply where dingid =? and isdel <> 1 order by operate_date DESC";
    private static final String UPDATE_MOBILE_DING_HADSEND = "update mobile_ding set had_send =? where id = ? and isdel <> 1 ";
    private static final String UPDATE_HISTORYMSGRECENTLY_DING = " UPDATE HistoryMsgRecently SET classname ='FW:CMDMsg', msgContent=? WHERE  msgid =? ";
    private static final String UPDATE_HISTORYMSG_DING = "UPDATE HistoryMsg SET classname ='FW:CMDMsg', msgContent=?,updatetime =? WHERE  msgid =?";
    private static final String UPDATE_IMRECENTCONVER_UPDATETIME = "update social_IMRecentConver set isdel = 0,updatetime = ? where targetid = ? ";
    private static final String INSERT_IMRECENTCONVER = "insert into social_IMRecentConver (userid,targetid,isdel,istop,unreadcount,updatetime) values (?,?,0,0,?,?)";
    private static final String UPDATE_IMRECENTCONVER_UNREADCOUNT_SQLSERVER = " update social_IMRecentConver set unreadcount = isNULL(unreadcount,0)+1 where targetid = ?  and userid <> ? ";
    private static final String UPDATE_IMRECENTCONVER_UNREADCOUNT_ORACLE = " update social_IMRecentConver set unreadcount = NVL(unreadcount,0)+1 where targetid = ?  and userid <> ? ";
    private static final String UPDATE_IMRECENTCONVER_UNREADCOUNT_MYSQL = " update social_IMRecentConver set unreadcount = ifnull(unreadcount,0)+1 where targetid = ? and userid <> ? ";
    private static final String UPDATE_IMRECENTCONVER_UNREADCOUNT_POSTGRESQL = " update social_IMRecentConver set unreadcount = coalesce(unreadcount,0)+1 where targetid = ?  and userid <> ? ";

    public DingBean saveMobileDing(DingBean dingBean, List<String> toUserids) throws Exception {
        Log.info("saveMobileDing ,dingBean:{},toUserids:{}", (Object)JSON.toJSON((Object)dingBean).toString(), toUserids);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String dmDingid = "";
        ArrayList<DingReciver> dingRecivers = new ArrayList<DingReciver>();
        try {
            con = DbConnectionManager.getConnection();
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                pstmt = con.prepareStatement(INSERT_MOBILE_DING, 1);
                pstmt.setString(1, dingBean.getSendid());
                pstmt.setString(2, dingBean.getContent());
                pstmt.setString(3, dingBean.getScopeid());
                pstmt.setString(4, dingBean.getMessageid());
                pstmt.setString(5, dingBean.getUdid());
                pstmt.setString(6, dingBean.getOperateDate());
                pstmt.setInt(7, dingBean.getModule());
                pstmt.setInt(8, dingBean.getHadSend());
                pstmt.setString(9, dingBean.getIsPrivate());
                pstmt.execute();
            } else if (DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                pstmt = con.prepareStatement("select MOBILE_DING_seq.nextval as id  from dual ");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    dmDingid = rs.getString("id");
                }
                Log.info("saveMobileDing dmDingid :{} ", (Object)dmDingid);
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(INSERT_MOBILE_DING_FORDM);
                pstmt.setInt(1, Integer.parseInt(dmDingid));
                pstmt.setString(2, dingBean.getSendid());
                pstmt.setString(3, dingBean.getContent());
                pstmt.setString(4, dingBean.getScopeid());
                pstmt.setString(5, dingBean.getMessageid());
                pstmt.setString(6, dingBean.getUdid());
                pstmt.setString(7, dingBean.getOperateDate());
                pstmt.setInt(8, dingBean.getModule());
                pstmt.setInt(9, dingBean.getHadSend());
                pstmt.setString(10, dingBean.getIsPrivate());
                Log.info("saveMobileDing insert mobile_ding, sql :{},1:{},2:{},3:{},4:{},5:{},6:{},7:{},8:{},9:{} ", new Object[]{INSERT_MOBILE_DING_FORDM, dmDingid, dingBean.getSendid(), dingBean.getContent(), dingBean.getScopeid(), dingBean.getMessageid(), dingBean.getUdid(), dingBean.getOperateDate(), dingBean.getModule(), dingBean.getHadSend()});
                int insertOracleResult = pstmt.executeUpdate();
                Log.info("saveMobileDing insert mobile_ding end,insertResult:{},sql:{}", (Object)insertOracleResult, (Object)INSERT_MOBILE_DING_FORDM);
            }
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                rs = pstmt.getGeneratedKeys();
                if (rs.next()) {
                    dingBean.setId(rs.getString(1));
                }
            } else if (DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                dingBean.setId(dmDingid);
            }
            String dingid = dingBean.getId();
            Log.info("saveMobileDing dingid :{} ,databaseType:{}", (Object)dingid, (Object)DbConnectionManager.getDatabaseType());
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(INSERT_MOBILE_DINGRECIVER);
            if (toUserids != null && toUserids.size() == 1) {
                String userId = this.getRealUserId(toUserids.get(0));
                DingReciver dingReciver = new DingReciver(dingid, userId, "false");
                dingRecivers.add(dingReciver);
                pstmt.setString(1, dingid);
                pstmt.setString(2, userId);
                pstmt.setString(3, dingReciver.getConfirm());
                int insertR = pstmt.executeUpdate();
                Log.info("saveMobileDing insert mobile_ding_reciver ,single : userID:{},dingId:{},insertR:{}", new Object[]{userId, dingid, insertR});
            } else {
                for (String i : toUserids) {
                    String userId = this.getRealUserId(i);
                    DingReciver dingReciver = new DingReciver(dingid, userId, "false");
                    dingRecivers.add(dingReciver);
                    pstmt.setString(1, dingid);
                    pstmt.setString(2, userId);
                    pstmt.setString(3, dingReciver.getConfirm());
                    pstmt.addBatch();
                }
                int[] insertS = pstmt.executeBatch();
                Log.info("saveMobileDing insert mobile_ding_reciver ,single : toUserids:{},dingId:{},insertS:{}", new Object[]{toUserids, dingid, insertS});
                pstmt.clearBatch();
            }
            Log.info("dingRecivers :{} ", dingRecivers);
            dingBean.setDingRecivers(dingRecivers);
        }
        catch (Exception e) {
            try {
                Log.error("saveMobileDing,sendId={},,err={}", (Object)dingBean.getSendid(), (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        dingBean.setDingRecivers(dingRecivers);
        return dingBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DingBean getDingBeanByDingId(int dingId) {
        DingBean dingBean = new DingBean();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_MOBILE_DING_BY_ID);
            pstmt.setInt(1, dingId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                dingBean.setId(Integer.toString(dingId));
                dingBean.setSendid(rs.getString("sendid"));
                dingBean.setContent(rs.getString("content"));
                dingBean.setScopeid(rs.getString("scopeid"));
                dingBean.setMessageid(rs.getString("messageid"));
                dingBean.setUdid(rs.getString("udid"));
                dingBean.setOperateDate(rs.getString("operate_date"));
                dingBean.setModule(rs.getInt("ding_module"));
                dingBean.setHadSend(rs.getInt("had_send"));
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(SELECT_MOBILE_DINGRECIVER_BY_DINGID);
            pstmt.setInt(1, dingId);
            rs = pstmt.executeQuery();
            ArrayList<DingReciver> dingReciverList = new ArrayList<DingReciver>();
            while (rs.next()) {
                DingReciver dingReciver = new DingReciver();
                dingReciver.setId(rs.getString("id"));
                dingReciver.setDingid(rs.getString("dingid"));
                dingReciver.setUserid(rs.getString("userid"));
                dingReciver.setConfirm(rs.getString("confirm").trim());
                dingReciverList.add(dingReciver);
            }
            dingBean.setDingRecivers(dingReciverList);
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(SELECT_MOBILE_DINGREPLY_BY_DINGID);
            pstmt.setInt(1, dingId);
            rs = pstmt.executeQuery();
            ArrayList<DingReply> dingReplyList = new ArrayList<DingReply>();
            while (rs.next()) {
                DingReply dingReply = new DingReply();
                dingReply.setId(rs.getString("id"));
                dingReply.setDingid(rs.getString("dingid"));
                dingReply.setUserid(rs.getString("userid"));
                dingReply.setContent(rs.getString("content"));
                dingReply.setOperate_date(rs.getString("operate_date"));
                dingReplyList.add(dingReply);
            }
            dingBean.setDingReplys(dingReplyList);
        }
        catch (SQLException e) {
            try {
                Log.error("getDingBeanByDingId,dingId={},,err={}", (Object)dingId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return dingBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateDingBeanHadSend(int dingId, int hadSend) {
        int n;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_MOBILE_DING_HADSEND);
            pstmt.setInt(1, hadSend);
            pstmt.setInt(2, dingId);
            n = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateDingBeanHadSend,err={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            return -1;
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDingClassName(String messageId, String msgContent) {
        if (messageId == null || "".equals(messageId.trim())) {
            return;
        }
        String messagekey = "history:msg:" + messageId;
        if (RedisPoolMgr.getInstance() != null && RedisPoolMgr.getInstance().exists(messagekey)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("objectName", "FW:CMDMsg");
            map.put("content", msgContent);
            RedisPoolMgr.getInstance().hmset(messagekey, map, 604800);
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_HISTORYMSGRECENTLY_DING);
            pstmt.setString(1, msgContent);
            pstmt.setString(2, messageId);
            pstmt.executeUpdate();
            DbConnectionManager.closeStatement((Statement)pstmt);
            SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String updateTime = SDF_ALL_TIME_FORMAT.format(System.currentTimeMillis() + 60000L);
            String tableName = MsgIndexUpdateUtil.getTableNameByMsgId((String)messageId);
            String sql = "UPDATE " + tableName + " SET classname ='FW:CMDMsg', msgContent=?,updatetime =? WHERE  msgid =?";
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, msgContent);
            pstmt.setString(2, updateTime);
            pstmt.setString(3, messageId);
            pstmt.executeUpdate();
            WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
            if (w.isWeiSouEnable() && JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                msg.updateMsgIndex("1", tableName, messageId);
            }
        }
        catch (Exception e) {
            Log.error("updateDingClassName,msgid={},err={}", (Object)messageId, (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DingDataBaseUtil.deleteMsgCollect(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMsgCollect(String msgId) {
        Log.info("deleteMsgCollection,msgId:{}", (Object)msgId);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("delete from ofMsgCollect where  msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteMsgCollection,msgIds:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDingCon(String userid, String targetid, String targettype, String targetname, String msgcontent, String msgId, String reciverId, boolean needRecordUnreadCount, String objectName, String content) {
        Log.info("updateDingCon,userid={},targetid={},msgId={},reciverId={},targetname={}", new Object[]{userid, targetid, msgId, reciverId, targetname});
        Long updatetime = System.currentTimeMillis();
        HashMap<String, String> obMap = new HashMap<String, String>();
        obMap.put("userid", userid);
        obMap.put("targetid", targetid);
        obMap.put("targettype", targettype);
        obMap.put("targetname", targetname);
        obMap.put("msgcontent", msgcontent);
        obMap.put("msgid", msgId);
        obMap.put("lasttime", String.valueOf(updatetime));
        obMap.put("istop", "0");
        obMap.put("isdel", "0");
        obMap.put("unreadcount", "0");
        obMap.put("groupName", "");
        obMap.put("groupIconUrl", "");
        obMap.put("objectName", objectName);
        obMap.put("content", content);
        obMap.put("sendId", userid);
        String key_itme = "conversation:itmes:" + targetid + ":" + reciverId;
        String key_right = "conversation:right:" + reciverId;
        RedisPoolMgr redisPoolMgr = null;
        try {
            redisPoolMgr = RedisPoolMgr.getInstance();
            for (Map.Entry kv : obMap.entrySet()) {
                redisPoolMgr.hsetnx(key_itme, (String)kv.getKey(), (String)kv.getValue());
            }
            obMap.remove("istop");
            obMap.remove("unreadcount");
            for (Map.Entry kv : obMap.entrySet()) {
                redisPoolMgr.hset(key_itme, (String)kv.getKey(), (String)kv.getValue());
            }
            if (needRecordUnreadCount) {
                redisPoolMgr.hincrBy(key_itme, "unreadcount", 1L);
            }
            redisPoolMgr.zadd(key_right, updatetime.longValue(), key_itme, -1);
            redisPoolMgr.zadd("conversation:queue", System.currentTimeMillis(), key_itme, -1);
        }
        catch (Exception e) {
            Log.error("updateDingCon,userid={},targetid={},msgId={},targetname={},err={}", new Object[]{userid, targetid, msgId, targetname, e.getMessage()});
        }
    }

    public String getRealUserId(String jidNode) {
        if (jidNode.indexOf("|") > 0) {
            jidNode = jidNode.substring(0, jidNode.indexOf("|"));
        }
        return jidNode;
    }

    public String getJIDNode(String userid) {
        return userid + "|" + ServerInfo.SYSTEM_UDID;
    }
}

