/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyForPush {
    private static final Logger Log = LoggerFactory.getLogger(HttpProxyForPush.class);
    private static HttpProxyForPush instance = null;
    private boolean userProxy = false;
    private String proxyHost;
    private int proxyPort = 0;
    private boolean propxyNeedAuth = false;
    private String proxyUsername;
    private String proxyPassword;

    private HttpProxyForPush() {
        this.loadHttpProxyProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHttpProxyProperties() {
        String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "httpProxy.properties";
        File file = new File(filePath);
        if (!file.exists()) {
            Log.warn("loadHttpProxyProperties .file :{} is not exist .", (Object)filePath);
            return;
        }
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(file);
            properties.load(is);
            this.userProxy = Boolean.valueOf(properties.getProperty("userProxy"));
            this.proxyHost = properties.getProperty("proxyHost");
            String post = properties.getProperty("proxyPort");
            this.proxyPort = Integer.parseInt(post);
            this.propxyNeedAuth = Boolean.valueOf(properties.getProperty("propxyNeedAuth"));
            this.proxyUsername = properties.getProperty("proxyUsername");
            this.proxyPassword = properties.getProperty("proxyPassword");
            Log.info("userProxy:{},userHost:{},prot:{},needAuth:{},username:{},password:{}", new Object[]{this.userProxy, this.proxyHost, this.proxyPort, this.propxyNeedAuth, this.proxyUsername, this.proxyPassword});
        }
        catch (Exception e) {
            Log.error("loadHttpProxyProperties .error:{}", (Object)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyToFile(String name, String value) {
        String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "httpProxy.properties";
        File file = new File(filePath);
        if (!file.exists()) {
            Log.warn("setPropertyToFile .file :{} is not exist . not createNowFile", (Object)filePath);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.error("createNewFileERROR:filePath:{},error:{}", (Object)filePath, (Object)e.getMessage());
                return;
            }
        }
        FileOutputStream oFile = null;
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(filePath);
            properties.load(is);
            ((InputStream)is).close();
            properties.setProperty(name, value);
            oFile = new FileOutputStream(filePath);
            properties.store(oFile, null);
        }
        catch (Exception e) {
            Log.error("setPropertyToFile .error:{}", (Object)e.getMessage());
        }
        finally {
            if (oFile != null) {
                try {
                    oFile.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static HttpProxyForPush getInstance() {
        if (instance == null) {
            instance = new HttpProxyForPush();
        }
        return instance;
    }

    public boolean isUserProxy() {
        return this.userProxy;
    }

    public void setUserProxy(boolean userProxy) {
        this.userProxy = userProxy;
        this.setPropertyToFile("userProxy", String.valueOf(userProxy));
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        this.setPropertyToFile("proxyHost", proxyHost);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setPropertyToFile("proxyPort", String.valueOf(proxyPort));
    }

    public boolean isPropxyNeedAuth() {
        return this.propxyNeedAuth;
    }

    public void setPropxyNeedAuth(boolean propxyNeedAuth) {
        this.propxyNeedAuth = propxyNeedAuth;
        this.setPropertyToFile("propxyNeedAuth", String.valueOf(propxyNeedAuth));
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        this.setPropertyToFile("proxyUsername", proxyUsername);
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        this.setPropertyToFile("proxyPassword", proxyPassword);
    }

    public static void setInstance(HttpProxyForPush instance) {
        HttpProxyForPush.instance = instance;
    }
}

